/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.ILockListener;
import ch.tachyon.sonics.data.ILockable;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;

public abstract class ViewActionBase
extends ActionBase
implements AudioFileViewListener,
ILockListener {
    private final WeakReference<AudioFile> audioFileRef;
    private AudioFile currentFile;
    private boolean isWriteLocked;

    public ViewActionBase(Session session, AudioFile audioFile) {
        WeakReference<AudioFile> weakReference = this.audioFileRef = audioFile == null ? null : new WeakReference<AudioFile>(audioFile);
        if (audioFile != null) {
            audioFile.getView().addViewListener(this);
            audioFile.addLockListener(this);
            this.isWriteLocked = audioFile.isLockedWrite();
        }
        if (session != null) {
            super.setSession(session);
        }
    }

    protected AudioFile getAudioFile() {
        if (this.audioFileRef != null) {
            return (AudioFile)this.audioFileRef.get();
        }
        if (this.session == null) {
            return null;
        }
        return this.session.getCurrentFile();
    }

    protected final void init() {
        if (this.audioFileRef == null) {
            this.session.addSessionListener(new SessionAdapter(){

                public void currentFileChanged(Session session, AudioFile audioFile) {
                    ViewActionBase.this.setCurrentFile(audioFile);
                    ViewActionBase.this.updateEnabledStatus();
                }
            });
        }
    }

    public void viewChanged(AudioDataView view) {
        this.updateEnabledStatus();
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        this.updateEnabledStatus();
    }

    public void lockStatusChanged(ILockable lockable, boolean readLocked, boolean writeLocked) {
        this.isWriteLocked = writeLocked;
        if (this.session.isOpened(this.getAudioFile())) {
            this.updateEnabledStatus();
        }
    }

    protected void updateEnabledStatus() {
        if (this.isWriteLocked) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        AudioFile audioFile = this.getAudioFile();
        if (audioFile != null) {
            AudioDataView view = audioFile.getView();
            enabled = this.getEnabled(audioFile, view);
        }
        this.setEnabled(enabled);
    }

    protected abstract boolean getEnabled(AudioFile var1, AudioDataView var2);

    private void setCurrentFile(AudioFile file) {
        AudioFile previous = this.currentFile;
        if (this.currentFile != null) {
            this.currentFile.getView().removeViewListener(this);
            this.currentFile.removeLockListener(this);
        }
        this.currentFile = file;
        this.isWriteLocked = false;
        if (this.currentFile != null) {
            this.currentFile.getView().addViewListener(this);
            this.currentFile.addLockListener(this);
            this.isWriteLocked = this.currentFile.isLockedWrite();
        }
        this.currentFileChanged(previous, this.currentFile);
    }

    protected void currentFileChanged(AudioFile previous, AudioFile current) {
    }

    private boolean isTriggeredByKeyboardShortcut(ActionEvent e) {
        return e.getActionCommand() != null && !e.getActionCommand().equals("comboBoxChanged");
    }

    protected final boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioFile file;
        if (!this.isTriggeredByKeyboardShortcut(e)) {
            file = this.getAudioFile();
            AudioFile audioFile = (AudioFile)this.audioFileRef.get();
            if (audioFile != null) {
                this.session.setCurrentFile(audioFile);
            }
        } else {
            file = this.session.getCurrentFile();
        }
        if (file == null) {
            return false;
        }
        AudioDataView view = file.getView();
        this.process(file, view);
        return false;
    }

    protected abstract void process(AudioFile var1, AudioDataView var2);
}

