/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;

public abstract class ViewSelectionActionBase
extends ViewActionBase {
    private final SelectionAdapter selAdapter = new SelAdapter();

    public ViewSelectionActionBase(Session session, AudioFile audioFile) {
        super(session, audioFile);
        if (audioFile != null) {
            audioFile.getSelection().addSelectionListener(this.selAdapter);
        }
    }

    protected void currentFileChanged(AudioFile previous, AudioFile current) {
        if (previous != null) {
            previous.getSelection().removeSelectionListener(this.selAdapter);
        }
        if (current != null) {
            current.getSelection().addSelectionListener(this.selAdapter);
        }
        this.updateEnabledStatus();
    }

    protected void preProcessSelection(AudioFile audioFile) {
    }

    private class SelAdapter
    extends SelectionAdapter {
        private SelAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            if (!isAdjusting) {
                ViewSelectionActionBase.this.updateEnabledStatus();
            }
        }
    }
}

