/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioDataView;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;

public class ZoomInAction
extends ViewActionBase {
    public static final int MIN_VIEW_SPAN = 8;
    private boolean lastHorizontalFit = true;

    public ZoomInAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomInAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Zoom In", 73);
        super.addKeyboardShortcut(73);
        this.setEnabled(audioFile != null);
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        return view.getStopPosition() - view.getStartPosition() > 8L;
    }

    protected void updateEnabledStatus() {
        super.updateEnabledStatus();
        if (this.getToolbarButton() == null) {
            return;
        }
        boolean horizontalFit = this.isHorizontalFit();
        if (!this.lastHorizontalFit && horizontalFit) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZoomInAction.this.getToolbarButton().requestFocusInWindow();
                }
            });
        }
        this.lastHorizontalFit = horizontalFit;
    }

    private boolean isHorizontalFit() {
        AudioFile file = this.getAudioFile();
        if (file == null) {
            return false;
        }
        AudioDataView view = file.getView();
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        return startPos == 0L && stopPos == file.getLength();
    }

    protected void process(AudioFile file, AudioDataView view) {
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        long midRange = (stopPos - startPos) / 2L;
        if (stopPos - startPos <= 8L) {
            return;
        }
        long cursorPos = file.getSelection().getCursorPosition();
        int divisor = !AwtTools.isShiftClick(this.getModifiers()) ? 4 : 32;
        long step = (stopPos - startPos) / (long)divisor;
        if (this.isCursorAloneAndVisible(file, view)) {
            startPos = cursorPos - midRange;
            stopPos = cursorPos + midRange;
        } else if (this.isPlaybackCursorVisible(file, view)) {
            long playbackPos = file.getSelection().getPlaybackPosition();
            startPos = playbackPos - midRange;
            stopPos = playbackPos + midRange;
        }
        stopPos -= step;
        if ((startPos += step) < 0L) {
            stopPos -= startPos;
            startPos = 0L;
        } else if (stopPos > file.getLength()) {
            startPos -= stopPos - file.getLength();
            stopPos = file.getLength();
        }
        startPos = Math.max(0L, startPos);
        stopPos = Math.min(file.getLength(), stopPos);
        view.setVisibleRange(startPos, stopPos);
    }

    private boolean isCursorAloneAndVisible(AudioFile file, AudioDataView view) {
        SelectionInfo selection = file.getSelection();
        long cursorPos = selection.getCursorPosition();
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        if (cursorPos <= 0L || cursorPos < startPos || cursorPos > stopPos) {
            return false;
        }
        for (ISelection sel : selection.getSelections()) {
            long start = sel.getBoundingStartPosition();
            long stop = sel.getBoundingStopPosition();
            if (cursorPos != start && cursorPos != stop) continue;
            return false;
        }
        return true;
    }

    private boolean isPlaybackCursorVisible(AudioFile file, AudioDataView view) {
        Transport transport = Transport.getInstance();
        if (transport.getPlayState() == PlayState.STOP) {
            return false;
        }
        SelectionInfo selection = file.getSelection();
        long cursorPos = selection.getPlaybackPosition();
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        return cursorPos > 0L && cursorPos >= startPos && cursorPos <= stopPos;
    }
}

