/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.gui.AwtTools;

public class ZoomInVertAction
extends ViewActionBase {
    private static final float MIN_VERT_SPAN = (float)AudioMath.dbToLevel(-144.0);
    private boolean lastVerticalFit = true;

    public ZoomInVertAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomInVertAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setText("Zoom In Vertically");
        super.setMnemonic(86);
        super.addKeyboardShortcut(KeyStroke.getKeyStroke(73, 64));
        this.setEnabled(audioFile != null);
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        return view.getVerticalCeil() - view.getVerticalFloor() > MIN_VERT_SPAN * 2.0f;
    }

    protected void updateEnabledStatus() {
        super.updateEnabledStatus();
        if (this.getToolbarButton() == null) {
            return;
        }
        boolean verticalFit = this.isVerticalFit();
        if (!this.lastVerticalFit && verticalFit) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ZoomInVertAction.this.getToolbarButton().requestFocusInWindow();
                }
            });
        }
        this.lastVerticalFit = verticalFit;
    }

    private boolean isVerticalFit() {
        AudioFile file = this.getAudioFile();
        if (file == null) {
            return false;
        }
        AudioDataView view = file.getView();
        return view.getVerticalFloor() == -1.0f && view.getVerticalCeil() == 1.0f;
    }

    protected void process(AudioFile file, AudioDataView view) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        if (ceil - floor <= MIN_VERT_SPAN) {
            return;
        }
        float divisor = !AwtTools.isShiftClick(this.getModifiers()) ? 2.0f : 8.0f;
        float step = (ceil - floor) * (1.0f - (float)Math.sqrt(0.5)) / divisor;
        view.setVerticalRange(ceil -= step, floor += step);
    }
}

