/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import org.corebounce.common.gui.AwtTools;

public class ZoomOutAction
extends ViewActionBase {
    public ZoomOutAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomOutAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Zoom Out", 79);
        super.addKeyboardShortcut(79);
        this.setEnabled(false);
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        return startPos > 0L || stopPos < file.getLength();
    }

    protected void process(AudioFile file, AudioDataView view) {
        int divisor;
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        long step = (stopPos - startPos) / (long)(divisor = !AwtTools.isShiftClick(this.getModifiers()) ? 2 : 30);
        if (step < 1L) {
            step = 1L;
        }
        stopPos += step;
        if ((startPos -= step) < 0L) {
            stopPos -= startPos;
            startPos = 0L;
        } else if (stopPos > file.getLength()) {
            startPos -= stopPos - file.getLength();
            stopPos = file.getLength();
        }
        startPos = Math.max(0L, startPos);
        stopPos = Math.min(file.getLength(), stopPos);
        view.setVisibleRange(startPos, stopPos);
    }
}

