/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import javax.swing.KeyStroke;
import org.corebounce.common.gui.AwtTools;

public class ZoomOutVertAction
extends ViewActionBase {
    private static final float MIN_FLOOR = -2.0f;
    private static final float MAX_CEIL = 2.0f;

    public ZoomOutVertAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomOutVertAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setText("Zoom Out Vertically");
        super.setMnemonic(69);
        super.addKeyboardShortcut(KeyStroke.getKeyStroke(79, 64));
        this.setEnabled(audioFile != null);
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        return view.getVerticalFloor() > -2.0f || view.getVerticalCeil() < 2.0f;
    }

    protected void process(AudioFile file, AudioDataView view) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        float divisor = !AwtTools.isShiftClick(this.getModifiers()) ? 2.0f : 10.414f;
        float step = (ceil - floor) * ((float)Math.sqrt(2.0) - 1.0f) / divisor;
        floor -= step;
        ceil += step;
        if (floor < -2.0f) {
            ceil += -2.0f - floor;
            floor = -2.0f;
        } else if (ceil > 2.0f) {
            floor -= ceil - 2.0f;
            ceil = 2.0f;
        }
        if (floor < -2.0f) {
            floor = -2.0f;
        }
        if (ceil > 2.0f) {
            ceil = 2.0f;
        }
        view.setVerticalRange(ceil, floor);
    }
}

