/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewSelectionActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioDataView;

public class ZoomSelectionStartAction
extends ViewSelectionActionBase {
    private static final int MIN_VIEW_SPAN = 8;

    public ZoomSelectionStartAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomSelectionStartAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Zoom Begin", 66);
        super.setTooltip("Zoom in at the beginning of the selection or file");
        super.addKeyboardShortcut(66);
        this.updateEnabledStatus();
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        SelectionInfo selInfo;
        long startSel;
        long stopPos;
        if (view.getStopPosition() - view.getStartPosition() > 8L) {
            return true;
        }
        long startPos = view.getStartPosition();
        long middlePos = (startPos + (stopPos = view.getStopPosition())) / 2L;
        return middlePos != (startSel = this.getStartSel(selInfo = file.getSelection()));
    }

    protected void process(AudioFile file, AudioDataView view) {
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        SelectionInfo selInfo = file.getSelection();
        long middlePos = (startPos + stopPos) / 2L;
        long startSel = this.getStartSel(selInfo);
        long offset = startSel - middlePos;
        if ((stopPos += offset) - (startPos += offset) > 8L) {
            int divisor = (this.getModifiers() & 1) == 0 ? 4 : 32;
            long step = (stopPos - startPos) / (long)divisor;
            if ((this.getModifiers() & 0xA) == 0) {
                startPos += step;
                stopPos -= step;
            }
        }
        if (startPos < 0L) {
            stopPos -= startPos;
            startPos = 0L;
        } else if (stopPos > file.getLength()) {
            startPos -= stopPos - file.getLength();
            stopPos = file.getLength();
        }
        startPos = Math.max(0L, startPos);
        stopPos = Math.min(file.getLength(), stopPos);
        view.setVisibleRange(startPos, stopPos);
    }

    private long getStartSel(SelectionInfo selInfo) {
        long startSel = selInfo.getBoundingStartPosition();
        if (startSel < 0L) {
            startSel = 4L;
        }
        return startSel;
    }
}

