/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewSelectionActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioDataView;

public class ZoomSelectionStopAction
extends ViewSelectionActionBase {
    private static final int MIN_VIEW_SPAN = 8;

    public ZoomSelectionStopAction() {
        this((Session)null, (AudioFile)null);
    }

    public ZoomSelectionStopAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Zoom End", 69);
        super.setTooltip("Zoom in at the end of the selection or file");
        super.addKeyboardShortcut(69);
        this.updateEnabledStatus();
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        SelectionInfo selInfo;
        long stopSel;
        long stopPos;
        if (view.getStopPosition() - view.getStartPosition() > 8L) {
            return true;
        }
        long startPos = view.getStartPosition();
        long middlePos = (startPos + (stopPos = view.getStopPosition())) / 2L;
        return middlePos != (stopSel = this.getStopSel(file, selInfo = file.getSelection()));
    }

    protected void process(AudioFile file, AudioDataView view) {
        long startPos = view.getStartPosition();
        long stopPos = view.getStopPosition();
        SelectionInfo selInfo = file.getSelection();
        long middlePos = (startPos + stopPos) / 2L;
        long stopSel = this.getStopSel(file, selInfo);
        long offset = stopSel - middlePos;
        if ((stopPos += offset) - (startPos += offset) > 8L) {
            int divisor = (this.getModifiers() & 1) == 0 ? 4 : 32;
            long step = (stopPos - startPos) / (long)divisor;
            if ((this.getModifiers() & 0xA) == 0) {
                startPos += step;
                stopPos -= step;
            }
        }
        if (startPos < 0L) {
            stopPos -= startPos;
            startPos = 0L;
        } else if (stopPos > file.getLength()) {
            startPos -= stopPos - file.getLength();
            stopPos = file.getLength();
        }
        startPos = Math.max(0L, startPos);
        stopPos = Math.min(file.getLength(), stopPos);
        view.setVisibleRange(startPos, stopPos);
    }

    private long getStopSel(AudioFile file, SelectionInfo selInfo) {
        long stopSel = selInfo.getBoundingStopPosition();
        if (stopSel < 0L) {
            stopSel = file.getLength() - 4L;
        }
        return stopSel;
    }
}

