/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.core;

import ch.tachyon.sonics.core.IToolboxItem;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.PluginBundle;
import ch.tachyon.tunnel.plugin.opt.spec.Channels;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.io.ResourceLoader;
import org.corebounce.common.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Effect
implements Comparable<Effect>,
IToolboxItem {
    private PluginBundle bundle;
    private String className;
    private Class<? extends IEffect> hostInterface;
    private String name;
    private String description;
    private Channels channels;
    private SampleRates sampleRates;
    private boolean radioButton;
    private boolean checkbox;
    private boolean toggle;
    private List<Effect> children;
    private Effect parent;

    public Effect() {
    }

    public Effect(IEffect plugin, PluginBundle bundle) {
        this.setBundle(bundle);
        this.setClassName(plugin.getClassName());
        this.setHostInterface(plugin.getInterface());
        this.setName(plugin.getName());
        this.setDescription(plugin.getDescription());
        this.channels = (Channels)plugin.getAnnotation(Channels.class);
    }

    public PluginBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(PluginBundle bundle) {
        this.bundle = bundle;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class<? extends IEffect> getHostInterface() {
        return this.hostInterface;
    }

    public void setHostInterface(Class<? extends IEffect> pluginInterface) {
        this.hostInterface = pluginInterface;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Channels getChannels() {
        return this.channels;
    }

    public void setChannels(Channels channels) {
        this.channels = channels;
    }

    public SampleRates getSampleRates() {
        return this.sampleRates;
    }

    public void setSampleRates(SampleRates sampleRates) {
        this.sampleRates = sampleRates;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRadioButton() {
        return this.radioButton;
    }

    public void setRadioButton(boolean radioButton) {
        this.radioButton = radioButton;
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }

    public void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    @Override
    public List<IToolboxItem> getChildren() {
        if (this.children == null) {
            return null;
        }
        return new ArrayList<IToolboxItem>(this.children);
    }

    public List<Effect> getEffectChildren() {
        return this.children;
    }

    public void setEffectChildren(List<Effect> children) {
        this.children = children;
    }

    public void addChild(Effect effect) {
        if (this.children == null) {
            this.children = new ArrayList<Effect>();
        }
        this.children.add(effect);
        effect.parent = this;
    }

    @Override
    public Effect getParent() {
        return this.parent;
    }

    public Effect getRoot() {
        Effect root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public boolean isCategory() {
        return this.children != null;
    }

    @Override
    public int compareTo(Effect other) {
        if (!this.isCategory() && other.isCategory()) {
            return -1;
        }
        if (this.isCategory() && !other.isCategory()) {
            return 1;
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(result, "");
        return result.toString();
    }

    private void toString(StringBuilder result, String prefix) {
        result.append(prefix);
        result.append(this.getName());
        result.append("\n");
        if (this.children != null) {
            for (Effect child : this.children) {
                child.toString(result, String.valueOf(prefix) + "  ");
            }
        }
    }

    public static List<Effect> loadDemoList() {
        ArrayList<Effect> result = new ArrayList<Effect>();
        Effect parent = null;
        int parentLevel = -1;
        try {
            BufferedReader reader = (BufferedReader)ResourceLoader.getResourceReader(Effect.class, "Effects.txt");
            String line = reader.readLine();
            while (line != null) {
                if (!StringUtils.isBlank(line)) {
                    int level = 0;
                    char ch = line.charAt(0);
                    while (ch == ' ') {
                        ch = line.charAt(++level);
                    }
                    line = line.substring(level);
                    Effect effect = new Effect();
                    int inLevel = (level /= 2) - 1;
                    while (inLevel < parentLevel) {
                        parent = parent.getParent();
                        ++inLevel;
                    }
                    if (parent == null) {
                        result.add(effect);
                    } else {
                        parent.addChild(effect);
                    }
                    parent = effect;
                    parentLevel = level;
                    if (line.startsWith("[] ")) {
                        line = line.substring("[] ".length());
                        effect.children = new ArrayList<Effect>();
                    } else if (line.startsWith("o ")) {
                        line = line.substring("o ".length());
                    } else if (line.startsWith("x ")) {
                        line = line.substring("x ".length());
                        effect.setRadioButton(true);
                    } else if (line.startsWith("+ ")) {
                        line = line.substring("+ ".length());
                        effect.setCheckbox(true);
                    } else if (line.startsWith("* ")) {
                        line = line.substring("* ".length());
                        effect.setToggle(true);
                    }
                    effect.setName(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException();
        }
        return result;
    }

    public static void main(String[] args) {
        List<Effect> effects = Effect.loadDemoList();
        for (Effect effect : effects) {
            System.out.println(effect.toString());
        }
    }
}

