/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.core;

import ch.tachyon.sonics.TachyonSonics;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.IPushEffect;
import ch.tachyon.tunnel.host.ISimpleEffect;
import ch.tachyon.tunnel.host.ISingleChanEffect;
import ch.tachyon.tunnel.host.ISingleChanPullEffect;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.host.PluginBundle;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corebounce.common.utils.AppUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectLoader {
    public static final String PLUGINS_DIR = "plugins";
    public static final String CORE_PLUGINS_JAR = "plugins/Core-Plugins.jar";
    public static final String TRANSFORMATIONS_GROUP = "Transformations";
    private static final Map<String, String> categoryMapper = new HashMap<String, String>();

    static {
        categoryMapper.put("amplitude", "Amplitude & Dynamics");
        categoryMapper.put("dynamics", "Amplitude & Dynamics");
        categoryMapper.put("channels", "Channels & Mixing");
        categoryMapper.put("mixing", "Channels & Mixing");
        categoryMapper.put("separation", "Extraction & Separation");
        categoryMapper.put("filters", "Frequency Filters");
        categoryMapper.put("frequency", "Frequency Filters");
        categoryMapper.put("tempo", "Tempo & Pitch");
        categoryMapper.put("pitch", "Tempo & Pitch");
        categoryMapper.put("distortion", "Timbre & Distortion");
        categoryMapper.put("timbre", "Timbre & Distortion");
        categoryMapper.put("time", "Time & Reverb");
        categoryMapper.put("reverb", "Time & Reverb");
        categoryMapper.put("restoration", "Restoration");
    }

    public static List<Effect> loadEffects() throws IOException {
        ArrayList<Effect> result = new ArrayList<Effect>();
        Effect root = new Effect();
        root.setName(TRANSFORMATIONS_GROUP);
        root.setEffectChildren(new ArrayList<Effect>());
        File source = new File(AppUtils.getApplicationDirectory(TachyonSonics.class), CORE_PLUGINS_JAR);
        if (!source.exists()) {
            Debug.warn((String)"Core Plugins library \"{0}\" cannot be found", (Object[])new Object[]{source});
            source = new File("../ch.tachyon.sonics.effects/bin");
        }
        Class[] pluginInterfaces = new Class[]{ISingleChanEffect.class, ISimpleEffect.class, ISingleChanPullEffect.class, ISingleChanPushEffect.class, IPushEffect.class};
        PluginBundle bundle = new PluginBundle(source, true);
        List plugins = bundle.loadAllPlugins(pluginInterfaces);
        for (IEffect plugin : plugins) {
            Effect effect = new Effect(plugin, bundle);
            Effect category = EffectLoader.lookupCategoryFor(plugin, root);
            category.addChild(effect);
        }
        bundle.releaseLoader();
        EffectLoader.sortEffectTree(root);
        for (Effect effect : root.getEffectChildren()) {
            result.add(effect);
        }
        return result;
    }

    private static void sortEffectTree(Effect node) {
        if (node.getChildren() != null) {
            Collections.sort(node.getEffectChildren(), new Comparator<Effect>(){

                @Override
                public int compare(Effect o1, Effect o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (Effect child : node.getEffectChildren()) {
                EffectLoader.sortEffectTree(child);
            }
        }
    }

    private static String[] mapCategories(String[] categories) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < categories.length) {
            String category = categories[i];
            if (i == 0) {
                String mapped = categoryMapper.get(category.trim().toLowerCase());
                if (mapped == null) {
                    result.add("Other");
                    result.add(category);
                } else {
                    result.add(mapped);
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static Effect lookupCategoryFor(IEffect plugin, Effect root) {
        String categoryName = plugin.getCategory();
        if (categoryName == null || categoryName.trim().equals("")) {
            categoryName = "Other";
        }
        String[] categories = categoryName.split(":");
        categories = EffectLoader.mapCategories(categories);
        Effect result = root;
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            Effect next = null;
            for (Effect child : result.getEffectChildren()) {
                if (!child.getName().equals(category) || child.getChildren() == null) continue;
                next = child;
            }
            if (next == null) {
                next = new Effect();
                next.setName(category);
                next.setEffectChildren(new ArrayList<Effect>());
                result.addChild(next);
            }
            result = next;
            ++n2;
        }
        return result;
    }
}

