/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.core;

import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.PluginBundle;
import ch.tachyon.tunnel.host.Storage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EffectPresets {
    private static final Map<String, byte[]> sessionDefaults = new HashMap<String, byte[]>();

    public static void storeEffectSessionDefaults(PluginBundle bundle, IEffect effect) throws IOException, InvocationTargetException {
        String key = String.valueOf(bundle.getUrlString()) + ":" + effect.getClassName();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Storage.storeParameterValues((Collection)effect.getParameters(), (OutputStream)output);
        sessionDefaults.put(key, output.toByteArray());
    }

    public static void loadEffectSessionDefaults(PluginBundle bundle, IEffect effect) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String key = String.valueOf(bundle.getUrlString()) + ":" + effect.getClassName();
        byte[] data = sessionDefaults.get(key);
        if (data == null) {
            return;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        Storage.loadParameterValues((InputStream)input, (PluginBundle)bundle, (Collection)effect.getParameters());
    }
}

