/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.core;

import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.corebounce.common.audio.device.AudioException;
import org.corebounce.common.audio.device.AudioIO;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.OperationAbortedException;

public class Player
extends Thread {
    private static final int CURSOR_UPDATE_DEFAULT_RATE = 50;
    private final Transport transport;
    private final AudioFile audioFile;
    private final float sampleRate;
    private AudioIO device;
    private volatile boolean paused;
    private volatile boolean disabled;
    private long currentPosition;
    private long logicalPosition;
    private long requestedNewPosition = -1L;
    private int nbFrames;
    private int nbChannels;
    private float[][] buffer;
    private boolean isBufferZero;
    private Timer timer;
    private TimerTask timerTask;
    private long prevPos = -1L;
    private long prevTime = -1L;
    private final Object lock = new Monitor("Player prevLock");
    private volatile boolean cursorUpdated;

    public Player(Transport transport, AudioFile audioFile) {
        super("Audio Player");
        super.setPriority(10);
        this.transport = transport;
        this.audioFile = audioFile;
        this.sampleRate = audioFile.getSampleRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAudioDevice() {
        AudioIO audioIO = this.device;
        synchronized (audioIO) {
            this.device.releasePlayBack();
            this.nbFrames = this.buffer[0].length;
            int nbBuffers = this.device.preferredNumberOfBuffers();
            try {
                this.device.requestPlayBack(0, this.audioFile.getNbChannels(), (int)(this.audioFile.getSampleRate() + 0.5f), this.nbFrames, nbBuffers);
            }
            catch (AudioException ex) {
                Debug.error((String)"Failed to open audio device: {0}", (Throwable)ex);
                this.transport.setPlayState(PlayState.STOP);
            }
        }
    }

    public synchronized void seek(long newPosition, boolean immediate) {
        if (this.device == null) {
            this.currentPosition = newPosition;
            this.logicalPosition = newPosition;
        } else if (this.paused || immediate) {
            this.disabled = true;
            this.resetAudioDevice();
            this.disabled = false;
            this.currentPosition = newPosition;
            this.logicalPosition = newPosition;
        } else {
            this.requestedNewPosition = newPosition;
        }
    }

    private synchronized boolean handleManualSeek() {
        if (this.requestedNewPosition >= 0L) {
            this.currentPosition = this.requestedNewPosition;
            this.logicalPosition = this.requestedNewPosition;
            this.requestedNewPosition = -1L;
            return true;
        }
        return false;
    }

    private synchronized long seekDelta(long offset, long logical) {
        this.currentPosition += offset;
        this.logicalPosition += logical;
        return this.currentPosition;
    }

    private synchronized long getCurrentPosition() {
        return this.currentPosition;
    }

    private synchronized void reset() {
        this.currentPosition = -1L;
    }

    private synchronized long getLogicalPosition() {
        return this.logicalPosition;
    }

    private long getPlaybackPosition() {
        long startPos;
        long logicalPos = this.getLogicalPosition();
        long result = logicalPos - (long)this.device.getPlayBufferSize();
        if (this.transport.isLooping() && result < (startPos = this.transport.getLoopStartPosition()) && logicalPos >= startPos) {
            long stopPos = this.transport.getStopPosition();
            result += stopPos - startPos;
        }
        return result;
    }

    public synchronized void start() {
        super.start();
        this.timerTask = new TimerTask(){

            public void run() {
                Player.this.updatePlaybackPosition();
            }
        };
        int refreshRate = AwtTools.getScreenRefreshRate();
        if (refreshRate == 0) {
            refreshRate = 50;
        }
        int period = Math.max(5, Math.min(100, 1000 / refreshRate));
        this.timer = new Timer("Playback Cursor", true);
        this.timer.schedule(this.timerTask, period, (long)period);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            this.cursorUpdated = false;
            this.nbChannels = this.audioFile.getNbChannels();
            this.seek(this.transport.getStartPosition(), false);
            this.device = AudioIO.instance();
            try {
                try {
                    PlayState state;
                    this.nbFrames = this.device.preferredFrameSize();
                    int nbBuffers = this.device.preferredNumberOfBuffers();
                    this.buffer = new float[this.nbChannels][this.nbFrames];
                    try {
                        this.device.requestPlayBack(0, this.audioFile.getNbChannels(), (int)(this.audioFile.getSampleRate() + 0.5f), this.nbFrames, nbBuffers);
                    }
                    catch (AudioException ex) {
                        Debug.error((String)"Failed to open audio device: {0}", (Throwable)ex);
                        this.transport.setPlayState(PlayState.STOP);
                    }
                    PlayState prevState = state = this.transport.getPlayState();
                    this.audioFile.getSelection().setPlaybackPaused(state == PlayState.PAUSE);
                    this.audioFile.getSelection().setPlaybackPosition(this.getPlaybackPosition());
                    while (state != PlayState.STOP) {
                        if (state == PlayState.PAUSE) {
                            this.pause();
                        } else if (this.transport.isLooping()) {
                            this.playLoop();
                        } else {
                            this.play();
                        }
                        state = this.transport.getPlayState();
                        if (state != prevState) {
                            this.audioFile.getSelection().setPlaybackPaused(state == PlayState.PAUSE);
                        }
                        prevState = state;
                        this.playbackPositionChanged(this.getPlaybackPosition());
                    }
                }
                catch (AudioException ex) {
                    Debug.error((String)"Failed to play audio", (Throwable)ex);
                    this.transport.setPlayState(PlayState.STOP);
                    this.timer.cancel();
                    this.reset();
                    this.device.releasePlayBack();
                    SelectionInfo selInfo = this.audioFile.getSelection();
                    if (!this.cursorUpdated) {
                        selInfo.setCursorPosition(selInfo.getPlaybackPosition());
                    }
                    selInfo.setPlaybackPosition(-1L);
                }
                catch (IllegalArgumentException ex) {
                    Debug.error((String)"Failed to play audio", (Throwable)ex);
                    this.transport.setPlayState(PlayState.STOP);
                    this.timer.cancel();
                    this.reset();
                    this.device.releasePlayBack();
                    SelectionInfo selInfo = this.audioFile.getSelection();
                    if (!this.cursorUpdated) {
                        selInfo.setCursorPosition(selInfo.getPlaybackPosition());
                    }
                    selInfo.setPlaybackPosition(-1L);
                }
                catch (IOException ex) {
                    Debug.error((String)"Failed to read audio", (Throwable)ex);
                    this.transport.setPlayState(PlayState.STOP);
                    this.timer.cancel();
                    this.reset();
                    this.device.releasePlayBack();
                    SelectionInfo selInfo = this.audioFile.getSelection();
                    if (!this.cursorUpdated) {
                        selInfo.setCursorPosition(selInfo.getPlaybackPosition());
                    }
                    selInfo.setPlaybackPosition(-1L);
                    break block21;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.timer.cancel();
                this.reset();
                this.device.releasePlayBack();
                SelectionInfo selInfo = this.audioFile.getSelection();
                if (!this.cursorUpdated) {
                    selInfo.setCursorPosition(selInfo.getPlaybackPosition());
                }
                selInfo.setPlaybackPosition(-1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pause() throws AudioException {
        this.paused = true;
        if (this.device.setPaused(true)) {
            ThreadUtils.sleep((int)20);
            return;
        }
        if (!this.isBufferZero) {
            int chan = 0;
            while (chan < this.nbChannels) {
                Arrays.fill(this.buffer[chan], 0.0f);
                ++chan;
            }
            this.isBufferZero = true;
        }
        AudioIO audioIO = this.device;
        synchronized (audioIO) {
            this.device.play(this.buffer);
        }
        this.handleManualSeek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play() throws AudioException, IOException {
        int read;
        if (this.paused) {
            this.device.setPaused(false);
            this.paused = false;
        }
        this.isBufferZero = false;
        long currentPosition = this.getCurrentPosition();
        long stopPosition = this.transport.getStopPosition();
        int amount = (int)Math.min((long)this.nbFrames, stopPosition - currentPosition);
        if (amount <= 0) {
            this.device.drain();
            this.transport.setPlayState(PlayState.STOP);
            SelectionInfo selInfo = this.audioFile.getSelection();
            selInfo.setCursorPosition(this.transport.getStartPosition());
            this.cursorUpdated = true;
            return;
        }
        boolean locked = this.lockRead();
        if (locked) {
            try {
                read = this.audioFile.getData().read(null, currentPosition, this.buffer, this.nbFrames);
            }
            finally {
                this.unlockRead();
            }
        } else {
            int c = 0;
            while (c < this.buffer.length) {
                Arrays.fill(this.buffer[c], 0.0f);
                ++c;
            }
            read = this.nbFrames;
        }
        if ((amount = Math.min(amount, read)) <= 0) {
            this.transport.setPlayState(PlayState.STOP);
            SelectionInfo selInfo = this.audioFile.getSelection();
            selInfo.setCursorPosition(this.transport.getStartPosition());
            this.cursorUpdated = true;
            return;
        }
        if (amount < this.nbFrames) {
            int chan = 0;
            while (chan < this.nbChannels) {
                Arrays.fill(this.buffer[chan], amount, this.nbFrames, 0.0f);
                ++chan;
            }
        }
        AudioIO audioIO = this.device;
        synchronized (audioIO) {
            this.device.play(this.buffer);
        }
        if (!this.handleManualSeek()) {
            this.seekDelta(amount, this.nbFrames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playLoop() throws AudioException, IOException {
        if (this.paused) {
            this.device.setPaused(false);
            this.paused = false;
        }
        this.isBufferZero = false;
        int remaining = this.nbFrames;
        int offset = 0;
        while (remaining > 0) {
            long currentPosition = this.getCurrentPosition();
            long stopPosition = this.transport.getStopPosition();
            int amount = (int)Math.min((long)remaining, stopPosition - currentPosition);
            if (amount > 0) {
                boolean locked = this.lockRead();
                if (locked) {
                    try {
                        int chan = 0;
                        while (chan < this.nbChannels) {
                            AudioChannel channel = this.audioFile.getData().getChannel(chan, true);
                            int chanAmount = channel.read(currentPosition, this.buffer[chan], offset, amount);
                            if (chanAmount < amount) {
                                Arrays.fill(this.buffer[chan], offset + chanAmount, offset + amount, 0.0f);
                            }
                            ++chan;
                        }
                    }
                    finally {
                        this.unlockRead();
                    }
                } else {
                    int c = 0;
                    while (c < this.buffer.length) {
                        Arrays.fill(this.buffer[c], offset, offset + amount, 0.0f);
                        ++c;
                    }
                }
            } else {
                amount = 0;
            }
            remaining -= amount;
            offset += amount;
            if (!this.handleManualSeek()) {
                this.seekDelta(amount, amount);
            }
            if ((currentPosition = this.getCurrentPosition()) < stopPosition) continue;
            currentPosition = this.transport.getLoopStartPosition();
            if (currentPosition < 0L || currentPosition >= stopPosition) {
                currentPosition = this.transport.getStartPosition();
            }
            this.seek(currentPosition, false);
        }
        AudioIO audioIO = this.device;
        synchronized (audioIO) {
            this.device.play(this.buffer);
        }
    }

    private boolean lockRead() {
        try {
            String owner = this.audioFile.lockRead("Player", false, null);
            return owner == null;
        }
        catch (OperationAbortedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void unlockRead() {
        this.audioFile.unlockRead("Player");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playbackPositionChanged(long newPosition) {
        Object object = this.lock;
        synchronized (object) {
            this.prevPos = newPosition;
            this.prevTime = System.currentTimeMillis();
        }
        if (this.paused) {
            this.audioFile.getSelection().setPlaybackPosition(newPosition);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlaybackPosition() {
        long basePos;
        long elapsed;
        if (this.paused || this.disabled) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            elapsed = System.currentTimeMillis() - this.prevTime;
            basePos = this.prevPos;
        }
        if (basePos < 0L) {
            return;
        }
        long offset = (long)(this.sampleRate * (float)elapsed / 1000.0f);
        this.audioFile.getSelection().setPlaybackPosition(basePos + offset);
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }
}

