/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.core;

import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Player;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transport
implements IDisposable {
    private static Transport instance = null;
    private Player player;
    private PlayState playState = PlayState.STOP;
    private boolean looping = false;
    private boolean selectionOnly = false;
    private boolean scrolling = false;
    private List<TransportAdapter> adapters = new ArrayList<TransportAdapter>();
    private AudioFile audioFile;
    private long startPosition;
    private long loopStartPosition = -1L;
    private long stopPosition;

    private Transport() {
    }

    public static synchronized Transport getInstance() {
        if (instance == null) {
            instance = new Transport();
        }
        return instance;
    }

    public synchronized PlayState getPlayState() {
        return this.playState;
    }

    public void setPlayState(PlayState playState) {
        PlayState oldPlayState = this.playState;
        if (playState == PlayState.STOP) {
            this.stop();
        } else {
            this.start(playState);
        }
        if (oldPlayState != this.playState) {
            for (TransportAdapter adapter : this.adapters()) {
                adapter.playStateChanged(this, oldPlayState, playState);
            }
        }
    }

    public void initRangeAndLoop() {
        if (this.audioFile == null) {
            return;
        }
        SelectionInfo selection = this.audioFile.getSelection();
        long cursor = selection.getCursorPosition();
        if (cursor < 0L) {
            cursor = 0L;
        }
        if (cursor >= this.audioFile.getLength()) {
            cursor = 0L;
        }
        this.setStartPosition(cursor);
        if (this.isSelectionOnly()) {
            long start = selection.getBoundingStartPosition();
            if (start >= 0L) {
                this.setLoopStartPosition(start);
            } else {
                this.setLoopStartPosition(0L);
            }
            long stop = selection.getBoundingStopPosition();
            if (stop >= 0L && stop > cursor && stop > start) {
                this.setStopPosition(stop);
            } else {
                this.setStopPosition(this.audioFile.getLength());
            }
        } else {
            this.setLoopStartPosition(0L);
            this.setStopPosition(this.audioFile.getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Transport transport = this;
        synchronized (transport) {
            this.playState = PlayState.STOP;
        }
        if (this.player != null) {
            if (Thread.currentThread() != this.player) {
                ThreadUtils.join((Thread)this.player, (long)3000L);
            }
            this.player = null;
        }
        this.audioFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(PlayState playState) {
        assert (playState != PlayState.STOP);
        if (this.audioFile == null) {
            throw new IllegalStateException("No Audio file to play");
        }
        if (this.startPosition >= this.stopPosition) {
            throw new IllegalArgumentException("startPosition <= stopPosition");
        }
        if (this.player != null && this.player.getAudioFile() != this.audioFile) {
            this.stop();
        }
        Transport transport = this;
        synchronized (transport) {
            this.playState = playState;
        }
        if (this.player == null) {
            this.player = new Player(this, this.audioFile);
            this.player.start();
        }
    }

    public synchronized boolean isLooping() {
        return this.looping;
    }

    public synchronized void setLooping(boolean looping) {
        if (looping == this.looping) {
            return;
        }
        this.looping = looping;
        for (TransportAdapter adapter : this.adapters()) {
            adapter.loopModeChanged(this, looping);
        }
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public void setSelectionOnly(boolean selectionOnly) {
        this.selectionOnly = selectionOnly;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    public void setScrolling(boolean scroll) {
        this.scrolling = scroll;
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }

    public void setAudioFile(AudioFile audioFile) {
        this.audioFile = audioFile;
    }

    public synchronized long getStartPosition() {
        return this.startPosition;
    }

    public synchronized void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    public synchronized long getLoopStartPosition() {
        return this.loopStartPosition;
    }

    public synchronized void setLoopStartPosition(long loopStartPosition) {
        this.loopStartPosition = loopStartPosition;
    }

    public synchronized long getStopPosition() {
        return this.stopPosition;
    }

    public synchronized void setStopPosition(long stopPosition) {
        this.stopPosition = stopPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TransportAdapter> adapters() {
        List<TransportAdapter> list = this.adapters;
        synchronized (list) {
            return new ArrayList<TransportAdapter>(this.adapters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportAdapter(TransportAdapter adapter) {
        List<TransportAdapter> list = this.adapters;
        synchronized (list) {
            if (!this.adapters.contains(adapter)) {
                this.adapters.add(adapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportAdapter(TransportAdapter adapter) {
        if (this.adapters == null) {
            return;
        }
        List<TransportAdapter> list = this.adapters;
        synchronized (list) {
            this.adapters.remove(adapter);
        }
    }

    @Override
    public void dispose() {
        this.setPlayState(PlayState.STOP);
        this.setAudioFile(null);
        this.adapters = null;
    }

    public boolean seek(long position) {
        if (this.player != null) {
            this.player.seek(position, true);
        }
        return this.player != null;
    }
}

