/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data;

import ch.tachyon.sonics.data.ClipboardListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.corebounce.common.audio.file.AudioFiles;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.io.RandomFileInputStream;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioClipboard
implements Transferable,
ClipboardOwner,
IDisposable {
    private static final List<String> audioMimeTypes = new ArrayList<String>();
    private static final Map<String, String> mimeType2extension = new HashMap<String, String>();
    private static final Map<String, String> mimeType2sysName = new HashMap<String, String>();
    private AudioFile content;
    private File contentFile;
    private boolean writeFileList;
    private boolean owning;
    private final List<ClipboardListener> clipboardListeners = new ArrayList<ClipboardListener>();
    private boolean useSystemClipboard;
    private Clipboard systemClipboard;
    private DataFlavor systemClipboardDataFlavor = null;
    private volatile transient IProgressMonitor writeProgress;
    private static AudioClipboard instance = null;

    public static synchronized AudioClipboard getInstance() {
        if (instance == null) {
            instance = new AudioClipboard();
        }
        return instance;
    }

    private AudioClipboard() {
        if (Platform.isWindows()) {
            this.addType("audio/wav", ".wav", "WAVE");
            this.writeFileList = false;
        } else if (Platform.isMacOsX()) {
            this.addType("audio/x-aiff", ".aiff", "AIFF");
            this.writeFileList = false;
        } else if (Platform.isUnixLikePlatform()) {
            this.addType("audio/basic", ".au", "audio/basic");
            this.writeFileList = false;
        } else {
            this.addType("audio/wav", ".wav", "WAVE");
            this.addType("audio/basic", ".au", "audio/basic");
            this.addType("audio/x-aiff", ".aiff", "AIFF");
            this.writeFileList = true;
        }
        try {
            for (String mimeType : audioMimeTypes) {
                DataFlavor audioFlavor = new DataFlavor(mimeType);
                String sysName = mimeType2sysName.get(mimeType);
                SystemFlavorMap sfm = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
                sfm.addFlavorForUnencodedNative(sysName, audioFlavor);
                sfm.addUnencodedNativeForFlavor(audioFlavor, sysName);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this.systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.systemClipboard.addFlavorListener(new FlavorListener(){

                public void flavorsChanged(FlavorEvent e) {
                    AudioClipboard.this.updateSystemClipboardFlavor();
                }
            });
            this.updateSystemClipboardFlavor();
        }
        catch (HeadlessException ex) {
            this.systemClipboard = null;
        }
    }

    private void addType(String mimeType, String fileExtension, String sysName) {
        audioMimeTypes.add(mimeType);
        mimeType2extension.put(mimeType, fileExtension);
        mimeType2sysName.put(mimeType, sysName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemClipboardFlavor() {
        if (!this.useSystemClipboard) {
            return;
        }
        Debug.info((String)"updateSystemClipboardFlavor", (Object[])new Object[0]);
        AudioClipboard audioClipboard = this;
        synchronized (audioClipboard) {
            DataFlavor flavor = null;
            try {
                DataFlavor[] dataFlavorArray = this.systemClipboard.getAvailableDataFlavors();
                int n = dataFlavorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataFlavor f = dataFlavorArray[n2];
                    Debug.info((String)"Flavor {0} found", (Object[])new Object[]{f.getMimeType()});
                    String mimeType = this.getMimeType(f);
                    if (f.isFlavorJavaFileListType() || audioMimeTypes.contains(mimeType)) {
                        flavor = f;
                        Debug.info((String)"Flavor {0} accepted", (Object[])new Object[]{mimeType});
                        break;
                    }
                    ++n2;
                }
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
            this.systemClipboardDataFlavor = flavor;
        }
        this.fireClipboardChanged();
    }

    private String getMimeType(DataFlavor f) {
        String mimeType = f.getMimeType();
        int sepIndex = mimeType.indexOf(59);
        if (sepIndex > 0) {
            mimeType = mimeType.substring(0, sepIndex);
        }
        return mimeType;
    }

    private void readFromSystemClipboard(IProgressMonitor progress) {
        block17: {
            if (!this.useSystemClipboard) {
                return;
            }
            Debug.info((String)"readFromSystemClipboard", (Object[])new Object[0]);
            DataFlavor flavor = this.systemClipboardDataFlavor;
            String mimeType = this.getMimeType(flavor);
            String fileName = "Dummy" + mimeType2extension.get(mimeType);
            try {
                Object content = this.systemClipboard.getData(flavor);
                if (content == null) {
                    return;
                }
                Debug.info((String)"Clipboard content type: {0}", (Object[])new Object[]{mimeType});
                if (content instanceof InputStream) {
                    InputStream input = (InputStream)content;
                    AudioFile file = new AudioFile();
                    try {
                        file.loadContentFromStream(input, fileName, progress, input.available());
                        this.clear();
                        this.content = file;
                    }
                    catch (UnsupportedAudioFileException ex) {
                        ex.printStackTrace();
                    }
                    catch (OperationAbortedException ex) {}
                    break block17;
                }
                if (content instanceof List) {
                    List items = (List)content;
                    this.content = null;
                    int i = 0;
                    while (i < items.size()) {
                        if (items.get(i) instanceof File) {
                            File path = (File)items.get(0);
                            AudioFile file = new AudioFile();
                            RandomFileInputStream fStream = new RandomFileInputStream(path);
                            Debug.info((String)"Loading clipboard file {0}", (Object[])new Object[]{path.getPath()});
                            try {
                                file.loadContentFromStream(fStream, path.getName(), progress, path.length());
                                this.content = file;
                                break;
                            }
                            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                            }
                            catch (OperationAbortedException ex) {
                                break;
                            }
                        }
                        ++i;
                    }
                    if (this.content == null) {
                        Message.warn("None of the files from the clipboard could be retrieved", new Object[0]);
                    }
                    break block17;
                }
                Debug.warn((String)"Clipboard content is not an input stream but a {0}", (Object[])new Object[]{content.getClass().getName()});
            }
            catch (UnsupportedFlavorException ex) {
                Debug.warn((String)"Cannot read system clipboard because the flavor is not supported", (Object[])new Object[0]);
            }
            catch (IOException ex) {
                Debug.warn((String)"I/O error while reading system clipboard: {0}", (Object[])new Object[]{ex.getMessage()});
            }
            catch (IllegalStateException ex) {
                Debug.warn((String)"Cannot read system clipboard because it is in use", (Object[])new Object[0]);
            }
        }
    }

    private void writeToSystemClipboard(IProgressMonitor progress) {
        if (!this.useSystemClipboard) {
            return;
        }
        this.deleteContentFile();
        Debug.info((String)"Writing to system clipboard", (Object[])new Object[0]);
        try {
            try {
                this.writeProgress = progress;
                this.systemClipboard.setContents(this, this);
            }
            catch (IllegalStateException illegalStateException) {
                this.writeProgress = null;
            }
        }
        finally {
            this.writeProgress = null;
        }
    }

    public boolean getUseSystemClipboard() {
        return this.useSystemClipboard;
    }

    public void setUseSystemClipboard(boolean useSystemClipboard) {
        this.useSystemClipboard = useSystemClipboard;
        this.updateSystemClipboardFlavor();
        this.fireClipboardChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AudioClipboard audioClipboard = this;
        synchronized (audioClipboard) {
            if (this.content != null) {
                this.content.dispose();
            }
            this.content = null;
        }
        this.fireClipboardChanged();
    }

    public synchronized boolean hasAudioContent() {
        if (this.systemClipboardDataFlavor != null && this.useSystemClipboard) {
            return true;
        }
        return this.content != null && this.content.getLength() > 0L;
    }

    public synchronized AudioFile getContent(IProgressMonitor progress) {
        if (this.systemClipboardDataFlavor != null && !this.owning && this.useSystemClipboard) {
            progress.setText("Loading audio clip from system clipboard", new Object[0]);
            this.readFromSystemClipboard(progress);
        }
        return this.content;
    }

    public synchronized AudioFile getLocalContent() {
        if (this.systemClipboardDataFlavor != null && !this.owning && this.useSystemClipboard) {
            return null;
        }
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(AudioFile content) {
        AudioClipboard audioClipboard = this;
        synchronized (audioClipboard) {
            if (this.content == content) {
                return;
            }
            this.clear();
            this.content = content;
            this.systemClipboardDataFlavor = null;
            this.owning = true;
        }
        this.fireClipboardChanged();
    }

    public synchronized AudioFile newContent(AudioFile fromFile) throws IOException {
        this.clear();
        this.systemClipboardDataFlavor = null;
        this.content = new AudioFile();
        this.content.copyAttributesFrom(fromFile);
        int i = 0;
        while (i < fromFile.getData().getNbChannels()) {
            this.content.getData().addChannel(i);
            ++i;
        }
        return this.content;
    }

    public void contentUpdated(IProgressMonitor progress) {
        this.owning = true;
        this.fireClipboardChanged();
        this.writeToSystemClipboard(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClipboardListener(ClipboardListener listener) {
        List<ClipboardListener> list = this.clipboardListeners;
        synchronized (list) {
            if (!this.clipboardListeners.contains(listener)) {
                this.clipboardListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClipboardListener(ClipboardListener listener) {
        List<ClipboardListener> list = this.clipboardListeners;
        synchronized (list) {
            this.clipboardListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ClipboardListener> clipboardListeners() {
        List<ClipboardListener> list = this.clipboardListeners;
        synchronized (list) {
            return new ArrayList<ClipboardListener>(this.clipboardListeners);
        }
    }

    private void fireClipboardChanged() {
        for (ClipboardListener listener : this.clipboardListeners()) {
            listener.clipboardChanged(this);
        }
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        if (this.content == null) {
            return new DataFlavor[0];
        }
        ArrayList<DataFlavor> result = new ArrayList<DataFlavor>();
        for (String mimeType : audioMimeTypes) {
            DataFlavor flavor = new DataFlavor(mimeType, String.valueOf(mimeType2sysName.get(mimeType)) + " Audio Clip");
            result.add(flavor);
        }
        if (this.writeFileList) {
            result.add(DataFlavor.javaFileListFlavor);
        }
        return result.toArray(new DataFlavor[result.size()]);
    }

    @Override
    public synchronized boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.writeFileList && flavor.isFlavorJavaFileListType()) {
            return true;
        }
        Debug.info((String)"Requested support for MIME type: {0}, primary: {1}", (Object[])new Object[]{flavor.getMimeType(), this.getMimeType(flavor)});
        return audioMimeTypes.contains(this.getMimeType(flavor));
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Debug.info((String)"Requested read of MIME type: {0}, primary: {1}", (Object[])new Object[]{flavor.getMimeType(), this.getMimeType(flavor)});
        if (this.content == null) {
            return null;
        }
        if (this.writeFileList && flavor.isFlavorJavaFileListType()) {
            AudioFiles af = AudioFiles.instance();
            AudioFileFormat.Type writeType = af.getPlatformDefaultType();
            this.content.setWriteFormat(writeType);
            this.contentFile = File.createTempFile("Audio", "." + writeType.getExtension());
            if (this.writeProgress != null) {
                this.writeProgress.setText("Writing to system clipboard as audio file", new Object[0]);
            }
            this.content.saveContentToStream(this.writeProgress, new FileOutputStream(this.contentFile));
            ArrayList<File> result = new ArrayList<File>(1);
            result.add(this.contentFile);
            return result;
        }
        final String mimeType = this.getMimeType(flavor);
        if (!audioMimeTypes.contains(mimeType)) {
            throw new UnsupportedFlavorException(flavor);
        }
        String extension = mimeType2extension.get(mimeType);
        AudioFileFormat.Type writeType = AudioFiles.instance().getWritableType4ext("dummy" + extension);
        this.content.setWriteFormat(writeType);
        PipedInputStream input = new PipedInputStream();
        final PipedOutputStream output = new PipedOutputStream(input);
        final AudioFile trContent = this.content;
        Runnable tranferrer = new Runnable(){

            public void run() {
                try {
                    try {
                        if (AudioClipboard.this.writeProgress != null) {
                            AudioClipboard.this.writeProgress.setText("Writing to system clipboard as \"{0}\" data", mimeType);
                        }
                        trContent.saveContentToStream(AudioClipboard.this.writeProgress, new BufferedOutputStream(output));
                        Debug.info((String)"Clipboard transfer successfull", (Object[])new Object[0]);
                    }
                    catch (IllegalArgumentException ex) {
                        Debug.warn((Throwable)ex);
                        IOUtils.close(output);
                    }
                    catch (IOException ex) {
                        Debug.warn((Throwable)ex);
                        IOUtils.close(output);
                    }
                }
                finally {
                    IOUtils.close(output);
                }
            }
        };
        Thread transferThread = new Thread(tranferrer, "Clipboard reader");
        transferThread.start();
        return new BufferedInputStream(input);
    }

    private void deleteContentFile() {
        if (this.contentFile != null) {
            this.contentFile.delete();
            this.contentFile = null;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        Debug.info((String)"Lost ownership; new content {0}", (Object[])new Object[]{contents});
        this.owning = false;
        this.deleteContentFile();
    }

    @Override
    public void dispose() {
        this.deleteContentFile();
        this.clear();
    }
}

