/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data;

import ch.tachyon.sonics.data.ILockListener;
import ch.tachyon.sonics.data.ILockable;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class LockableImpl
implements ILockable {
    private static final long POLL_INTERVAL_MS = 500L;
    private final ILockable target;
    private final List<String> readers = new ArrayList<String>();
    private String writer = null;
    private final List<String> waiters = new ArrayList<String>();
    private final Object lock = new Monitor(LockableImpl.class.getSimpleName());
    private final List<ILockListener> listeners = new ArrayList<ILockListener>();

    public LockableImpl(ILockable target) {
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lockRead(String name, boolean wait, IProgressMonitor progress) throws OperationAbortedException {
        Debug.info((String)"lockRead {0}/{1}", (Object[])new Object[]{name, wait});
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                String waitingOn = this.waiters.isEmpty() ? this.writer : this.waiters.get(this.waiters.size() - 1);
                if (!wait) {
                    return waitingOn;
                }
                this.waiters.add(name);
                while (this.writer != null || this.waiters.get(0) != name) {
                    try {
                        if (progress != null) {
                            progress.setWaitingOn(waitingOn);
                        }
                    }
                    catch (OperationAbortedException ex) {
                        this.waiters.remove(name);
                        throw ex;
                    }
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException ex) {
                        this.waiters.remove(name);
                        return waitingOn;
                    }
                    int i = 0;
                    while (i < this.waiters.size()) {
                        if (this.waiters.get(i) == name) {
                            waitingOn = i == 0 ? this.writer : this.waiters.get(i - 1);
                        }
                        ++i;
                    }
                }
                this.waiters.remove(name);
                if (progress != null) {
                    progress.setWaitingOn(null);
                }
            }
            this.readers.add(name);
            this.dumpStack();
        }
        this.fireListeners(true, false);
        return null;
    }

    public void lockReadWait(String name) {
        try {
            while (this.lockRead(name, true, null) != null) {
            }
        }
        catch (OperationAbortedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lockReadWait(String name, long timeoutMs) throws InterruptedException {
        Debug.info((String)"lockReadWait {0}/{1}", (Object[])new Object[]{name, timeoutMs});
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.waiters.add(name);
                try {
                    this.lock.wait(timeoutMs);
                }
                catch (InterruptedException ex) {
                    this.waiters.remove(name);
                    throw ex;
                }
                boolean success = this.writer == null && this.waiters.get(0) == name;
                String waitingOn = null;
                int i = 0;
                while (i < this.waiters.size()) {
                    if (this.waiters.get(i) == name) {
                        waitingOn = i == 0 ? this.writer : this.waiters.get(i - 1);
                    }
                    ++i;
                }
                this.waiters.remove(name);
                if (!success) {
                    return waitingOn;
                }
            }
            this.readers.add(name);
            this.dumpStack();
        }
        this.fireListeners(true, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRead(String name) {
        Debug.info((String)"unlockRead {0}", (Object[])new Object[]{name});
        boolean unlocked = false;
        Object object = this.lock;
        synchronized (object) {
            assert (this.readers.contains(name));
            this.readers.remove(name);
            this.dumpStack();
            this.lock.notifyAll();
            if (this.readers.isEmpty() && this.waiters.isEmpty()) {
                unlocked = true;
            }
        }
        if (unlocked) {
            this.fireListeners(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lockWrite(String name, boolean wait, IProgressMonitor progress) throws OperationAbortedException {
        Debug.info((String)"lockWrite {0}/{1}", (Object[])new Object[]{name, wait});
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null || !this.readers.isEmpty()) {
                String waitingOn = !this.waiters.isEmpty() ? this.waiters.get(this.waiters.size() - 1) : (this.writer != null ? this.writer : this.readers.get(this.readers.size() - 1));
                if (!wait) {
                    return waitingOn;
                }
                this.waiters.add(name);
                while (this.writer != null || !this.readers.isEmpty() || this.waiters.get(0) != name) {
                    try {
                        if (progress != null) {
                            progress.setWaitingOn(waitingOn);
                        }
                    }
                    catch (OperationAbortedException ex) {
                        this.waiters.remove(name);
                        throw ex;
                    }
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException ex) {
                        this.waiters.remove(name);
                        return waitingOn;
                    }
                    int i = 0;
                    while (i < this.waiters.size()) {
                        if (this.waiters.get(i) == name) {
                            if (i == 0) {
                                if (this.writer != null) {
                                    waitingOn = this.writer;
                                } else if (!this.readers.isEmpty()) {
                                    waitingOn = this.readers.get(this.readers.size() - 1);
                                }
                            } else {
                                waitingOn = this.waiters.get(i - 1);
                            }
                        }
                        ++i;
                    }
                }
                this.waiters.remove(name);
                if (progress != null) {
                    progress.setWaitingOn(null);
                }
            }
            assert (this.writer == null && this.readers.isEmpty());
            this.writer = name;
            this.dumpStack();
        }
        this.fireListeners(true, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockWrite(String name) {
        Debug.info((String)"unlockWrite {0}", (Object[])new Object[]{name});
        boolean unlocked = false;
        Object object = this.lock;
        synchronized (object) {
            assert (this.writer.equals(name));
            this.writer = null;
            this.dumpStack();
            this.lock.notifyAll();
            if (this.waiters.isEmpty()) {
                unlocked = true;
            }
        }
        if (unlocked) {
            this.fireListeners(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockedRead() {
        Object object = this.lock;
        synchronized (object) {
            return this.writer != null || !this.readers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockedWrite() {
        Object object = this.lock;
        synchronized (object) {
            return this.writer != null;
        }
    }

    private void dumpStack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(boolean lockedRead, boolean lockedWrite) {
        ArrayList<ILockListener> toFire;
        List<ILockListener> list = this.listeners;
        synchronized (list) {
            toFire = new ArrayList<ILockListener>(this.listeners);
        }
        for (ILockListener listener : toFire) {
            listener.lockStatusChanged(this.target, lockedRead, lockedWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLockListener(ILockListener listener) {
        List<ILockListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockListener(ILockListener listener) {
        List<ILockListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

