/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data;

import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.SessionListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements IDisposable {
    private final List<AudioFile> files = new ArrayList<AudioFile>();
    private final List<SessionListener> listeners = new ArrayList<SessionListener>();
    private final AudioClipboard clipboard = AudioClipboard.getInstance();
    private AudioFile currentFile = null;
    private AudioFile focusedFile = null;

    public synchronized List<AudioFile> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public synchronized boolean isOpened(AudioFile file) {
        return this.files.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(AudioFile file) {
        Session session = this;
        synchronized (session) {
            this.files.add(file);
        }
        this.fireFileAdded(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFile(AudioFile file) {
        Session session = this;
        synchronized (session) {
            this.files.remove(file);
        }
        this.fireFileRemoved(file);
        if (file == this.currentFile) {
            this.setCurrentFile(null);
            this.fireCurrentFileChanged(null);
        }
        if (file == this.focusedFile) {
            this.setFocusedFile(null);
            this.fireFocusedFileChanged(null);
        }
    }

    public synchronized AudioFile getCurrentFile() {
        return this.currentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentFile(AudioFile currentFile) {
        Session session = this;
        synchronized (session) {
            if (currentFile == this.currentFile) {
                return;
            }
            this.currentFile = currentFile;
        }
        this.fireCurrentFileChanged(currentFile);
    }

    public synchronized AudioFile getFocusedFile() {
        return this.focusedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusedFile(AudioFile focusedFile) {
        Session session = this;
        synchronized (session) {
            if (focusedFile == this.focusedFile) {
                return;
            }
            this.focusedFile = focusedFile;
        }
        this.fireFocusedFileChanged(focusedFile);
    }

    public AudioClipboard getClipboard() {
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener listener) {
        List<SessionListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener listener) {
        List<SessionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SessionListener> listeners() {
        List<SessionListener> list = this.listeners;
        synchronized (list) {
            return new ArrayList<SessionListener>(this.listeners);
        }
    }

    private void fireFileAdded(AudioFile audioFile) {
        for (SessionListener listener : this.listeners()) {
            listener.fileAdded(this, audioFile);
        }
    }

    private void fireFileRemoved(AudioFile audioFile) {
        for (SessionListener listener : this.listeners()) {
            listener.fileRemoved(this, audioFile);
        }
    }

    private void fireCurrentFileChanged(AudioFile audioFile) {
        for (SessionListener listener : this.listeners()) {
            listener.currentFileChanged(this, audioFile);
        }
    }

    private void fireFocusedFileChanged(AudioFile audioFile) {
        for (SessionListener listener : this.listeners()) {
            listener.focusedFileChanged(this, audioFile);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public synchronized void dispose() {
        for (AudioFile file : this.files) {
            file.dispose();
        }
        this.files.clear();
        this.listeners.clear();
        this.clipboard.dispose();
    }
}

