/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.memory.undoredo.IUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.sonics.data.stats.IExtremum;
import ch.tachyon.sonics.data.view.AudioChannelDataView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioChannel
implements IUndoRedoFloatFile {
    private final AudioFile file;
    private final IUndoRedoFloatFile target;
    private List<AudioChannelListener> listeners = new ArrayList<AudioChannelListener>();
    private long modStartPos = Long.MAX_VALUE;
    private long modStopPos = 0L;
    private long oldSize;
    private boolean modifiedSinceLastCommit = false;

    public AudioChannel(AudioFile file, IUndoRedoFloatFile target) {
        this.file = file;
        this.target = target;
        this.oldSize = file.getLength();
    }

    public AudioFile getFile() {
        return this.file;
    }

    public int getChannelIndex() {
        AudioChannels chans = this.file.getData();
        return chans.indexOf(this);
    }

    public AudioChannelDataView getView() {
        return this.file.getView(this);
    }

    @Override
    public int read(long pos, float[] data, int offset, int length) throws IOException {
        if (pos + (long)length > this.getLength()) {
            length = (int)(this.getLength() - pos);
        }
        if (length <= 0) {
            return 0;
        }
        return this.target.read(pos, data, offset, length);
    }

    @Override
    public void write(long pos, float[] data, int offset, int length) throws IOException {
        this.transactionState(true);
        this.target.write(pos, data, offset, length);
        this.modStartPos = Math.min(this.modStartPos, pos);
        this.modStopPos = Math.max(this.modStopPos, pos + (long)length);
    }

    @Override
    public long getLength() {
        return this.target.getLength();
    }

    public long getFileLength() {
        return this.getFile().getLength();
    }

    @Override
    public void flush() throws IOException {
        this.target.flush();
    }

    @Override
    public void dispose() {
        this.target.dispose();
    }

    @Override
    public void insert(long pos, float[] data, int offset, int length) throws IOException {
        this.transactionState(true);
        this.target.insert(pos, data, offset, length);
        this.modStartPos = Math.min(this.modStartPos, pos);
        this.modStopPos = Math.max(this.modStopPos, this.target.getLength());
    }

    @Override
    public int delete(long pos, int length) throws IOException {
        this.transactionState(true);
        this.modStartPos = Math.min(this.modStartPos, pos);
        this.modStopPos = Math.max(this.modStopPos, this.target.getLength());
        int result = this.target.delete(pos, length);
        return result;
    }

    @Override
    public void commit() throws IOException {
        this.target.commit();
        this.flush();
        this.transactionState(false);
    }

    @Override
    public void rollback(IProgressMonitor progress, @Out LongRange range) throws IOException {
        this.target.rollback(progress, range);
        this.markDirty(range);
        this.flush();
        this.transactionState(false);
    }

    @Override
    public boolean canUndo() throws IOException {
        if (this.modifiedSinceLastCommit) {
            return false;
        }
        return this.target.canUndo();
    }

    @Override
    public boolean canRedo() throws IOException {
        if (this.modifiedSinceLastCommit) {
            return false;
        }
        return this.target.canRedo();
    }

    @Override
    public void undo(IProgressMonitor progress, @Out LongRange range) throws IOException {
        this.target.undo(progress, range);
        this.markDirty(range);
        this.flush();
    }

    @Override
    public void redo(IProgressMonitor progress, @Out LongRange range) throws IOException {
        this.target.redo(progress, range);
        this.markDirty(range);
        this.flush();
    }

    private void markDirty(LongRange range) {
        this.modStartPos = Math.min(this.modStartPos, range.getStart());
        this.modStopPos = Math.max(this.modStopPos, range.getStop());
    }

    @Override
    public boolean isModified() throws IOException {
        return this.target.isModified();
    }

    @Override
    public void savePoint() throws IOException {
        this.target.savePoint();
    }

    @Override
    public void baseUndoRedoPoint() throws IOException {
        this.target.baseUndoRedoPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioChannelListener(AudioChannelListener listener) {
        List<AudioChannelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAudioChannelListener(AudioChannelListener listener) {
        List<AudioChannelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioChannelListener> listeners() {
        List<AudioChannelListener> list = this.listeners;
        synchronized (list) {
            ArrayList<AudioChannelListener> result = new ArrayList<AudioChannelListener>(this.listeners);
            result.addAll(this.getFile().channelListeners());
            return result;
        }
    }

    protected void notifyDataModified() throws IOException {
        long newSize = this.file.getLength();
        if (this.oldSize != newSize) {
            this.file.getView().fireChannelSizeChanged(this, this.oldSize, newSize);
        }
        if (this.modStartPos < this.modStopPos || this.modStartPos == 0L && this.modStopPos == this.target.getLength()) {
            for (AudioChannelListener listener : this.listeners()) {
                if (this.oldSize != newSize) {
                    listener.channelSizeChanged(this, this.oldSize, newSize);
                }
                listener.dataModified(this, this.modStartPos, this.modStopPos);
            }
            this.modStartPos = Long.MAX_VALUE;
            this.modStopPos = 0L;
            this.oldSize = newSize;
        }
    }

    private void transactionState(boolean running) {
        if (running != this.modifiedSinceLastCommit) {
            this.modifiedSinceLastCommit = running;
            this.notifyTransactionStateChanged(running);
        }
    }

    private void notifyTransactionStateChanged(boolean running) {
        for (AudioChannelListener listener : this.listeners()) {
            listener.transactionStateChanged(this, running);
        }
    }

    @Override
    public AudioStatistics getStatistics(IUndoRedoFloatFile urFile, long pos, long length) throws IOException {
        return this.target.getStatistics(urFile, pos, length);
    }

    @Override
    public long getExtremumSample(long startPos, long stopPos, IUndoRedoFloatFile urFile, IExtremum extremum) throws IOException {
        return this.target.getExtremumSample(startPos, stopPos, urFile, extremum);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("AudioChannel{");
        result.append("file=");
        result.append(this.file.getFile().getPath());
        result.append(",channel=");
        result.append(this.file.getData().getChannels().indexOf(this));
        result.append("}");
        return result.toString();
    }
}

