/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.memory.audio.CompositeFloatFile;
import ch.tachyon.sonics.data.memory.audio.SimpleFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.BlockBufferedUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.IUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.sonics.data.memory.undoredo.UndoRedoFloatFile;
import ch.tachyon.sonics.gui.progress.MultiStepProgressMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioChannels {
    private final AudioFile audioFile;
    private final List<AudioChannel> channels = new ArrayList<AudioChannel>();
    private final BitSet allChannels = new BitSet();
    private final BitSet trxChannels = new BitSet();
    private BitSet prevChans = null;

    public AudioChannels(AudioFile audioFile) {
        this.audioFile = audioFile;
    }

    public synchronized void addChannel(int index) throws IOException {
        if (index < 0 || index > this.channels.size()) {
            throw new IndexOutOfBoundsException();
        }
        CompositeFloatFile backingFile = new CompositeFloatFile(SimpleFloatFile.class);
        UndoRedoFloatFile urFile = new UndoRedoFloatFile(backingFile);
        BlockBufferedUndoRedoFloatFile data = new BlockBufferedUndoRedoFloatFile(urFile);
        AudioChannel channel = new AudioChannel(this.audioFile, data);
        this.allChannels.set(index);
        this.channels.add(index, channel);
        this.audioFile.fireChannelAdded(channel);
    }

    public synchronized void removeChannel(int index) throws IOException {
        if (index < 0 || index >= this.channels.size()) {
            throw new IndexOutOfBoundsException();
        }
        AudioChannel victim = this.channels.remove(index);
        victim.dispose();
        this.allChannels.clear(index);
        this.audioFile.fireChannelRemoved(victim);
    }

    public synchronized int getNbChannels() {
        return this.channels.size();
    }

    public synchronized AudioChannel getChannel(int channel, boolean readOnly) {
        if (!readOnly) {
            this.modified(channel);
        }
        return this.channels.get(channel);
    }

    public synchronized List<AudioChannel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    int indexOf(AudioChannel chan) {
        return this.channels.indexOf(chan);
    }

    private void checkChannels(BitSet chanSet) {
        if (chanSet.length() > this.channels.size()) {
            throw new IllegalArgumentException("Channel set out of range: " + chanSet + ", number of channels: " + this.channels.size());
        }
    }

    private void checkChannelsAndData(BitSet chanSet, float[][] data) {
        if (chanSet != this.prevChans) {
            this.checkChannels(chanSet);
            if (chanSet.cardinality() != data.length) {
                throw new IllegalArgumentException("Channel selection does not match data array length");
            }
            this.prevChans = chanSet;
        }
        float[][] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float[] arr = fArray[n2];
            if (arr == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
    }

    private void modified(int chan) {
        this.trxChannels.set(chan);
    }

    public int read(BitSet chanSet, long pos, float[][] target, int length) throws IOException {
        int[] results = this.read0(chanSet, pos, target, length);
        int result = results[0];
        int c = 1;
        while (c < results.length) {
            result = Math.max(result, results[c]);
            ++c;
        }
        int i = 0;
        while (i < results.length) {
            if (results[i] < result) {
                Arrays.fill(target[i], results[i], result, 0.0f);
            }
            ++i;
        }
        return result;
    }

    private synchronized int[] read0(BitSet chanSet, long pos, float[][] target, int length) throws IOException {
        if (chanSet == null) {
            chanSet = this.allChannels;
        }
        this.checkChannelsAndData(chanSet, target);
        int[] result = new int[chanSet.cardinality()];
        int chan = chanSet.nextSetBit(0);
        int i = 0;
        while (chan >= 0) {
            result[i] = this.channels.get(chan).read(pos, target[i], 0, length);
            chan = chanSet.nextSetBit(chan + 1);
            ++i;
        }
        return result;
    }

    public synchronized void write(BitSet chanSet, long pos, float[][] data, int length) throws IOException {
        if (chanSet == null) {
            chanSet = this.allChannels;
        }
        this.checkChannelsAndData(chanSet, data);
        int chan = chanSet.nextSetBit(0);
        int i = 0;
        while (chan >= 0) {
            this.channels.get(chan).write(pos, data[i], 0, length);
            this.modified(chan);
            chan = chanSet.nextSetBit(chan + 1);
            ++i;
        }
    }

    public long[] getSize(BitSet chanSet) {
        if (chanSet == null) {
            chanSet = this.allChannels;
        }
        this.checkChannels(chanSet);
        long[] result = new long[chanSet.cardinality()];
        int chan = chanSet.nextSetBit(0);
        int i = 0;
        while (chan >= 0) {
            result[i] = this.channels.get(chan).getLength();
            chan = chanSet.nextSetBit(chan + 1);
            ++i;
        }
        return result;
    }

    public synchronized void insert(BitSet chanSet, long pos, float[][] data, int length) throws IOException {
        if (chanSet == null) {
            chanSet = this.allChannels;
        }
        this.checkChannelsAndData(chanSet, data);
        int chan = chanSet.nextSetBit(0);
        int i = 0;
        while (chan >= 0) {
            this.channels.get(chan).insert(pos, data[i], 0, length);
            this.modified(chan);
            chan = chanSet.nextSetBit(chan + 1);
            ++i;
        }
    }

    public synchronized int[] delete(BitSet chanSet, long pos, int count) throws IOException {
        if (chanSet == null) {
            chanSet = this.allChannels;
        }
        this.checkChannels(chanSet);
        int[] result = new int[chanSet.cardinality()];
        int chan = chanSet.nextSetBit(0);
        int i = 0;
        while (chan >= 0) {
            result[i] = this.channels.get(chan).delete(pos, count);
            this.modified(chan);
            chan = chanSet.nextSetBit(chan + 1);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        BitSet chans;
        AudioChannels audioChannels = this;
        synchronized (audioChannels) {
            chans = (BitSet)this.trxChannels.clone();
            int chan = this.trxChannels.nextSetBit(0);
            while (chan >= 0) {
                this.channels.get(chan).commit();
                chan = this.trxChannels.nextSetBit(chan + 1);
            }
            this.trxChannels.clear();
        }
        int chan = chans.nextSetBit(0);
        while (chan >= 0) {
            this.channels.get(chan).notifyDataModified();
            chan = chans.nextSetBit(chan + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        AudioChannels audioChannels = this;
        synchronized (audioChannels) {
            int chan = this.trxChannels.nextSetBit(0);
            while (chan >= 0) {
                this.channels.get(chan).flush();
                chan = this.trxChannels.nextSetBit(chan + 1);
            }
            this.trxChannels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(IProgressMonitor progress) throws IOException {
        BitSet chans;
        AudioChannels audioChannels = this;
        synchronized (audioChannels) {
            chans = (BitSet)this.trxChannels.clone();
            int current = 0;
            int chan = this.trxChannels.nextSetBit(0);
            while (chan >= 0) {
                progress.setStep(++current, this.trxChannels.cardinality());
                this.channels.get(chan).rollback(progress, new LongRange());
                chan = this.trxChannels.nextSetBit(chan + 1);
            }
            this.trxChannels.clear();
        }
        int chan = chans.nextSetBit(0);
        while (chan >= 0) {
            this.channels.get(chan).notifyDataModified();
            chan = chans.nextSetBit(chan + 1);
        }
    }

    public synchronized boolean canUndo() throws IOException {
        for (AudioChannel channel : this.channels) {
            if (channel.canUndo()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean canRedo() throws IOException {
        for (AudioChannel channel : this.channels) {
            if (channel.canRedo()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(IProgressMonitor progress, @Out LongRange range, @Out BitSet chanMask) throws IOException {
        AudioChannels audioChannels = this;
        synchronized (audioChannels) {
            MultiStepProgressMonitor mspm = new MultiStepProgressMonitor(progress, this.channels.size());
            int i = 0;
            while (i < this.channels.size()) {
                AudioChannel channel = this.channels.get(i);
                if (channel.canUndo()) {
                    LongRange chanRange = new LongRange();
                    mspm.setCurrentStep(i);
                    channel.undo(mspm, chanRange);
                    if (!chanRange.isEmpty()) {
                        range.merge(chanRange);
                        chanMask.set(i);
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.channels.size()) {
            if (chanMask.get(i)) {
                this.channels.get(i).notifyDataModified();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo(IProgressMonitor progress, @Out LongRange range, @Out BitSet chanMask) throws IOException {
        AudioChannels audioChannels = this;
        synchronized (audioChannels) {
            MultiStepProgressMonitor mspm = new MultiStepProgressMonitor(progress, this.channels.size());
            int i = 0;
            while (i < this.channels.size()) {
                AudioChannel channel = this.channels.get(i);
                if (channel.canRedo()) {
                    LongRange chanRange = new LongRange();
                    mspm.setCurrentStep(i);
                    channel.redo(mspm, chanRange);
                    if (!chanRange.isEmpty()) {
                        range.merge(chanRange);
                        chanMask.set(i);
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.channels.size()) {
            if (chanMask.get(i)) {
                this.channels.get(i).notifyDataModified();
            }
            ++i;
        }
    }

    public synchronized void dispose() {
        for (IUndoRedoFloatFile iUndoRedoFloatFile : this.channels) {
            iUndoRedoFloatFile.dispose();
        }
        this.channels.clear();
    }

    public synchronized void savePoint() throws IOException {
        for (IUndoRedoFloatFile iUndoRedoFloatFile : this.channels) {
            iUndoRedoFloatFile.savePoint();
        }
    }

    public synchronized void baseUndoRedoPoint() throws IOException {
        for (IUndoRedoFloatFile iUndoRedoFloatFile : this.channels) {
            iUndoRedoFloatFile.baseUndoRedoPoint();
        }
    }

    public synchronized boolean isModified() throws IOException {
        boolean result = false;
        for (IUndoRedoFloatFile iUndoRedoFloatFile : this.channels) {
            result |= iUndoRedoFloatFile.isModified();
        }
        return result;
    }
}

