/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.ILockListener;
import ch.tachyon.sonics.data.ILockable;
import ch.tachyon.sonics.data.LockableImpl;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFileListener;
import ch.tachyon.sonics.data.audio.AudioFileSource;
import ch.tachyon.sonics.data.audio.DelayedWriter;
import ch.tachyon.sonics.data.audio.UnknownProgressInputStream;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioChannelDataView;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import ch.tachyon.sonics.data.view.MergedAudioChannelPanel;
import ch.tachyon.tunnel.utils.Debug;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.corebounce.common.audio.file.AudioFiles;
import org.corebounce.common.audio.file.AudioInputStreamSource;
import org.corebounce.common.audio.file.AudioSourceInputStream;
import org.corebounce.common.io.CountedInputStream;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.io.RandomFileInputStream;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFile
implements ILockable {
    private static final int SELECTION_HISTORY_SIZE = 10;
    private File file;
    private final AudioChannels data;
    private final Map<String, Object> metaData;
    private final ILockable locker = new LockableImpl(this);
    private float sampleRate;
    private int sampleSize;
    private boolean bigEndian;
    private AudioFormat.Encoding encoding;
    private final SelectionInfo selection = new SelectionInfo(this);
    private final List<List<ISelection>> selectionHistory = new ArrayList<List<ISelection>>();
    private int selectionHistoryIndex;
    private final List<AudioFileListener> listeners = new ArrayList<AudioFileListener>();
    private final List<AudioChannelDataView> views = new ArrayList<AudioChannelDataView>();
    private List<AudioChannelListener> channelListeners = new ArrayList<AudioChannelListener>();
    private final AudioDataView mergedView = new AudioDataView(this, this.views);
    private String readFormat;
    private AudioFileFormat.Type writeType;

    public AudioFile() {
        this(null);
    }

    public AudioFile(File file) {
        this.file = file;
        this.data = new AudioChannels(this);
        this.metaData = new LinkedHashMap<String, Object>();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public AudioChannels getData() {
        return this.data;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public AudioFormat.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(AudioFormat.Encoding encoding) {
        this.encoding = encoding;
    }

    public void copyAttributesFrom(AudioFile other) {
        this.setSampleRate(other.getSampleRate());
        this.setSampleSize(other.getSampleSize());
        this.setBigEndian(other.isBigEndian());
        this.setEncoding(other.getEncoding());
    }

    public int getNbChannels() {
        return this.data.getNbChannels();
    }

    public BitSet getAllChannelsMask() {
        BitSet result = new BitSet(this.data.getNbChannels());
        result.set(0, this.data.getNbChannels());
        return result;
    }

    public long getLength() {
        long[] chanLengths;
        long result = 0L;
        long[] lArray = chanLengths = this.getData().getSize(null);
        int n = chanLengths.length;
        int n2 = 0;
        while (n2 < n) {
            long chanLength = lArray[n2];
            if (chanLength > result) {
                result = chanLength;
            }
            ++n2;
        }
        return result;
    }

    public void savePoint() throws IOException {
        this.data.savePoint();
        this.fireFileSaved();
    }

    public boolean isModified() {
        if (this.getFile() == null) {
            return true;
        }
        try {
            return this.data.isModified();
        }
        catch (IOException ex) {
            return true;
        }
    }

    public SelectionInfo getSelection() {
        return this.selection;
    }

    public void addCurrentSelectionToHistory() {
        if (this.selectionHistoryIndex < 0) {
            this.selectionHistoryIndex = 0;
        }
        ArrayList<ISelection> selections = new ArrayList<ISelection>();
        for (ISelection selection : this.selection.getSelections()) {
            selections.add(selection.clone());
        }
        while (this.selectionHistory.size() > this.selectionHistoryIndex) {
            this.selectionHistory.remove(this.selectionHistory.size() - 1);
        }
        this.selectionHistory.add(selections);
        ++this.selectionHistoryIndex;
        while (this.selectionHistory.size() > 10) {
            this.selectionHistory.remove(this.selectionHistory.size() - 1);
            --this.selectionHistoryIndex;
        }
        assert (this.selectionHistoryIndex >= 0 && this.selectionHistoryIndex <= this.selectionHistory.size());
    }

    public void restoreSelectionFromHistory(int delta) {
        this.selectionHistoryIndex += delta;
        if (this.selectionHistoryIndex < 0 || this.selectionHistoryIndex >= this.selectionHistory.size()) {
            return;
        }
        this.selection.clear();
        this.selection.addSelections((Collection<ISelection>)this.selectionHistory.get(this.selectionHistoryIndex));
    }

    public void loadContent(IProgressMonitor progress, long offset, long total) throws IOException, UnsupportedAudioFileException, OperationAbortedException {
        String fileType = AudioFiles.instance().getAudioFileType(this.file.getName());
        if (fileType != null) {
            progress.setText("Scanning {0} file \"{1}\"...", fileType, this.file.getName());
        } else {
            progress.setText("Scanning file \"{0}\"...", this.file.getName());
        }
        RandomFileInputStream fStream = new RandomFileInputStream(this.file);
        UnknownProgressInputStream uStream = null;
        try {
            block14: {
                try {
                    try {
                        uStream = new UnknownProgressInputStream(fStream, progress);
                        AudioFileFormat format = AudioFiles.instance().getAudioFileFormat(this.file.getName(), uStream);
                        if (format.properties() != null) {
                            this.metaData.putAll(format.properties());
                        }
                        if (format.getFormat() != null && format.getFormat().properties() != null) {
                            this.metaData.putAll(format.getFormat().properties());
                        }
                        AudioFileFormat.Type type = format.getType();
                        this.metaData.put("file.type", type);
                        if (fileType == null) {
                            fileType = type.toString();
                        }
                    }
                    catch (Exception ex) {
                        Debug.warn((String)"Could not get meta-data from file {0}", (Object[])new Object[]{this.file.getName()});
                        IOUtils.close(uStream);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(uStream);
                    throw throwable;
                }
                IOUtils.close(uStream);
            }
            if (fileType == null) {
                fileType = "Unknown";
            }
            this.readFormat = fileType;
            progress.setText("Loading {0} file \"{1}\"...", fileType, this.file.getName());
            fStream = new RandomFileInputStream(this.file);
            this.loadContentFromStream(progress, offset, total, fStream, this.file.getName());
            this.writeType = AudioFiles.instance().getWritableType4ext(this.file.getName());
            if (this.writeType == null) {
                this.writeType = AudioFiles.instance().getWritableType(fileType);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(uStream);
            throw throwable;
        }
        IOUtils.close(uStream);
    }

    private void loadContentFromStream(IProgressMonitor progress, long offset, long total, InputStream fStream, String fileName) throws IOException, UnsupportedAudioFileException, OperationAbortedException {
        int blockSize = CacheSizes.getSampleCacheSize();
        CountedInputStream cStream = null;
        try {
            cStream = new CountedInputStream(fStream);
            AudioInputStream stream = AudioFiles.instance().getAudioInputStream(fileName, cStream);
            AudioFormat format = stream.getFormat();
            float sampleRate = format.getSampleRate();
            this.setSampleRate(sampleRate);
            int sampleSize = format.getSampleSizeInBits();
            if (sampleSize == -1) {
                sampleSize = 16;
            }
            this.setSampleSize(sampleSize);
            this.setBigEndian(format.isBigEndian());
            this.setEncoding(format.getEncoding());
            int nbChannels = format.getChannels();
            if (nbChannels == -1) {
                Debug.warn((String)"Could not get number of channels. Assuming stereo.", (Object[])new Object[0]);
                nbChannels = 2;
            }
            int i = 0;
            while (i < nbChannels) {
                this.data.addChannel(i);
                ++i;
            }
            DelayedWriter writer = null;
            try {
                AudioInputStreamSource source = new AudioInputStreamSource(stream);
                float[][] buffer = new float[source.getNbChannels()][blockSize];
                int amount = source.getSamples(buffer);
                writer = new DelayedWriter(this.data, this.getAllChannelsMask(), blockSize, 0L);
                while (amount > 0) {
                    if (progress != null) {
                        progress.setProgress(offset + cStream.getPosition(), total);
                    }
                    writer.writeNext(buffer, amount);
                    amount = source.getSamples(buffer);
                }
                writer.dispose();
                this.data.commit();
                this.data.savePoint();
                this.data.baseUndoRedoPoint();
            }
            catch (OperationAbortedException ex) {
                if (writer != null) {
                    writer.dispose();
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(cStream);
            throw throwable;
        }
        IOUtils.close(cStream);
    }

    public void loadContentFromStream(InputStream fStream, String fileName) throws IOException, UnsupportedAudioFileException {
        try {
            this.loadContentFromStream(null, 0L, 0L, fStream, fileName);
        }
        catch (OperationAbortedException ex) {
            Debug.error((Throwable)ex);
        }
    }

    public void loadContentFromStream(InputStream fStream, String fileName, IProgressMonitor progress, long total) throws IOException, UnsupportedAudioFileException, OperationAbortedException {
        this.loadContentFromStream(progress, 0L, total, fStream, fileName);
    }

    public boolean isWritableFormat() {
        return this.writeType != null;
    }

    public void ensureEncodingSupported() {
        this.encoding = AudioFiles.instance().getEncodingFor(this.encoding, this.sampleSize);
        if (this.encoding == null) {
            this.encoding = AudioFormat.Encoding.PCM_SIGNED;
            this.sampleSize = 16;
        }
    }

    public void setWriteFormat(AudioFileFormat.Type writeType) {
        this.writeType = writeType;
        this.ensureEncodingSupported();
    }

    public String getReadFormat() {
        return this.readFormat;
    }

    private void checkSaveParameters() throws IllegalStateException {
        if (this.writeType == null) {
            throw new IllegalStateException("writeType not specified");
        }
        if (this.sampleRate <= 0.0f) {
            throw new IllegalStateException("sampleRate not specified");
        }
        if (this.sampleSize <= 0) {
            throw new IllegalStateException("sampleSize not specified");
        }
    }

    public void saveContent(IProgressMonitor progress) throws IOException, IllegalArgumentException, IllegalStateException, InterruptedException {
        boolean success;
        boolean success2;
        this.checkSaveParameters();
        if (this.file == null) {
            throw new IllegalStateException("No file specified");
        }
        progress.setText("Saving {0} file \"{1}\"...", this.writeType, this.file.getName());
        File backup = null;
        if (this.file.exists() && !(success2 = this.file.renameTo(backup = new File(String.valueOf(this.file.getAbsolutePath()) + ".back")))) {
            Debug.warn((String)"Could not backup old file \"{0}\" to \"{1}\"", (Object[])new Object[]{this.file, backup});
        }
        FileOutputStream fOutput = new FileOutputStream(this.file);
        BufferedOutputStream output = new BufferedOutputStream(fOutput);
        try {
            try {
                this.saveContentToStream(progress, output);
            }
            catch (IOException ex) {
                if (ex.getMessage() != null && ex.getMessage().toLowerCase().contains("interrupted")) {
                    IOUtils.close(output);
                    this.file.delete();
                    if (backup != null) {
                        backup.renameTo(this.file);
                    }
                    throw new InterruptedException();
                }
                throw ex;
            }
        }
        finally {
            IOUtils.close(output);
        }
        if (backup != null && !(success = backup.delete())) {
            Debug.warn((String)"Could not delete old backup file \"{0}\"", (Object[])new Object[]{backup});
        }
    }

    public void saveContentToStream(IProgressMonitor progress, OutputStream output) throws IOException, IllegalArgumentException {
        this.checkSaveParameters();
        int frameSize = this.getNbChannels() * this.sampleSize / 8;
        float frameRate = this.sampleRate;
        if (this.encoding == null) {
            this.encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        AudioFormat format = new AudioFormat(this.encoding, this.sampleRate, this.sampleSize, this.getNbChannels(), frameSize, frameRate, this.bigEndian, this.metaData);
        AudioFileSource source = new AudioFileSource(this);
        int length = this.getLength() <= Integer.MAX_VALUE ? (int)this.getLength() : -1;
        AudioInputStream input = AudioSourceInputStream.createAudioInputStream(source, format, progress, length);
        try {
            AudioFiles.write(input, this.writeType, output);
        }
        finally {
            input.close();
        }
    }

    public void dispose() {
        this.data.dispose();
        this.metaData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addView(AudioChannelDataView view) {
        List<AudioChannelDataView> list = this.views;
        synchronized (list) {
            this.views.add(view);
        }
        this.mergedView.fireViewChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(AudioChannelDataView view) {
        List<AudioChannelDataView> list = this.views;
        synchronized (list) {
            this.views.remove(view);
        }
        this.mergedView.fireViewChanged();
    }

    public AudioDataView getView() {
        return this.mergedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioChannelDataView getView(AudioChannel channel) {
        List<AudioChannelDataView> list = this.views;
        synchronized (list) {
            for (AudioChannelDataView view : this.views) {
                if (view.getAudioChannel() != channel) continue;
                return view;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAudioChannelPanel getMergedPanel() {
        ArrayList<IAudioChannelPanel> panels = new ArrayList<IAudioChannelPanel>();
        List<AudioChannelDataView> list = this.views;
        synchronized (list) {
            for (AudioChannelDataView view : this.views) {
                panels.add(view.getPanel());
            }
        }
        return new MergedAudioChannelPanel(panels);
    }

    public void addAudioFileListener(AudioFileListener listener) {
        this.listeners.add(listener);
    }

    public void removeAudioFileListener(AudioFileListener listener) {
        this.listeners.remove(listener);
    }

    void fireChannelAdded(AudioChannel channel) {
        for (AudioFileListener listener : this.listeners) {
            listener.channelAdded(this, channel);
        }
    }

    void fireChannelRemoved(AudioChannel channel) {
        for (AudioFileListener listener : this.listeners) {
            listener.channelRemoved(this, channel);
        }
    }

    void fireFileSaved() {
        for (AudioFileListener listener : this.listeners) {
            listener.fileSaved(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioChannelListener(AudioChannelListener listener) {
        List<AudioChannelListener> list = this.channelListeners;
        synchronized (list) {
            this.channelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAudioChannelListener(AudioChannelListener listener) {
        List<AudioChannelListener> list = this.channelListeners;
        synchronized (list) {
            this.channelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioChannelListener> channelListeners() {
        List<AudioChannelListener> list = this.channelListeners;
        synchronized (list) {
            return new ArrayList<AudioChannelListener>(this.channelListeners);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
        this.channelListeners.clear();
        this.mergedView.clearListeners();
        this.selection.clearListeners();
        for (AudioChannel channel : this.data.getChannels()) {
            channel.clearListeners();
        }
    }

    public void clearViews() {
        this.views.clear();
    }

    @Override
    public String lockRead(String name, boolean wait, IProgressMonitor progress) throws OperationAbortedException {
        return this.locker.lockRead(name, wait, progress);
    }

    @Override
    public void lockReadWait(String name) {
        this.locker.lockReadWait(name);
    }

    @Override
    public String lockReadWait(String name, long timeoutMs) throws InterruptedException {
        return this.locker.lockReadWait(name, timeoutMs);
    }

    @Override
    public void unlockRead(String name) {
        this.locker.unlockRead(name);
    }

    @Override
    public String lockWrite(String name, boolean wait, IProgressMonitor progress) throws OperationAbortedException {
        return this.locker.lockWrite(name, wait, progress);
    }

    @Override
    public void unlockWrite(String name) {
        this.locker.unlockWrite(name);
    }

    @Override
    public boolean isLockedRead() {
        return this.locker.isLockedRead();
    }

    @Override
    public boolean isLockedWrite() {
        return this.locker.isLockedWrite();
    }

    @Override
    public void addLockListener(ILockListener listener) {
        this.locker.addLockListener(listener);
    }

    @Override
    public void removeLockListener(ILockListener listener) {
        this.locker.removeLockListener(listener);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("AudioFile{");
        if (this.file != null) {
            result.append(this.file.getName());
        } else {
            result.append("<new file>");
        }
        result.append(",length=");
        result.append(this.getLength());
        result.append(",channels=");
        result.append(this.data.getNbChannels());
        result.append(",samplerate=");
        result.append(this.getSampleRate());
        result.append("}");
        return result.toString();
    }
}

