/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.corebounce.common.utils.IDisposable;

public class DelayedWriter
implements Runnable,
IDisposable {
    private static final boolean DISABLE_CACHE = "true".equalsIgnoreCase(System.getProperty("NoHardCache"));
    private static final int QUEUE_SIZE = CacheSizes.getProcessBlocksPerSampleCaches() * 8;
    private static final Block EOF_MARK = new Block();
    private final AudioChannels data;
    private final BitSet chanSet;
    private final int blockSize;
    private final BlockingQueue<Block> queue;
    private final float[][][] buffers;
    private int bufferIndex;
    private Thread writer;
    private long pos;
    private volatile boolean alive;
    private volatile IOException ioException;

    public DelayedWriter(AudioChannels data, BitSet chanSet, int blockSize, long startPos) {
        this.data = data;
        this.chanSet = chanSet;
        this.blockSize = blockSize;
        this.pos = startPos;
        if (DISABLE_CACHE) {
            this.queue = null;
            this.buffers = null;
        } else {
            this.queue = new ArrayBlockingQueue<Block>(QUEUE_SIZE);
            this.buffers = new float[QUEUE_SIZE + 2][chanSet.cardinality()][blockSize];
            this.writer = new Thread((Runnable)this, "Delayed Audio Writer");
            this.writer.setDaemon(true);
            this.alive = true;
            this.writer.start();
        }
    }

    public void writeNext(float[][] data, int amount) throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (DISABLE_CACHE) {
            this.data.write(this.chanSet, this.pos, data, amount);
            this.pos += (long)amount;
        } else {
            float[][] buffer = this.buffers[this.bufferIndex];
            this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
            int i = 0;
            while (i < data.length) {
                System.arraycopy(data[i], 0, buffer[i], 0, this.blockSize);
                ++i;
            }
            Block block = new Block();
            block.data = buffer;
            block.amount = amount;
            try {
                this.queue.put(block);
            }
            catch (InterruptedException ex) {
                Debug.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BlockingQueue<Block> blockingQueue;
        Block block = null;
        while (this.alive) {
            try {
                block13: {
                    if (this.queue.isEmpty()) {
                        blockingQueue = this.queue;
                        synchronized (blockingQueue) {
                            this.queue.notify();
                        }
                    }
                    try {
                        block = this.queue.take();
                        if (block == EOF_MARK) {
                        }
                        break block13;
                    }
                    catch (InterruptedException ex) {
                        Debug.warn((Throwable)ex);
                    }
                    break;
                }
                this.data.write(this.chanSet, this.pos, block.data, block.amount);
                this.pos += (long)block.amount;
            }
            catch (IOException ex) {
                this.ioException = ex;
                break;
            }
        }
        blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.alive) {
            return;
        }
        BlockingQueue<Block> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            while (!this.queue.isEmpty()) {
                ThreadUtils.wait(this.queue);
            }
        }
        this.queue.clear();
        this.alive = false;
        while (this.writer.isAlive()) {
            this.queue.offer(EOF_MARK);
        }
    }

    static class Block {
        float[][] data;
        int amount;

        Block() {
        }
    }
}

