/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import java.util.BitSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.corebounce.common.utils.IDisposable;

public class LookAheadReader
implements Runnable,
IDisposable {
    private static final boolean DISABLE_CACHE = "true".equalsIgnoreCase(System.getProperty("NoHardCache"));
    private static final int QUEUE_SIZE = CacheSizes.getProcessBlocksPerSampleCaches() * 8;
    private final AudioChannels data;
    private final BitSet chanSet;
    private final int blockSize;
    private final long stopPos;
    private final BlockingQueue<float[][]> queue;
    private final float[][][] buffers;
    private int bufferIndex;
    private Thread reader;
    private long pos;
    private volatile boolean alive;
    private volatile IOException ioException;

    public LookAheadReader(AudioChannels data, BitSet chanSet, int blockSize, long startPos, long stopPos) {
        this.data = data;
        this.chanSet = chanSet;
        this.blockSize = blockSize;
        this.pos = startPos;
        this.stopPos = stopPos;
        if (DISABLE_CACHE) {
            this.queue = null;
            this.buffers = null;
        } else {
            this.queue = new ArrayBlockingQueue<float[][]>(QUEUE_SIZE);
            this.buffers = new float[QUEUE_SIZE + 2][chanSet.cardinality()][blockSize];
            this.reader = new Thread((Runnable)this, "LookAhead Audio Reader");
            this.reader.setDaemon(true);
            this.alive = true;
            this.reader.start();
        }
    }

    public void readNext(float[][] output) throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (DISABLE_CACHE) {
            int amount = (int)Math.min((long)this.blockSize, this.stopPos - this.pos);
            this.data.read(this.chanSet, this.pos, output, amount);
            this.pos += (long)this.blockSize;
        } else {
            try {
                float[][] buffer = this.queue.take();
                int i = 0;
                while (i < buffer.length) {
                    System.arraycopy(buffer[i], 0, output[i], 0, this.blockSize);
                    ++i;
                }
            }
            catch (InterruptedException ex) {
                Debug.error((Throwable)ex);
            }
        }
    }

    public void run() {
        while (this.alive && this.pos < this.stopPos) {
            try {
                int amount = (int)Math.min((long)this.blockSize, this.stopPos - this.pos);
                this.data.read(this.chanSet, this.pos, this.buffers[this.bufferIndex], amount);
                try {
                    this.queue.put(this.buffers[this.bufferIndex]);
                }
                catch (InterruptedException ex) {
                    break;
                }
                this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
                this.pos += (long)this.blockSize;
            }
            catch (IOException ex) {
                this.ioException = ex;
                break;
            }
        }
    }

    public void dispose() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        while (this.reader.isAlive()) {
            this.queue.poll();
        }
    }
}

