/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.audio;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.corebounce.common.utils.IDisposable;

public class ParallelReadDeleteInsert
implements IDisposable {
    private static final int QUEUE_SIZE = CacheSizes.getProcessBlocksPerSampleCaches() * 8;
    private static final AudioBuffer EOF_MARK = new AudioBuffer(0, 0);
    private final AudioChannels data;
    private final BitSet chanSet;
    private final int blockSize;
    private final BlockingQueue<float[][]> deleteQueue;
    private final BlockingQueue<AudioBuffer> insertQueue;
    private final float[][][] readBuffers;
    private final AudioBuffer[] writeBuffers;
    private float[][] curReadBuffer;
    private int curReadIndex;
    private final Object ioLock = new Monitor("ioLock");
    private final long total;
    private int readBufferIndex;
    private int writeBufferIndex;
    private long deletePos;
    private long done;
    private Thread inserter;
    private Thread deleter;
    private volatile boolean alive;
    private volatile IOException ioException;

    public ParallelReadDeleteInsert(AudioChannels data, BitSet chanSet, int blockSize, long pos, long total) {
        this.data = data;
        this.chanSet = chanSet;
        this.blockSize = blockSize;
        this.deletePos = pos;
        this.total = total;
        this.deleteQueue = new ArrayBlockingQueue<float[][]>(QUEUE_SIZE);
        this.insertQueue = new ArrayBlockingQueue<AudioBuffer>(QUEUE_SIZE);
        this.readBuffers = new float[QUEUE_SIZE + 2][chanSet.cardinality()][blockSize];
        this.writeBuffers = new AudioBuffer[QUEUE_SIZE + 2];
        this.deleter = new Thread(new Runnable(){

            public void run() {
                ParallelReadDeleteInsert.this.readDeleteLoop();
            }
        }, "LookAhead Audio Read/Delete");
        this.deleter.setDaemon(true);
        this.inserter = new Thread(new Runnable(){

            public void run() {
                ParallelReadDeleteInsert.this.insertLoop();
            }
        }, "Delayed Audio Inserter");
        this.inserter.setDaemon(true);
        this.alive = true;
        this.deleter.start();
        this.inserter.start();
    }

    public void readDeleteNext(float[][] output) throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        int dstIndex = 0;
        try {
            while (dstIndex < output[0].length) {
                if (this.curReadBuffer == null || this.curReadIndex >= this.curReadBuffer[0].length) {
                    this.curReadBuffer = this.deleteQueue.take();
                    this.curReadIndex = 0;
                }
                int amount = Math.min(output[0].length - dstIndex, this.curReadBuffer[0].length - this.curReadIndex);
                int i = 0;
                while (i < output.length) {
                    System.arraycopy(this.curReadBuffer[i], this.curReadIndex, output[i], dstIndex, amount);
                    ++i;
                }
                this.curReadIndex += amount;
                dstIndex += amount;
            }
        }
        catch (InterruptedException ex) {
            Debug.error((Throwable)ex);
        }
    }

    public void insertNext(float[][] data) throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        AudioBuffer buffer = this.writeBuffers[this.writeBufferIndex];
        if (buffer == null || buffer.data[0].length < data[0].length) {
            this.writeBuffers[this.writeBufferIndex] = buffer = new AudioBuffer(data.length, data[0].length);
        }
        buffer.nbSamples = data[0].length;
        this.writeBufferIndex = (this.writeBufferIndex + 1) % this.writeBuffers.length;
        int i = 0;
        while (i < data.length) {
            System.arraycopy(data[i], 0, buffer.data[i], 0, data[i].length);
            ++i;
        }
        try {
            this.insertQueue.put(buffer);
        }
        catch (InterruptedException ex) {
            Debug.error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDeleteLoop() {
        while (this.alive) {
            try {
                int amount = (int)Math.min((long)this.blockSize, this.total - this.done);
                if (amount > 0) {
                    Object object = this.ioLock;
                    synchronized (object) {
                        this.data.read(this.chanSet, this.deletePos, this.readBuffers[this.readBufferIndex], amount);
                        this.data.delete(this.chanSet, this.deletePos, amount);
                    }
                }
                if (amount < this.blockSize) {
                    int i = 0;
                    while (i < this.readBuffers[this.readBufferIndex].length) {
                        Arrays.fill(this.readBuffers[this.readBufferIndex][i], amount, this.blockSize, 0.0f);
                        ++i;
                    }
                }
                try {
                    this.deleteQueue.put(this.readBuffers[this.readBufferIndex]);
                }
                catch (InterruptedException ex) {
                    break;
                }
                this.readBufferIndex = (this.readBufferIndex + 1) % this.readBuffers.length;
                this.done += (long)amount;
            }
            catch (IOException ex) {
                this.ioException = ex;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLoop() {
        BlockingQueue<AudioBuffer> blockingQueue;
        AudioBuffer insertData = null;
        while (this.alive) {
            try {
                block16: {
                    if (this.insertQueue.isEmpty()) {
                        blockingQueue = this.insertQueue;
                        synchronized (blockingQueue) {
                            this.insertQueue.notify();
                        }
                    }
                    try {
                        insertData = this.insertQueue.take();
                        if (insertData == EOF_MARK) {
                        }
                        break block16;
                    }
                    catch (InterruptedException ex) {
                        Debug.warn((Throwable)ex);
                    }
                    break;
                }
                int amount = insertData.nbSamples;
                Object object = this.ioLock;
                synchronized (object) {
                    this.data.insert(this.chanSet, this.deletePos, insertData.data, amount);
                    this.deletePos += (long)amount;
                }
            }
            catch (IOException ex) {
                this.ioException = ex;
                break;
            }
        }
        blockingQueue = this.insertQueue;
        synchronized (blockingQueue) {
            this.insertQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        BlockingQueue<AudioBuffer> blockingQueue = this.insertQueue;
        synchronized (blockingQueue) {
            while (!this.insertQueue.isEmpty()) {
                ThreadUtils.wait(this.insertQueue);
            }
        }
        this.insertQueue.clear();
        this.alive = false;
        while (this.inserter.isAlive()) {
            this.insertQueue.offer(EOF_MARK);
        }
        while (this.deleter.isAlive()) {
            this.deleteQueue.poll();
        }
    }

    static class AudioBuffer {
        public float[][] data;
        public int nbSamples;

        public AudioBuffer(int nbChannels, int nbSamples) {
            this.nbSamples = nbSamples;
            this.data = new float[nbChannels][nbSamples];
        }
    }
}

