/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.corebounce.common.struct.CacheMap;

public class BufferedByteFile
implements ISimpleByteFile {
    private static final boolean DISABLE_HARD_CACHE = "true".equalsIgnoreCase(System.getProperty("NoHardCache"));
    private static final boolean DISABLE_CACHE = "true".equalsIgnoreCase(System.getProperty("NoCache"));
    private static final int BUFFER_SIZE = CacheSizes.getByteCacheSize();
    private static final int MAX_WRITE_BUFFERS = DISABLE_HARD_CACHE ? 1 : 40;
    private static final int MAX_CACHED_INSTANCES = 20;
    private static volatile int nbInstances = 0;
    private final ISimpleByteFile target;
    private Queue<Buffer> writeQueue = new LinkedList<Buffer>();
    private Map<Long, Buffer> readCache = new CacheMap<Long, Buffer>();
    private boolean dataWritten = false;

    public BufferedByteFile(ISimpleByteFile target) {
        this.target = target;
        ++nbInstances;
    }

    private long roundToBufferPos(long position) {
        return position - position % (long)BUFFER_SIZE;
    }

    public int read(long pos, byte[] where, int offset, int length) throws IOException {
        if (DISABLE_CACHE) {
            return this.target.read(pos, where, offset, length);
        }
        int remaining = length;
        while (remaining > 0) {
            long bufferPos = this.roundToBufferPos(pos);
            Buffer buffer = this.loadBuffer(bufferPos);
            int bufferOffset = (int)(pos - bufferPos);
            assert (bufferOffset >= 0 && bufferOffset < BUFFER_SIZE);
            int amount = Math.min(buffer.size - bufferOffset, remaining);
            System.arraycopy(buffer.data, bufferOffset, where, offset, amount);
            remaining -= amount;
            pos += (long)amount;
            offset += amount;
            if (buffer.size < BUFFER_SIZE) break;
        }
        return length - remaining;
    }

    private Buffer loadBuffer(long bufferPos) throws IOException {
        assert (bufferPos % (long)BUFFER_SIZE == 0L);
        Buffer result = this.readCache.get(bufferPos);
        if (result != null) {
            return result;
        }
        for (Buffer buffer : this.writeQueue) {
            if (buffer.position != bufferPos) continue;
            return buffer;
        }
        result = new Buffer(bufferPos);
        result.size = this.target.read(bufferPos, result.data, 0, BUFFER_SIZE);
        this.readCache.put(bufferPos, result);
        return result;
    }

    public void write(long pos, byte[] data, int offset, int length) throws IOException {
        int remaining = length;
        while (remaining > 0) {
            long bufferPos = this.roundToBufferPos(pos);
            Buffer buffer = this.readCache.remove(bufferPos);
            int bufferOffset = (int)(pos - bufferPos);
            assert (bufferOffset >= 0 && bufferOffset < BUFFER_SIZE);
            int amount = Math.min(BUFFER_SIZE - bufferOffset, remaining);
            if (DISABLE_CACHE) {
                this.target.write(pos, data, offset, amount);
            } else {
                this.delayedWrite(buffer, pos, data, offset, amount);
            }
            remaining -= amount;
            pos += (long)amount;
            offset += amount;
        }
    }

    private void delayedWrite(Buffer cachedBuffer, long pos, byte[] data, int offset, int length) throws IOException {
        long bufferPos = this.roundToBufferPos(pos);
        int bufferOffset = (int)(pos - bufferPos);
        Buffer buffer = null;
        Iterator iter = this.writeQueue.iterator();
        while (iter.hasNext()) {
            Buffer item = (Buffer)iter.next();
            if (item.position != bufferPos) continue;
            buffer = item;
            iter.remove();
            break;
        }
        if (buffer == null) {
            buffer = cachedBuffer;
        }
        if (buffer == null) {
            buffer = new Buffer(bufferPos);
            if (bufferPos < pos || bufferOffset + length < BUFFER_SIZE) {
                buffer.size = this.target.read(bufferPos, buffer.data, 0, BUFFER_SIZE);
            }
        }
        System.arraycopy(data, offset, buffer.data, bufferOffset, length);
        buffer.size = Math.max(buffer.size, bufferOffset + length);
        buffer.dirty = true;
        this.writeQueue.add(buffer);
        while (this.writeQueue.size() > MAX_WRITE_BUFFERS) {
            Buffer last = this.writeQueue.remove();
            if (!last.dirty) continue;
            this.target.write(last.position, last.data, 0, last.size);
            this.dataWritten = true;
        }
    }

    public long getLength() {
        long result = this.target.getLength();
        for (Buffer buffer : this.writeQueue) {
            if (!buffer.dirty || buffer.position + (long)buffer.size <= result) continue;
            result = buffer.position + (long)buffer.size;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void flush() throws IOException {
        if (this.dataWritten || BufferedByteFile.nbInstances > 20) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            buffer = this.writeQueue.remove();
            if (!buffer.dirty) continue;
            this.target.write(buffer.position, buffer.data, 0, buffer.size);
lbl6:
            // 3 sources

            ** while (!this.writeQueue.isEmpty())
        }
lbl7:
        // 1 sources

    }

    public void dispose() {
        this.target.dispose();
        --nbInstances;
    }

    static class Buffer {
        long position;
        byte[] data = new byte[BufferedByteFile.access$0()];
        int size;
        boolean dirty;

        public Buffer(long position) {
            assert (position % (long)BUFFER_SIZE == 0L);
            this.position = position;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("pos:");
            result.append(this.position);
            result.append(",size:");
            result.append(this.size);
            result.append(",dirty:");
            result.append(this.dirty);
            return result.toString();
        }
    }
}

