/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.corebounce.common.io.TempFileManager;
import org.corebounce.common.utils.IDisposable;

public class SimpleByteFile
implements IDisposable,
ISimpleByteFile {
    private static final int BUFFER_SIZE = CacheSizes.getByteCacheSize();
    private final String namePrefix;
    private File file = null;
    private RandomAccessFile raFile = null;
    private FileChannel channel = null;
    private final ByteBuffer byteBuffer;
    private long curPosition;
    private long length;

    public SimpleByteFile(String namePrefix) throws IOException {
        this.namePrefix = namePrefix;
        this.byteBuffer = SimpleByteFile.createByteBuffer();
    }

    private void ensureFilesOpened() throws IOException {
        if (this.file != null) {
            return;
        }
        this.file = TempFileManager.createTempFile(this.namePrefix, ".tmp");
        this.file.deleteOnExit();
        this.raFile = new RandomAccessFile(this.file, "rw");
        this.channel = this.raFile.getChannel();
    }

    private static ByteBuffer createByteBuffer() {
        ByteBuffer result = null;
        try {
            result = ByteBuffer.allocateDirect(BUFFER_SIZE);
        }
        catch (Throwable t) {
            Debug.warn((String)"allocateDirect() failed, using allocate()", (Object[])new Object[]{t});
        }
        if (result != null) {
            return result;
        }
        return ByteBuffer.allocate(BUFFER_SIZE);
    }

    private void position(long pos) throws IOException {
        this.ensureFilesOpened();
        if (pos != this.curPosition) {
            this.channel.position(pos);
        }
        this.curPosition = pos;
    }

    public synchronized int read(long pos, byte[] target, int offset, int length) throws IOException {
        if (pos >= this.length) {
            return 0;
        }
        this.position(pos);
        int result = 0;
        while (length > 0) {
            int amount = Math.min(BUFFER_SIZE, length);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(amount);
            amount = this.channel.read(this.byteBuffer);
            if (amount < 0) break;
            this.curPosition += (long)amount;
            this.byteBuffer.position(0);
            this.byteBuffer.get(target, offset, amount);
            offset += amount;
            length -= amount;
            result += amount;
        }
        return result;
    }

    public synchronized void write(long pos, byte[] data, int offset, int length) throws IOException {
        this.ensureSize(pos);
        this.length = Math.max(this.length, pos + (long)length);
        this.position(pos);
        while (length > 0) {
            int amount = Math.min(BUFFER_SIZE, length);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(amount);
            this.byteBuffer.put(data, offset, amount);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(amount);
            this.curPosition += (long)this.channel.write(this.byteBuffer);
            offset += amount;
            length -= amount;
        }
    }

    public synchronized long getLength() {
        return this.length;
    }

    private void ensureSize(long newSize) throws IOException {
        this.ensureFilesOpened();
        long curSize = this.getLength();
        if (newSize > curSize) {
            this.setSize(newSize);
        }
    }

    private void setSize(long newSize) throws IOException {
        this.raFile.setLength(newSize);
        this.length = newSize;
    }

    public void flush() throws IOException {
        Debug.info((String)"Flushing", (Object[])new Object[0]);
        this.channel.force(false);
    }

    public synchronized void dispose() {
        boolean success;
        try {
            if (this.raFile != null) {
                this.raFile.close();
            }
        }
        catch (IOException ex) {
            Debug.warn((Throwable)ex);
        }
        if (this.file != null && !(success = TempFileManager.deleteTempFile(this.file))) {
            Debug.warn((String)"Failed to delete temporary file {0}", (Object[])new Object[]{this.file.getPath()});
        }
    }

    public String toString() {
        return "SimpleByteFile[length=" + this.getLength() + "]";
    }
}

