/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.audio;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFloatFile
implements ISimpleFloatFile {
    private static final int MAX_FILE_SIZE = 0x10000000;
    private final Class<? extends ISimpleFloatFile> simpleFloatFileType;
    private final List<ISimpleFloatFile> files = new ArrayList<ISimpleFloatFile>();
    private long size;

    public CompositeFloatFile(Class<? extends ISimpleFloatFile> simpleFloatFileType) {
        this.simpleFloatFileType = simpleFloatFileType;
    }

    private ISimpleFloatFile lookupFile(int fileNum) throws IOException {
        while (this.files.size() <= fileNum) {
            try {
                ISimpleFloatFile file = this.simpleFloatFileType.newInstance();
                this.files.add(file);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
        }
        return this.files.get(fileNum);
    }

    private void assertSize() throws IOException {
        int fileNum = (int)(this.size / 0x10000000L);
        int i = 0;
        while (i < fileNum) {
            assert (this.lookupFile(i).getLength() == 0x10000000L);
            ++i;
        }
        long fileSize = this.size % 0x10000000L;
        assert (this.lookupFile(fileNum).getLength() == fileSize);
    }

    @Override
    public synchronized int read(long pos, float[] target, int offset, int length) throws IOException {
        int result = 0;
        while (length > 0) {
            int fileNum = (int)(pos / 0x10000000L);
            long filePos = pos % 0x10000000L;
            int amount = Math.min(length, (int)(0x10000000L - filePos));
            ISimpleFloatFile file = this.lookupFile(fileNum);
            amount = file.read(filePos, target, offset, amount);
            if (amount <= 0) break;
            pos += (long)amount;
            offset += amount;
            length -= amount;
            result += amount;
        }
        return result;
    }

    @Override
    public synchronized void write(long pos, float[] data, int offset, int length) throws IOException {
        long tmpSize = pos + (long)length;
        if (tmpSize > this.size) {
            this.size = tmpSize;
        }
        while (length > 0) {
            int fileNum = (int)(pos / 0x10000000L);
            long filePos = pos % 0x10000000L;
            int amount = Math.min(length, (int)(0x10000000L - filePos));
            ISimpleFloatFile file = this.lookupFile(fileNum);
            file.write(filePos, data, offset, amount);
            pos += (long)amount;
            offset += amount;
            length -= amount;
        }
        this.assertSize();
    }

    @Override
    public synchronized long getLength() {
        return this.size;
    }

    @Override
    public synchronized void flush() throws IOException {
        for (ISimpleFloatFile file : this.files) {
            file.flush();
        }
    }

    @Override
    public synchronized void dispose() {
        for (ISimpleFloatFile file : this.files) {
            file.dispose();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CompositeFloatFile{length=");
        result.append(this.size);
        result.append(",files=");
        result.append(this.files.size());
        result.append("}");
        return result.toString();
    }
}

