/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.audio;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import org.corebounce.common.io.TempFileManager;

public class SimpleFloatFile
implements ISimpleFloatFile {
    private static final int FLOAT_BUFFER_SIZE = CacheSizes.getSampleCacheSize();
    private final File file = TempFileManager.createTempFile("buffer", ".tmp");
    private final RandomAccessFile raFile;
    private final FileChannel channel;
    private final ByteBuffer byteBuffer;
    private final FloatBuffer floatBuffer;
    private long length;

    public SimpleFloatFile() throws IOException {
        this.file.deleteOnExit();
        this.raFile = new RandomAccessFile(this.file, "rw");
        this.channel = this.raFile.getChannel();
        this.byteBuffer = SimpleFloatFile.createByteBuffer();
        this.floatBuffer = this.byteBuffer.asFloatBuffer();
        this.length = 0L;
    }

    private static ByteBuffer createByteBuffer() {
        ByteBuffer result = null;
        try {
            result = ByteBuffer.allocateDirect(BLOCK_SIZE_BYTE);
        }
        catch (Throwable t) {
            Debug.warn((String)"allocateDirect() failed, using allocate()", (Object[])new Object[]{t});
        }
        if (result != null) {
            return result;
        }
        return ByteBuffer.allocate(BLOCK_SIZE_BYTE);
    }

    public synchronized int read(long pos, float[] target, int offset, int length) throws IOException {
        this.channel.position(pos * 4L);
        int result = 0;
        while (length > 0) {
            int amount = Math.min(FLOAT_BUFFER_SIZE, length);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(amount * 4);
            this.floatBuffer.limit(amount);
            int byteAmount = this.channel.read(this.byteBuffer);
            if (byteAmount < 0) break;
            amount = byteAmount / 4;
            this.floatBuffer.position(0);
            this.floatBuffer.get(target, offset, amount);
            offset += amount;
            length -= amount;
            result += amount;
        }
        return result;
    }

    public synchronized void write(long pos, float[] data, int offset, int length) throws IOException {
        this.ensureSize(pos);
        this.channel.position(pos * 4L);
        this.length = Math.max(this.length, pos + (long)length);
        while (length > 0) {
            int amount = Math.min(FLOAT_BUFFER_SIZE, length);
            this.byteBuffer.limit(amount * 4);
            this.floatBuffer.position(0);
            this.floatBuffer.limit(amount);
            this.floatBuffer.put(data, offset, amount);
            this.byteBuffer.position(0);
            this.channel.write(this.byteBuffer);
            offset += amount;
            length -= amount;
        }
    }

    public synchronized long getLength() {
        return this.length;
    }

    private void ensureSize(long newSize) throws IOException {
        long curSize = this.getLength();
        if (newSize > curSize) {
            this.setSize(newSize);
        }
    }

    private void setSize(long newSize) throws IOException {
        this.length = newSize;
        this.raFile.setLength(newSize * 4L);
    }

    public synchronized void flush() {
    }

    public synchronized void dispose() {
        try {
            this.raFile.close();
        }
        catch (IOException ex) {
            Debug.warn((Throwable)ex);
        }
        boolean success = TempFileManager.deleteTempFile(this.file);
        if (!success) {
            Debug.warn((String)"Failed to delete temporary file {0}", (Object[])new Object[]{this.file.getPath()});
        }
    }
}

