/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.raw;

import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import ch.tachyon.sonics.data.memory.raw.DiskListNode;
import ch.tachyon.sonics.data.memory.raw.DiskMemory;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskList<E extends IBlockSerializable<E>>
extends AbstractSequentialList<E>
implements IDisposable {
    private final DiskMemory<DiskListNode<E>> memory;
    private long headAddress = -1L;
    private long tailAddress = -1L;
    private int size;
    private transient DiskListIterator lastIterator;
    private final Object lastIteratorLock = new Monitor("lastIteratorLock");

    public DiskList(DiskMemory<DiskListNode<E>> memory) {
        this.memory = memory;
    }

    public DiskList(ISimpleByteFile file, E template) {
        DiskListNode<E> templateNode = new DiskListNode<E>(template);
        this.memory = new DiskMemory<DiskListNode<DiskListNode<E>>>(file, templateNode);
    }

    public void setContext(Object context) {
        this.memory.setContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        DiskListIterator result = new DiskListIterator(index);
        Object object = this.lastIteratorLock;
        synchronized (object) {
            this.lastIterator = result;
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void flush() {
        this.memory.flush();
    }

    @Override
    public void dispose() {
        this.memory.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DiskListIterator
    implements ListIterator<E> {
        private long prevAddress;
        private long nextAddress;
        private DiskListNode<E> prevNode;
        private DiskListNode<E> nextNode;
        private int nextIndex;
        private int lastReturnedIndex = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DiskListIterator(int startIndex) {
            if (startIndex < 0 || startIndex > DiskList.this.size) {
                throw new IndexOutOfBoundsException();
            }
            int fromStart = startIndex;
            int fromEnd = DiskList.this.size - 1 - startIndex;
            int fromLast = Integer.MAX_VALUE;
            long lastPrevAddress = -1L;
            long lastNextAddress = -1L;
            int lastNextIndex = -1;
            Object object = DiskList.this.lastIteratorLock;
            synchronized (object) {
                DiskListIterator last = DiskList.this.lastIterator;
                if (last != null) {
                    fromLast = Math.abs(last.nextIndex - startIndex);
                    lastPrevAddress = last.prevAddress;
                    lastNextAddress = last.nextAddress;
                    lastNextIndex = last.nextIndex;
                }
            }
            if (fromStart <= fromEnd && fromStart <= fromLast) {
                this.prevAddress = -1L;
                this.nextAddress = DiskList.this.headAddress;
                this.nextIndex = 0;
                int i = 0;
                while (i < startIndex) {
                    this.next();
                    ++i;
                }
            } else if (fromEnd <= fromLast) {
                this.prevAddress = DiskList.this.tailAddress;
                this.nextAddress = -1L;
                this.nextIndex = DiskList.this.size;
                int i = DiskList.this.size;
                while (i > startIndex) {
                    this.previous();
                    --i;
                }
            } else {
                this.prevAddress = lastPrevAddress;
                this.nextAddress = lastNextAddress;
                this.nextIndex = lastNextIndex;
                while (this.nextIndex < startIndex) {
                    this.next();
                }
                while (this.nextIndex > startIndex) {
                    this.previous();
                }
            }
            Object object2 = DiskList.this.lastIteratorLock;
            synchronized (object2) {
                DiskList.this.lastIterator = this;
            }
        }

        private DiskListNode<E> prevNode() {
            if (this.prevNode != null) {
                return this.prevNode;
            }
            if (this.prevAddress >= 0L) {
                this.prevNode = (DiskListNode)DiskList.this.memory.read(this.prevAddress);
            }
            return this.prevNode;
        }

        private DiskListNode<E> nextNode() {
            if (this.nextNode != null) {
                return this.nextNode;
            }
            if (this.nextAddress >= 0L) {
                this.nextNode = (DiskListNode)DiskList.this.memory.read(this.nextAddress);
            }
            return this.nextNode;
        }

        private DiskListNode<E> nodeAt(long address) {
            if (address < 0L) {
                return null;
            }
            return (DiskListNode)DiskList.this.memory.read(address);
        }

        @Override
        public boolean hasNext() {
            return this.nextAddress >= 0L;
        }

        @Override
        public E next() {
            if (this.nextAddress < 0L) {
                throw new NoSuchElementException();
            }
            Object result = this.nextNode().getItem();
            this.prevAddress = this.nextAddress;
            this.prevNode = this.nextNode;
            this.nextAddress = this.nextNode.getNextAddress();
            this.nextNode = null;
            this.lastReturnedIndex = this.nextIndex++;
            return result;
        }

        @Override
        public boolean hasPrevious() {
            return this.prevAddress >= 0L;
        }

        @Override
        public E previous() {
            if (this.prevAddress < 0L) {
                throw new NoSuchElementException();
            }
            Object result = this.prevNode().getItem();
            this.nextAddress = this.prevAddress;
            this.nextNode = this.prevNode;
            this.prevAddress = this.prevNode.getPrevAddress();
            this.prevNode = null;
            --this.nextIndex;
            this.lastReturnedIndex = this.nextIndex;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            long removedAddress;
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            if (this.lastReturnedIndex == this.nextIndex) {
                removedAddress = this.nextAddress;
                DiskListNode removeNode = this.nextNode();
                DiskListNode beforeNode = this.prevNode();
                DiskListNode afterNode = this.nodeAt(removeNode.getNextAddress());
                if (beforeNode != null) {
                    beforeNode.setNextAddress(removeNode.getNextAddress());
                    DiskList.this.memory.write(this.prevAddress, beforeNode);
                }
                DiskList.this.memory.free(this.nextAddress);
                if (afterNode != null) {
                    afterNode.setPrevAddress(removeNode.getPrevAddress());
                    DiskList.this.memory.write(removeNode.getNextAddress(), afterNode);
                }
                this.nextAddress = removeNode.getNextAddress();
                this.nextNode = null;
            } else {
                removedAddress = this.prevAddress;
                DiskListNode removeNode = this.prevNode();
                DiskListNode beforeNode = this.nodeAt(removeNode.getPrevAddress());
                DiskListNode afterNode = this.nextNode();
                if (beforeNode != null) {
                    beforeNode.setNextAddress(removeNode.getNextAddress());
                    DiskList.this.memory.write(removeNode.getPrevAddress(), beforeNode);
                }
                DiskList.this.memory.free(this.prevAddress);
                if (afterNode != null) {
                    afterNode.setPrevAddress(removeNode.getPrevAddress());
                    DiskList.this.memory.write(this.nextAddress, afterNode);
                }
                this.prevAddress = removeNode.getPrevAddress();
                this.prevNode = null;
                --this.nextIndex;
            }
            if (DiskList.this.headAddress == removedAddress) {
                assert (this.prevAddress < 0L);
                DiskList.this.headAddress = this.nextAddress;
            }
            if (DiskList.this.tailAddress == removedAddress) {
                assert (this.nextAddress < 0L);
                DiskList.this.tailAddress = this.prevAddress;
            }
            this.lastReturnedIndex = -1;
            DiskList diskList = DiskList.this;
            diskList.size = diskList.size - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            if (this.lastReturnedIndex == this.nextIndex) {
                DiskListNode nextNode = this.nextNode();
                nextNode.setItem(e);
                DiskList.this.memory.write(this.nextAddress, nextNode);
            } else {
                DiskListNode prevNode = this.prevNode();
                prevNode.setItem(e);
                DiskList.this.memory.write(this.prevAddress, prevNode);
            }
        }

        @Override
        public void add(E e) {
            DiskListNode newNode = new DiskListNode(e);
            newNode.setPrevAddress(this.prevAddress);
            newNode.setNextAddress(this.nextAddress);
            long newAddress = DiskList.this.memory.allocate(newNode);
            if (this.prevAddress >= 0L) {
                DiskListNode prevNode = this.prevNode();
                prevNode.setNextAddress(newAddress);
                DiskList.this.memory.write(this.prevAddress, prevNode);
            }
            if (this.nextAddress >= 0L) {
                DiskListNode nextNode = this.nextNode();
                nextNode.setPrevAddress(newAddress);
                DiskList.this.memory.write(this.nextAddress, nextNode);
            }
            if (this.prevAddress < 0L) {
                DiskList.this.headAddress = newAddress;
            }
            if (this.nextAddress < 0L) {
                DiskList.this.tailAddress = newAddress;
            }
            this.prevAddress = newAddress;
            this.prevNode = null;
            ++this.nextIndex;
            this.lastReturnedIndex = -1;
            DiskList diskList = DiskList.this;
            diskList.size = diskList.size + 1;
        }

        public String toString() {
            return "DiskListIterator [prevAddress=" + this.prevAddress + ", nextAddress=" + this.nextAddress + ", nextIndex=" + this.nextIndex + ", lastReturnedIndex=" + this.lastReturnedIndex + "]";
        }
    }
}

