/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.raw;

import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.sonics.data.memory.raw.ISharedContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskListNode<E extends IBlockSerializable<E>>
implements IBlockSerializable<DiskListNode<E>>,
ISharedContext<DiskListNode<E>> {
    private long prevAddress = -1L;
    private long nextAddress = -1L;
    private E item;

    public DiskListNode(E item) {
        this.item = item;
    }

    public long getPrevAddress() {
        return this.prevAddress;
    }

    public void setPrevAddress(long prevAddress) {
        this.prevAddress = prevAddress;
    }

    public long getNextAddress() {
        return this.nextAddress;
    }

    public void setNextAddress(long nextAddress) {
        this.nextAddress = nextAddress;
    }

    public E getItem() {
        return this.item;
    }

    public void setItem(E item) {
        this.item = item;
    }

    @Override
    public void serialize(DataOutputStream target) throws IOException {
        this.item.serialize(target);
        target.writeLong(this.prevAddress);
        target.writeLong(this.nextAddress);
    }

    @Override
    public DiskListNode<E> deserialize(DataInputStream source) throws IOException {
        Object item = this.item.deserialize(source);
        DiskListNode result = new DiskListNode(item);
        result.prevAddress = source.readLong();
        result.nextAddress = source.readLong();
        return result;
    }

    @Override
    public void setContext(Object context) {
        if (this.item instanceof ISharedContext) {
            ((ISharedContext)this.item).setContext(context);
        }
    }
}

