/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.raw;

import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import ch.tachyon.sonics.data.memory.raw.DiskMemoryException;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.sonics.data.memory.raw.ISharedContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.corebounce.common.struct.CacheMap;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskMemory<E extends IBlockSerializable<E>>
implements IDisposable {
    private static final boolean DISABLE_CACHE = "true".equalsIgnoreCase(System.getProperty("NoCache"));
    private final ISimpleByteFile file;
    private final E template;
    private final int itemSize;
    private final byte[] buffer;
    private long firstFreeIndex = -1L;
    private Object context;
    private long nbItems;
    private long nbFreeSlots;
    private final Map<Long, E> cache = new CacheMap<Long, E>();

    public DiskMemory(ISimpleByteFile file, E template) {
        this.file = file;
        this.template = template;
        this.itemSize = DiskMemory.getItemSize(template);
        if (this.itemSize < 4) {
            throw new UnsupportedOperationException("Element size must be >= 4");
        }
        this.buffer = new byte[this.itemSize];
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public static <E extends IBlockSerializable<E>> int getItemSize(E item) {
        return DiskMemory.serialize(item).length;
    }

    private static <E extends IBlockSerializable<E>> byte[] serialize(E item) {
        try {
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
            DataOutputStream oOutput = new DataOutputStream(bOutput);
            item.serialize(oOutput);
            oOutput.flush();
            byte[] result = bOutput.toByteArray();
            bOutput.close();
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private E deserialize(byte[] data) {
        try {
            ByteArrayInputStream bInput = new ByteArrayInputStream(data);
            DataInputStream oInput = new DataInputStream(bInput);
            Object result = this.template.deserialize(oInput);
            oInput.close();
            if (this.context != null && result instanceof ISharedContext) {
                ((ISharedContext)result).setContext(this.context);
            }
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeIndex(long where, long value, boolean full) throws IOException {
        this.buffer[0] = (byte)(value >>> 24 & 0xFFL);
        this.buffer[1] = (byte)(value >>> 16 & 0xFFL);
        this.buffer[2] = (byte)(value >>> 8 & 0xFFL);
        this.buffer[3] = (byte)(value & 0xFFL);
        if (full) {
            Arrays.fill(this.buffer, 4, this.buffer.length, (byte)0);
            this.file.write(where, this.buffer, 0, this.buffer.length);
        } else {
            this.file.write(where, this.buffer, 0, 4);
        }
    }

    private long readIndex(long where) throws IOException {
        this.file.read(where, this.buffer, 0, 4);
        return this.buffer[0] << 24 | (this.buffer[1] & 0xFF) << 16 | (this.buffer[2] & 0xFF) << 8 | this.buffer[3] & 0xFF;
    }

    public long allocate(E item) {
        try {
            long nextFreeIndex;
            if (this.firstFreeIndex < 0L) {
                long address = this.file.getLength();
                byte[] data = DiskMemory.serialize(item);
                this.file.write(address, data, 0, data.length);
                ++this.nbItems;
                if (!DISABLE_CACHE) {
                    this.cache.put(address, item);
                }
                return address;
            }
            long address = this.firstFreeIndex;
            this.firstFreeIndex = nextFreeIndex = this.readIndex(this.firstFreeIndex);
            byte[] data = DiskMemory.serialize(item);
            this.file.write(address, data, 0, this.buffer.length);
            ++this.nbItems;
            --this.nbFreeSlots;
            if (!DISABLE_CACHE) {
                this.cache.put(address, item);
            }
            return address;
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    public void free(long address) {
        try {
            this.writeIndex(address, this.firstFreeIndex, false);
            this.firstFreeIndex = address;
            --this.nbItems;
            ++this.nbFreeSlots;
            this.cache.remove(address);
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    public E read(long address) {
        IBlockSerializable result = (IBlockSerializable)this.cache.get(address);
        if (result != null) {
            return (E)result;
        }
        try {
            this.file.read(address, this.buffer, 0, this.buffer.length);
            result = this.deserialize(this.buffer);
            if (!DISABLE_CACHE) {
                this.cache.put(address, result);
            }
            return (E)result;
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    public void write(long address, E element) {
        try {
            byte[] data = DiskMemory.serialize(element);
            this.file.write(address, data, 0, data.length);
            if (!DISABLE_CACHE) {
                this.cache.put(address, element);
            }
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    public void flush() {
        try {
            this.file.flush();
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    @Override
    public void dispose() {
        this.file.dispose();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Memory[");
        result.append(this.template.getClass().getSimpleName());
        result.append(",nbItems=");
        result.append(this.nbItems);
        result.append(",nbFreeSlots=");
        result.append(this.nbFreeSlots);
        result.append(",file=");
        result.append(this.file.toString());
        result.append("]");
        return result.toString();
    }
}

