/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.raw;

import ch.tachyon.sonics.data.memory.BufferedByteFile;
import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import ch.tachyon.sonics.data.memory.SimpleByteFile;
import ch.tachyon.sonics.data.memory.raw.DiskMemory;
import ch.tachyon.sonics.data.memory.raw.DiskMemoryException;
import ch.tachyon.sonics.data.memory.raw.DiskSkipNode;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.corebounce.common.struct.skiplist.ISkipNode;
import org.corebounce.common.struct.skiplist.SkipNodeManager;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskSkipListContext<E extends IBlockSerializable<E>>
implements SkipNodeManager<E>,
IDisposable {
    private static final int CACHE_SIZE = 500;
    private final String filePrefix;
    private final E itemTemplate;
    private final byte[] nullItem;
    private final List<DiskMemory<DiskSkipNode<E>>> nodeMemories = new ArrayList<DiskMemory<DiskSkipNode<E>>>();
    private final List<ISkipNode<E>> headList = new AbstractList<ISkipNode<E>>(){
        private final List<Long> headAddresses = new ArrayList<Long>();

        @Override
        public ISkipNode<E> get(int index) {
            long address = this.headAddresses.get(index);
            DiskSkipNode result = DiskSkipListContext.this.loadNode(address, index);
            if (result != null) {
                result.setSrcPos(0L);
            }
            return result;
        }

        @Override
        public int size() {
            return this.headAddresses.size();
        }

        @Override
        public ISkipNode<E> set(int index, ISkipNode<E> element) {
            Object result = this.get(index);
            if (element != null) {
                this.headAddresses.set(index, ((DiskSkipNode)element).getAddress());
            } else {
                this.headAddresses.set(index, -1L);
            }
            return result;
        }

        @Override
        public void add(int index, ISkipNode<E> element) {
            this.headAddresses.add(index, ((DiskSkipNode)element).getAddress());
        }

        @Override
        public ISkipNode<E> remove(int index) {
            Object result = this.get(index);
            this.headAddresses.remove(index);
            return result;
        }
    };
    private long firstAddress = -1L;
    private long lastAddress = -1L;
    private final Map<AddressKey, DiskSkipNode<E>> addressToNode = new LinkedHashMap<AddressKey, DiskSkipNode<E>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<AddressKey, DiskSkipNode<E>> eldest) {
            DiskSkipNode oldestNode;
            boolean result;
            boolean bl = result = this.size() > 500;
            if (result && (oldestNode = eldest.getValue()).isDirty()) {
                DiskSkipListContext.this.saveNode(oldestNode);
            }
            return result;
        }
    };

    public DiskSkipListContext(E itemTemplate, String filePrefix) {
        this.itemTemplate = itemTemplate;
        int itemSize = DiskMemory.getItemSize(itemTemplate);
        this.nullItem = new byte[itemSize];
        this.filePrefix = filePrefix;
    }

    private DiskMemory<DiskSkipNode<E>> memory(int level) {
        int index = level + 1;
        while (this.nodeMemories.size() <= index) {
            try {
                ISimpleByteFile file = new SimpleByteFile(String.valueOf(this.filePrefix) + this.nodeMemories.size() + "-");
                file = new BufferedByteFile(file);
                DiskSkipNode template = new DiskSkipNode(this, this.nodeMemories.size() - 1);
                DiskMemory memory = new DiskMemory(file, template);
                this.nodeMemories.add(memory);
            }
            catch (IOException ex) {
                throw new DiskMemoryException("Cannot create temporary file", ex);
            }
        }
        return this.nodeMemories.get(index);
    }

    @Override
    public synchronized DiskSkipNode<E> newNode(int level) {
        DiskSkipNode result = new DiskSkipNode(this, level);
        long address = this.memory(level).allocate(result);
        result.setAddress(address);
        return result;
    }

    @Override
    public List<ISkipNode<E>> headList() {
        return this.headList;
    }

    @Override
    public ISkipNode<E> getFirst() {
        if (this.firstAddress < 0L) {
            return null;
        }
        DiskSkipNode<E> node = this.loadNode(this.firstAddress, -1);
        node.setSrcPos(0L);
        return node;
    }

    @Override
    public void setFirst(ISkipNode<E> node) {
        this.firstAddress = node == null ? -1L : ((DiskSkipNode)node).getAddress();
    }

    @Override
    public ISkipNode<E> getLast() {
        if (this.lastAddress < 0L) {
            return null;
        }
        DiskSkipNode<E> node = this.loadNode(this.lastAddress, -1);
        return node;
    }

    @Override
    public void setLast(ISkipNode<E> node) {
        this.lastAddress = node == null ? -1L : ((DiskSkipNode)node).getAddress();
    }

    AddressKey keyOf(DiskSkipNode<E> node) {
        return new AddressKey(node.getLevel(), node.getAddress());
    }

    synchronized void disposeNode(DiskSkipNode<E> node) {
        if (node.getAddress() < 0L) {
            return;
        }
        long address = node.getAddress();
        AddressKey key = this.keyOf(node);
        this.addressToNode.remove(key);
        this.memory(node.getLevel()).free(address);
    }

    synchronized void cache(DiskSkipNode<E> node, AddressKey key) {
        if (node.getAddress() < 0L) {
            throw new IllegalArgumentException();
        }
        this.addressToNode.put(key, node);
        assert (this.addressToNode.size() <= 500);
    }

    private void saveNode(DiskSkipNode<E> node) {
        if (node.isDirty()) {
            this.memory(node.getLevel()).write(node.getAddress(), node);
        }
        node.setSaved();
    }

    synchronized DiskSkipNode<E> loadNode(long address, int level) {
        if (address < 0L) {
            return null;
        }
        AddressKey key = new AddressKey(level, address);
        DiskSkipNode<E> result = this.addressToNode.get(key);
        if (result == null) {
            result = this.memory(level).read(address);
            result.setAddress(address);
            assert (result.getLevel() == level);
            assert (result.getAddress() == address);
            this.cache(result, key);
        }
        return result;
    }

    void appendNullItem(DataOutputStream output) throws DiskMemoryException {
        try {
            output.write(this.nullItem);
        }
        catch (IOException ex) {
            throw new DiskMemoryException(ex);
        }
    }

    E getItemTemplate() {
        return this.itemTemplate;
    }

    public synchronized void flush() {
        for (DiskSkipNode<E> diskSkipNode : this.addressToNode.values()) {
            if (!diskSkipNode.isDirty()) continue;
            this.saveNode(diskSkipNode);
        }
        this.addressToNode.clear();
        for (DiskMemory diskMemory : this.nodeMemories) {
            diskMemory.flush();
        }
    }

    @Override
    public void dispose() {
        for (DiskMemory<DiskSkipNode<E>> memory : this.nodeMemories) {
            memory.dispose();
        }
        this.nodeMemories.clear();
        this.addressToNode.clear();
    }

    static class AddressKey {
        public final int level;
        public final long address;

        public AddressKey(int level, long address) {
            this.level = level;
            this.address = address;
        }

        public int hashCode() {
            return (int)this.address ^ (int)(this.address >>> 32) ^ this.level;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AddressKey) {
                AddressKey other = (AddressKey)obj;
                return this.level == other.level && this.address == other.address;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.level) + "@" + this.address;
        }
    }
}

