/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.raw;

import ch.tachyon.sonics.data.memory.raw.DiskSkipListContext;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.corebounce.common.struct.skiplist.IHasCoverage;
import org.corebounce.common.struct.skiplist.ISkipNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskSkipNode<E extends IBlockSerializable<E>>
implements ISkipNode<E>,
IBlockSerializable<DiskSkipNode<E>>,
Cloneable {
    private final DiskSkipListContext<E> context;
    private long address = -1L;
    private final int level;
    private int width;
    private int nbElements;
    private long coverage;
    private long srcPos = -1L;
    private long nextAddress = -1L;
    private long prevAddress = -1L;
    private long downAddress = -1L;
    private E item;
    private boolean dirty = false;

    public DiskSkipNode(DiskSkipListContext<E> context, int level) {
        this.context = context;
        this.level = level;
    }

    private void markDirty() {
        assert (this.address >= 0L);
        if (!this.dirty) {
            this.dirty = true;
            this.context.cache(this, this.context.keyOf(this));
        }
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setSaved() {
        this.dirty = false;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setAddress(long address) {
        if (this.address >= 0L && this.address != address) {
            throw new IllegalStateException();
        }
        this.address = address;
    }

    public long getAddress() {
        return this.address;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.markDirty();
    }

    @Override
    public int getNbElements() {
        return this.nbElements;
    }

    @Override
    public void setNbElements(int nbElements) {
        this.nbElements = nbElements;
        this.markDirty();
    }

    @Override
    public long getCoverage() {
        return this.coverage;
    }

    @Override
    public void setCoverage(long coverage) {
        this.coverage = coverage;
        this.markDirty();
    }

    @Override
    public void setSrcPos(long value) {
        assert (value >= 0L);
        this.srcPos = value;
    }

    @Override
    public long getSrcPos() {
        return this.srcPos;
    }

    @Override
    public ISkipNode<E> getNext() {
        DiskSkipNode<E> next = this.context.loadNode(this.nextAddress, this.level);
        if (next != null) {
            next.setSrcPos(this.srcPos + this.coverage);
        }
        return next;
    }

    @Override
    public void setNext(ISkipNode<E> next) {
        if (next == null) {
            this.nextAddress = -1L;
        } else {
            this.nextAddress = ((DiskSkipNode)next).getAddress();
            if (this.nextAddress < 0L) {
                throw new IllegalArgumentException("Node has not been allocated yet");
            }
            next.setSrcPos(this.srcPos + this.coverage);
        }
        this.markDirty();
    }

    @Override
    public ISkipNode<E> getPrev() {
        DiskSkipNode<E> prev = this.context.loadNode(this.prevAddress, this.level);
        if (prev != null) {
            prev.setSrcPos(this.srcPos - prev.getCoverage());
        }
        return prev;
    }

    @Override
    public void setPrev(ISkipNode<E> prev) {
        if (prev == null) {
            this.prevAddress = -1L;
        } else {
            this.prevAddress = ((DiskSkipNode)prev).getAddress();
            if (this.prevAddress < 0L) {
                throw new IllegalArgumentException("Node has not been allocated yet");
            }
            prev.setSrcPos(this.srcPos - prev.getCoverage());
        }
        this.markDirty();
    }

    @Override
    public ISkipNode<E> getDown() {
        DiskSkipNode<E> down = null;
        if (this.level >= 0) {
            down = this.context.loadNode(this.downAddress, this.level - 1);
        }
        if (down != null) {
            down.setSrcPos(this.srcPos);
        }
        return down;
    }

    @Override
    public void setDown(ISkipNode<E> down) {
        if (down == null) {
            this.downAddress = -1L;
        } else {
            this.downAddress = ((DiskSkipNode)down).getAddress();
            if (this.downAddress < 0L) {
                throw new IllegalArgumentException("Node has not been allocated yet");
            }
            down.setSrcPos(this.srcPos);
        }
        this.markDirty();
    }

    @Override
    public E getItem() {
        E result = this.item;
        if (result instanceof IHasCoverage) {
            ((IHasCoverage)result).setSrcPos(this.srcPos);
        }
        return result;
    }

    @Override
    public void setItem(E item) {
        this.item = item;
        if (item instanceof IHasCoverage) {
            this.coverage = ((IHasCoverage)item).getCoverage();
            ((IHasCoverage)item).setSrcPos(this.srcPos);
        } else {
            this.coverage = 1L;
        }
        this.markDirty();
    }

    @Override
    public E getAggregate() {
        E result = this.item;
        if (result instanceof IHasCoverage) {
            ((IHasCoverage)result).setSrcPos(this.srcPos);
        }
        return result;
    }

    @Override
    public void setAggregate(E item) {
        this.item = item;
        if (item instanceof IHasCoverage) {
            ((IHasCoverage)item).setSrcPos(this.srcPos);
        }
        this.markDirty();
    }

    @Override
    public void dispose() {
        this.context.disposeNode(this);
        this.address = -1L;
        this.dirty = false;
    }

    @Override
    public void serialize(DataOutputStream target) throws IOException {
        target.writeInt(this.level);
        target.writeInt(this.width);
        target.writeInt(this.nbElements);
        target.writeLong(this.coverage);
        target.writeLong(this.nextAddress);
        target.writeLong(this.prevAddress);
        target.writeLong(this.downAddress);
        if (this.item == null) {
            target.writeBoolean(false);
            this.context.appendNullItem(target);
        } else {
            target.writeBoolean(true);
            this.item.serialize(target);
        }
    }

    @Override
    public DiskSkipNode<E> deserialize(DataInputStream source) throws IOException {
        int level = source.readInt();
        DiskSkipNode<E> result = new DiskSkipNode<E>(this.context, level);
        result.width = source.readInt();
        result.nbElements = source.readInt();
        result.coverage = source.readLong();
        result.nextAddress = source.readLong();
        result.prevAddress = source.readLong();
        result.downAddress = source.readLong();
        boolean hasItem = source.readBoolean();
        if (hasItem) {
            Object item = this.context.getItemTemplate().deserialize(source);
            result.item = item;
        }
        return result;
    }

    public DiskSkipNode<E> clone() {
        try {
            return (DiskSkipNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.address ^ this.address >>> 32);
        result = 31 * result + this.level;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskSkipNode other = (DiskSkipNode)obj;
        if (this.address != other.address) {
            return false;
        }
        return this.level == other.level;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.address);
        result.append("[");
        result.append("#elts=");
        result.append(this.nbElements);
        result.append(",width=");
        result.append(this.width);
        result.append(",coverage=");
        result.append(this.coverage);
        result.append(",next=");
        result.append(this.nextAddress);
        result.append(",prev=");
        result.append(this.prevAddress);
        result.append(",down=");
        result.append(this.downAddress);
        result.append("]: ");
        result.append(String.valueOf(this.item));
        return result.toString();
    }
}

