/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.corebounce.common.struct.PublicCloneable;
import org.corebounce.common.struct.skiplist.IHasCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Comparable<Block>,
PublicCloneable<Block>,
IBlockSerializable<Block>,
IHasCoverage,
Serializable {
    private long srcPos;
    private long dstPos;
    private long length;
    private AudioStatistics statistics;

    public Block(long srcPos, long dstPos, long length) {
        this.srcPos = srcPos;
        this.dstPos = dstPos;
        this.length = length;
    }

    @Override
    public void setSrcPos(long srcPos) {
        this.srcPos = srcPos;
    }

    @Override
    public long getSrcPos() {
        return this.srcPos;
    }

    public void setDstPos(long dstPos) {
        this.dstPos = dstPos;
        this.invalidateStats();
    }

    public long getDstPos() {
        return this.dstPos;
    }

    public void setLength(long length) {
        this.length = length;
        this.invalidateStats();
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public long getCoverage() {
        return this.length;
    }

    public AudioStatistics getStatistics(ISimpleFloatFile file) throws IOException {
        if (this.statistics == null) {
            this.statistics = new AudioStatistics();
            this.statistics.compute(file, this);
        }
        return this.statistics;
    }

    public AudioStatistics peekStatistics() {
        return this.statistics;
    }

    void setStatistics(AudioStatistics statistics) {
        this.statistics = statistics;
    }

    void append(Block other) {
        assert (this.srcPos + this.length == other.srcPos);
        assert (this.dstPos + this.length == other.dstPos);
        if (this.statistics != null && other.statistics != null) {
            AudioStatistics stats = new AudioStatistics();
            stats.accumulate(this.statistics, this.length);
            stats.accumulate(other.statistics, other.length);
            stats.normalize(this.length + other.length);
            this.statistics = stats;
        } else {
            this.statistics = null;
        }
        this.length += other.length;
    }

    private void invalidateStats() {
        this.statistics = null;
    }

    public boolean hasStatistics() {
        return this.statistics != null;
    }

    public void computeCommonStatistics(float[] data, int offset) {
        if (this.statistics == null) {
            this.statistics = new AudioStatistics();
        }
        this.statistics.compute(data, offset, this.length);
    }

    public boolean crosses(long pos) {
        return this.srcPos <= pos && this.srcPos + this.length > pos;
    }

    public boolean crosses(long pos, int length) {
        return this.srcPos < pos + (long)length && this.srcPos + this.length > pos;
    }

    public boolean within(long pos, int length) {
        return this.srcPos >= pos && this.srcPos + this.length <= pos + (long)length;
    }

    public boolean contains(long pos, int length) {
        return this.srcPos <= pos && this.srcPos + this.length >= pos + (long)length;
    }

    public boolean endsAt(long pos) {
        return this.srcPos + this.length == pos;
    }

    public void contentChanged() {
        this.invalidateStats();
    }

    public void shrinkRight(long stopPos) {
        long newLength = stopPos - this.srcPos;
        if (newLength != this.length) {
            this.length = newLength;
            this.invalidateStats();
        }
    }

    public void shrinkLeft(long startPos) {
        int shrink = (int)(startPos - this.srcPos);
        if (shrink != 0) {
            this.length -= (long)shrink;
            this.srcPos += (long)shrink;
            this.dstPos += (long)shrink;
            this.invalidateStats();
        }
    }

    public void shift(long offset) {
        this.srcPos += offset;
    }

    @Override
    public int compareTo(Block other) {
        if (this.srcPos < other.srcPos) {
            return -1;
        }
        if (this.srcPos > other.srcPos) {
            return 1;
        }
        return 0;
    }

    @Override
    public void serialize(DataOutputStream target) throws IOException {
        target.writeLong(this.srcPos);
        target.writeLong(this.dstPos);
        target.writeLong(this.length);
        if (this.statistics != null) {
            this.statistics.serialize(target);
        } else {
            AudioStatistics.serializeNull(target);
        }
    }

    @Override
    public Block deserialize(DataInputStream source) throws IOException {
        long srcPos = source.readLong();
        long dstPos = source.readLong();
        long length = source.readLong();
        Block result = new Block(srcPos, dstPos, length);
        AudioStatistics stats = new AudioStatistics();
        stats.selfDeserialize(source);
        if (!stats.isUnknown()) {
            result.statistics = stats;
        }
        return result;
    }

    @Override
    public Block clone() {
        try {
            Block result = (Block)super.clone();
            result.statistics = null;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public Block copy() {
        try {
            Block result = (Block)super.clone();
            if (this.statistics != null) {
                result.statistics = this.statistics.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.dstPos ^ this.dstPos >>> 32);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.srcPos ^ this.srcPos >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Block other = (Block)obj;
        if (this.dstPos != other.dstPos) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.srcPos == other.srcPos;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Block[");
        result.append(this.srcPos);
        result.append(":");
        result.append(this.length);
        result.append("]@");
        result.append(this.dstPos);
        return result.toString();
    }
}

