/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import java.util.Collection;
import org.corebounce.common.struct.skiplist.IAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockAggregator
implements IAggregator<Block> {
    private final ISimpleFloatFile file;

    public BlockAggregator(ISimpleFloatFile file) {
        this.file = file;
    }

    @Override
    public Block aggregate(Collection<Block> items) {
        long startPos = Long.MAX_VALUE;
        long stopPos = Long.MIN_VALUE;
        long totalLength = 0L;
        AudioStatistics aggStats = new AudioStatistics();
        for (Block block : items) {
            startPos = Math.min(startPos, block.getSrcPos());
            stopPos = Math.max(stopPos, block.getSrcPos() + block.getLength());
            try {
                AudioStatistics stats = block.getStatistics(this.file);
                aggStats.accumulate(stats, block.getLength());
                totalLength += block.getLength();
            }
            catch (IOException ex) {
                Debug.error((Throwable)ex);
            }
        }
        aggStats.normalize(totalLength);
        Block result = new Block(startPos, -1L, stopPos - startPos);
        result.setStatistics(aggStats);
        return result;
    }
}

