/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.memory.undoredo.FileBlockList;
import ch.tachyon.sonics.data.memory.undoredo.IUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.sonics.data.memory.undoredo.UndoRedoFloatFile;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.sonics.data.stats.IExtremum;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import org.corebounce.common.utils.IProgressMonitor;

public class BlockBufferedUndoRedoFloatFile
implements IUndoRedoFloatFile {
    private static final int DEFAULT_CACHE_SIZE = CacheSizes.getSampleCacheSize();
    private final IUndoRedoFloatFile target;
    private final FileBlockList blocks;
    private final int blockSize;
    private final int cacheSize;
    private final Cache readCache;
    private final Cache writeCache;
    private final Cache insertCache;
    private final DeleteCache deleteCache;

    public BlockBufferedUndoRedoFloatFile(IUndoRedoFloatFile target, FileBlockList blocks) {
        this.target = target;
        this.blocks = blocks;
        this.blockSize = blocks.getMaxBlockSize();
        int maxNbBlocks = Math.max(2, DEFAULT_CACHE_SIZE / this.blockSize);
        this.cacheSize = this.blockSize * maxNbBlocks;
        this.readCache = new Cache(this.cacheSize);
        this.writeCache = new Cache(this.cacheSize);
        this.insertCache = new Cache(this.cacheSize);
        this.deleteCache = new DeleteCache();
    }

    public BlockBufferedUndoRedoFloatFile(UndoRedoFloatFile target) {
        this(target, target.getBlockList());
    }

    private void flushReadCache() {
        this.readCache.valid = false;
    }

    private void flushWriteCache() throws IOException {
        if (this.writeCache.valid) {
            this.target.write(this.writeCache.pos, this.writeCache.data, 0, this.writeCache.amount);
        }
        this.writeCache.valid = false;
    }

    private void flushDeleteInsertCache(long beforePos) throws IOException {
        if (this.deleteCache.amount > 0 && this.deleteCache.pos < beforePos || this.insertCache.valid && this.insertCache.pos < beforePos) {
            this.flushDeleteInsertCache();
        }
    }

    private void flushDeleteInsertCache() throws IOException {
        this.flushDeleteCache0();
        this.flushInsertCache0();
    }

    private void flushInsertCache0() throws IOException {
        if (this.insertCache.valid) {
            this.target.insert(this.insertCache.pos, this.insertCache.data, 0, this.insertCache.amount);
            if (this.readCache.valid) {
                if (this.readCache.pos >= this.insertCache.pos) {
                    this.readCache.pos += (long)this.insertCache.amount;
                } else if (this.readCache.pos + (long)this.readCache.amount > this.insertCache.pos) {
                    int cropLeft = (int)(this.insertCache.pos - this.readCache.pos);
                    this.readCache.pos += (long)cropLeft;
                    this.readCache.amount -= cropLeft;
                    if (this.readCache.amount > 0) {
                        System.arraycopy(this.readCache.data, cropLeft, this.readCache.data, 0, this.readCache.amount);
                        this.readCache.pos += (long)this.insertCache.amount;
                    } else {
                        this.readCache.valid = false;
                    }
                }
            }
            this.insertCache.valid = false;
            this.insertCache.amount = 0;
        }
    }

    private void flushDeleteCache0() throws IOException {
        if (this.deleteCache.amount > 0) {
            this.target.delete(this.deleteCache.pos, this.deleteCache.amount);
            if (this.readCache.valid) {
                if (this.readCache.pos >= this.deleteCache.pos + (long)this.deleteCache.amount) {
                    this.readCache.pos -= (long)this.deleteCache.amount;
                } else if (this.readCache.pos + (long)this.readCache.amount > this.deleteCache.pos) {
                    int cropLeft = (int)(this.deleteCache.pos + (long)this.deleteCache.amount - this.readCache.pos);
                    this.readCache.pos = this.deleteCache.pos;
                    this.readCache.amount -= cropLeft;
                    if (this.readCache.amount > 0) {
                        System.arraycopy(this.readCache.data, cropLeft, this.readCache.data, 0, this.readCache.amount);
                    } else {
                        this.readCache.valid = false;
                    }
                }
            }
            this.deleteCache.amount = 0;
        }
    }

    private void flushAllWriteCaches() throws IOException {
        this.flushDeleteInsertCache();
        this.flushWriteCache();
    }

    private void flushAllCaches() throws IOException {
        this.flushAllWriteCaches();
        this.flushReadCache();
    }

    private void cleanupAllCaches() {
        this.insertCache.cleanup();
        this.writeCache.cleanup();
        this.readCache.cleanup();
    }

    public synchronized int read(long pos, float[] where, int offset, int length) throws IOException {
        long targetPos = pos;
        if (this.deleteCache.amount > 0) {
            if (this.deleteCache.pos <= targetPos) {
                targetPos += (long)this.deleteCache.amount;
            } else if (targetPos + (long)length > this.deleteCache.pos) {
                throw new IllegalArgumentException("read-after-delete detected");
            }
        }
        if (this.insertCache.valid && this.insertCache.pos <= targetPos && (targetPos -= (long)this.insertCache.amount) < this.insertCache.pos) {
            throw new IllegalArgumentException("read-after-insert detected");
        }
        if (length > this.cacheSize / 2) {
            return this.target.read(targetPos, where, offset, length);
        }
        int remaining = length;
        if (targetPos + (long)length > this.target.getLength()) {
            remaining = (int)(this.target.getLength() - targetPos);
        }
        int result = 0;
        while (remaining > 0) {
            int amount;
            if (this.readCache.valid && targetPos >= this.readCache.pos && targetPos < this.readCache.pos + (long)this.readCache.amount) {
                amount = Math.min(remaining, (int)(this.readCache.pos + (long)this.readCache.amount - targetPos));
                System.arraycopy(this.readCache.data, (int)(targetPos - this.readCache.pos), where, offset, amount);
            } else {
                Block block;
                int toBlockEnd;
                this.readCache.init(this.cacheSize);
                this.readCache.pos = targetPos;
                this.readCache.amount = 0;
                int blockIndex = this.blocks.indexOfBlock(targetPos);
                Block next = this.blocks.getBlock(blockIndex);
                int blockOffset = (int)(targetPos - next.getSrcPos());
                int readable = 0;
                while (readable + (toBlockEnd = (int)((block = next).getLength() - (long)blockOffset)) <= this.cacheSize) {
                    readable += toBlockEnd;
                    next = this.blocks.getBlock(++blockIndex);
                    blockOffset = 0;
                    if (next != null && block.getDstPos() + block.getLength() == next.getDstPos()) continue;
                }
                this.readCache.amount = this.target.read(targetPos, this.readCache.data, 0, readable);
                assert (targetPos >= this.readCache.pos && targetPos < this.readCache.pos + (long)this.readCache.amount);
                amount = Math.min(remaining, (int)(this.readCache.pos + (long)this.readCache.amount - targetPos));
                System.arraycopy(this.readCache.data, (int)(targetPos - this.readCache.pos), where, offset, amount);
            }
            result += amount;
            remaining -= amount;
            pos += (long)amount;
            targetPos += (long)amount;
            offset += amount;
        }
        return result;
    }

    public synchronized int delete(long pos, int count) throws IOException {
        long unadjustedPos = pos;
        this.flushWriteCache();
        if (this.insertCache.valid) {
            if (this.insertCache.pos < pos) {
                pos -= (long)this.insertCache.amount;
            }
            if (this.insertCache.pos < pos) {
                this.flushDeleteInsertCache();
                pos = unadjustedPos;
            }
        }
        count = (int)Math.min((long)count, this.target.getLength() - pos);
        if (this.deleteCache.amount > 0 && pos != this.deleteCache.pos) {
            this.flushDeleteInsertCache();
            pos = unadjustedPos;
        }
        int remaining = count;
        while (remaining > 0) {
            this.deleteCache.pos = pos;
            int amount = remaining;
            long aheadPos = pos + (long)this.deleteCache.amount;
            Block block = this.blocks.blockFor(aheadPos);
            int toBlockEnd = (int)(block.getLength() - (aheadPos - block.getSrcPos()));
            amount = Math.min(amount, toBlockEnd);
            assert (amount > 0);
            boolean endsAtBlockBoundary = amount == toBlockEnd;
            this.deleteCache.amount += amount;
            if (endsAtBlockBoundary && this.deleteCache.amount >= this.cacheSize) {
                this.flushDeleteInsertCache();
                pos = unadjustedPos;
            }
            remaining -= amount;
        }
        return count;
    }

    public synchronized void insert(long pos, float[] data, int offset, int length) throws IOException {
        this.flushWriteCache();
        if (this.insertCache.valid && this.insertCache.pos + (long)this.insertCache.amount != pos) {
            this.flushDeleteInsertCache();
        }
        int remaining = length;
        while (remaining > 0) {
            if (!this.insertCache.valid) {
                this.insertCache.init(this.cacheSize);
                this.insertCache.pos = pos;
                this.insertCache.amount = 0;
            }
            int amount = Math.min(remaining, this.cacheSize - this.insertCache.amount);
            System.arraycopy(data, offset, this.insertCache.data, this.insertCache.amount, amount);
            pos += (long)amount;
            offset += amount;
            remaining -= amount;
            this.insertCache.amount += amount;
            if (this.insertCache.amount < this.cacheSize) continue;
            this.flushDeleteInsertCache();
        }
    }

    public synchronized void write(long pos, float[] data, int offset, int length) throws IOException {
        this.flushDeleteInsertCache(pos + (long)length);
        int remaining = length;
        while (remaining > 0) {
            if (this.writeCache.valid && (pos < this.writeCache.pos || pos > this.writeCache.pos + (long)this.writeCache.amount || this.cacheSize - this.writeCache.amount < this.blockSize)) {
                this.flushWriteCache();
            }
            if (!this.writeCache.valid) {
                this.writeCache.init(this.cacheSize);
                this.writeCache.pos = pos;
                this.writeCache.amount = 0;
            }
            int amount = Math.min(remaining, this.cacheSize - this.writeCache.amount);
            Block block = null;
            if (pos < this.target.getLength()) {
                block = this.blocks.blockFor(pos);
                amount = Math.min(amount, (int)(block.getLength() - (pos - block.getSrcPos())));
            }
            assert (amount > 0);
            System.arraycopy(data, offset, this.writeCache.data, this.writeCache.amount, amount);
            pos += (long)amount;
            offset += amount;
            remaining -= amount;
            this.writeCache.amount += amount;
            if (this.writeCache.amount < this.cacheSize) continue;
            this.flushWriteCache();
        }
    }

    public synchronized long getLength() {
        long result = this.target.getLength();
        if (this.deleteCache.amount > 0) {
            result -= (long)this.deleteCache.amount;
        }
        if (this.insertCache.valid) {
            result += (long)this.insertCache.amount;
        }
        if (this.writeCache.valid) {
            result = Math.max(result, this.writeCache.pos + (long)this.writeCache.amount);
        }
        return result;
    }

    public synchronized void flush() throws IOException {
        this.flushAllCaches();
        this.cleanupAllCaches();
        this.target.flush();
    }

    public synchronized void dispose() {
        try {
            this.flushAllWriteCaches();
            this.cleanupAllCaches();
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
        this.target.dispose();
    }

    public synchronized void commit() throws IOException {
        this.flushAllCaches();
        this.target.commit();
    }

    public synchronized void rollback(IProgressMonitor progress, LongRange range) throws IOException {
        this.flushAllCaches();
        this.target.rollback(progress, range);
    }

    public synchronized boolean canUndo() throws IOException {
        this.flushAllWriteCaches();
        return this.target.canUndo();
    }

    public synchronized boolean canRedo() throws IOException {
        this.flushAllWriteCaches();
        return this.target.canRedo();
    }

    public synchronized void undo(IProgressMonitor progress, LongRange range) throws IOException {
        this.flushAllCaches();
        this.target.undo(progress, range);
    }

    public synchronized void redo(IProgressMonitor progress, LongRange range) throws IOException {
        this.flushAllCaches();
        this.target.redo(progress, range);
    }

    public synchronized void savePoint() throws IOException {
        this.flushAllWriteCaches();
        this.target.savePoint();
    }

    public synchronized void baseUndoRedoPoint() throws IOException {
        this.flushAllWriteCaches();
        this.target.baseUndoRedoPoint();
    }

    public synchronized boolean isModified() throws IOException {
        this.flushAllWriteCaches();
        return this.target.isModified();
    }

    public synchronized AudioStatistics getStatistics(IUndoRedoFloatFile urFile, long pos, long length) throws IOException {
        this.flushAllWriteCaches();
        return this.target.getStatistics(urFile, pos, length);
    }

    public synchronized long getExtremumSample(long startPos, long stopPos, IUndoRedoFloatFile urFile, IExtremum extremum) throws IOException {
        this.flushAllWriteCaches();
        return this.target.getExtremumSample(startPos, stopPos, urFile, extremum);
    }

    public String toString() {
        try {
            this.flushDeleteInsertCache();
            this.flushWriteCache();
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
        return this.target.toString();
    }

    static class Cache {
        public float[] data;
        public long pos;
        public int amount;
        public boolean valid = false;

        public Cache(int size) {
            this.data = new float[size];
        }

        public void init(int size) {
            if (this.data == null || this.data.length != size) {
                this.data = new float[size];
            }
            this.amount = 0;
            this.valid = true;
        }

        public void cleanup() {
            this.data = null;
        }

        public String toString() {
            return "Cache " + this.pos + ":" + this.amount;
        }
    }

    static class DeleteCache {
        public long pos;
        public int amount;

        DeleteCache() {
        }

        public String toString() {
            return "Cache " + this.pos + ":" + this.amount;
        }
    }
}

