/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.raw.DiskSkipListContext;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.memory.undoredo.BlockAggregator;
import ch.tachyon.sonics.data.memory.undoredo.IUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.Operation;
import ch.tachyon.sonics.data.memory.undoredo.OperationType;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.sonics.data.stats.IExtremum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.corebounce.common.struct.skiplist.ISkipNode;
import org.corebounce.common.struct.skiplist.SkipList;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBlockList
implements IDisposable {
    private final int maxBlockSize;
    private final int minSkipListFactor;
    private final int minSizeForBlockStats;
    private final DiskSkipListContext<Block> context;
    private final SkipList<Block> blocks;
    private final BlockAggregator aggregator;
    private volatile long size = 0L;
    private long pendingReadPos = -1L;
    private int pendingReadLength = -1;
    private int pendingReadOffset = -1;
    private long lastStatisticsPosition = -1L;
    private int lastStatisticsBlockIndex = -1;
    private long lastAggrPosition = -1L;
    private long lastAggrsLength = -1L;
    private ISkipNode<Block> lastAggrNode = null;

    public FileBlockList(ISimpleFloatFile historyFile, int minSkipListFactor, int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
        this.minSkipListFactor = minSkipListFactor;
        this.minSizeForBlockStats = maxBlockSize;
        Block template = new Block(-1L, -1L, -1L);
        this.context = new DiskSkipListContext<Block>(template, "skipList");
        this.aggregator = new BlockAggregator(historyFile);
        this.blocks = new SkipList<Block>(minSkipListFactor, this.context, this.aggregator);
    }

    public long getLength() {
        return this.size;
    }

    public synchronized int getNbBlocks() {
        return this.blocks.size();
    }

    int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public synchronized int read(ISimpleFloatFile historyFile, long pos, float[] target, int offset, int length) throws IOException {
        int result = 0;
        int blockIndex = this.indexOfBlock(pos);
        this.startRead();
        while (length > 0) {
            if (blockIndex < 0 || blockIndex >= this.blocks.size()) break;
            Block block = this.blocks.get(blockIndex);
            int blockOffset = (int)(pos - block.getSrcPos());
            int amount = (int)Math.min((long)length, block.getLength() - (long)blockOffset);
            amount = this.readPart(historyFile, block.getDstPos() + (long)blockOffset, target, offset, amount);
            if (amount == 0) break;
            pos += (long)amount;
            offset += amount;
            length -= amount;
            result += amount;
            ++blockIndex;
        }
        this.endRead(historyFile, target);
        return result;
    }

    private void startRead() {
        this.pendingReadPos = -1L;
    }

    private int readPart(ISimpleFloatFile historyFile, long pos, float[] target, int offset, int length) throws IOException {
        if (this.pendingReadPos >= 0L && this.pendingReadPos + (long)this.pendingReadLength == pos) {
            this.pendingReadLength += length;
        } else {
            this.endRead(historyFile, target);
            this.pendingReadPos = pos;
            this.pendingReadOffset = offset;
            this.pendingReadLength = length;
        }
        return length;
    }

    private void endRead(ISimpleFloatFile historyFile, float[] target) throws IOException {
        if (this.pendingReadPos >= 0L) {
            historyFile.read(this.pendingReadPos, target, this.pendingReadOffset, this.pendingReadLength);
        }
        this.pendingReadPos = -1L;
    }

    /*
     * Unable to fully structure code
     */
    int indexOfBlock(long pos) {
        block5: {
            if (pos == 0L) {
                return 0;
            }
            if (pos == this.size) {
                return this.blocks.size();
            }
            if (pos < (long)(this.maxBlockSize * this.minSkipListFactor * 4)) {
                result = 0;
                block = this.blocks.get(result);
                while (!block.crosses(pos)) {
                    block = this.blocks.get(++result);
                }
                return result;
            }
            if (pos <= this.size - (long)(this.maxBlockSize * this.minSkipListFactor * 4)) break block5;
            result = this.blocks.size() - 1;
            block = this.blocks.get(result);
            if (FileBlockList.$assertionsDisabled || block.getSrcPos() + block.getLength() >= pos) ** GOTO lbl18
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                block = this.blocks.get(--result);
lbl18:
                // 2 sources

                ** while (!block.crosses((long)pos))
            }
lbl19:
            // 1 sources

            return result;
        }
        index = this.blocks.positionToIndex(pos);
        return index;
    }

    Block blockFor(long position) {
        int index = this.indexOfBlock(position);
        if (index >= 0 && index < this.blocks.size()) {
            return this.blocks.get(index);
        }
        return null;
    }

    Block getBlock(int index) {
        if (index < 0 || index >= this.blocks.size()) {
            return null;
        }
        return this.blocks.get(index);
    }

    private void addOrMergeBlock(List<Block> blockList, Block newBlock) {
        if (blockList.isEmpty()) {
            blockList.add(newBlock);
        } else {
            Block prevBlock = blockList.get(blockList.size() - 1);
            if (this.isContiguous(prevBlock, newBlock) && prevBlock.getLength() + newBlock.getLength() <= (long)this.maxBlockSize) {
                prevBlock.append(newBlock);
            } else {
                blockList.add(newBlock);
            }
        }
    }

    private boolean isContiguous(Block b1, Block b2) {
        return b1.getSrcPos() + b1.getLength() == b2.getSrcPos() && b1.getDstPos() + b1.getLength() == b2.getDstPos();
    }

    public synchronized void write(long pos, int length, List<Block> newBlocks, @Out List<Block> oldBlocks) {
        if (pos + (long)length > this.size) {
            throw new IllegalArgumentException("Write that would extend the file size are not supported. Use insert() instead");
        }
        long lastPos = pos + (long)length - 1L;
        boolean added = false;
        int startIndex = this.indexOfBlock(pos);
        long oldSrcPos = -1L;
        ListIterator<Block> iter = this.blocks.listIterator(startIndex);
        while (iter.hasNext()) {
            Block deleted;
            Block b = (Block)iter.next();
            if (oldSrcPos < 0L) {
                oldSrcPos = b.getSrcPos();
            } else {
                b.setSrcPos(oldSrcPos);
            }
            oldSrcPos += b.getLength();
            if (b.contains(pos, length)) {
                iter.remove();
                Block before = b.clone();
                Block after = b.clone();
                before.shrinkRight(pos);
                if (before.getLength() > 0L) {
                    iter.add(before);
                }
                for (Block newBlock : newBlocks) {
                    iter.add(newBlock.copy());
                }
                added = true;
                Block oldData = b;
                oldData.shrinkLeft(pos);
                oldData.shrinkRight(pos + (long)length);
                assert (oldData.getLength() > 0L);
                this.addOrMergeBlock(oldBlocks, oldData);
                after.shrinkLeft(pos + (long)length);
                if (after.getLength() > 0L) {
                    iter.add(after);
                    break;
                }
                if (!b.endsAt(this.size)) break;
                this.size = pos;
                break;
            }
            if (b.crosses(pos)) {
                deleted = b.copy();
                deleted.shrinkLeft(pos);
                if (deleted.getLength() > 0L) {
                    this.addOrMergeBlock(oldBlocks, deleted);
                }
                b.shrinkRight(pos);
                iter.set(b);
                if (b.getLength() <= 0L) {
                    iter.remove();
                }
                for (Block newBlock : newBlocks) {
                    iter.add(newBlock.copy());
                }
                added = true;
                continue;
            }
            if (b.within(pos, length)) {
                iter.remove();
                this.addOrMergeBlock(oldBlocks, b);
                continue;
            }
            if (b.crosses(lastPos)) {
                deleted = b.copy();
                deleted.shrinkRight(pos + (long)length);
                if (deleted.getLength() > 0L) {
                    this.addOrMergeBlock(oldBlocks, deleted);
                }
                b.shrinkLeft(pos + (long)length);
                assert (b.getLength() > 0L);
                iter.set(b);
                break;
            }
            if (b.getSrcPos() > lastPos) break;
        }
        if (!added) {
            for (Block newBlock : newBlocks) {
                this.blocks.add(newBlock.copy());
            }
        }
        length = 0;
        for (Block block : newBlocks) {
            length = (int)((long)length + block.getLength());
        }
        this.size = Math.max(this.size, pos + (long)length);
        int stopIndex = Math.min(this.blocks.size(), startIndex + newBlocks.size() + 1);
        startIndex = Math.max(0, startIndex - 1);
        this.assertCoherency(startIndex, stopIndex, false);
        stopIndex += this.defragment(startIndex, stopIndex);
        this.assertCoherency(startIndex, stopIndex, true);
    }

    public synchronized void insert(long pos, int length, List<Block> newBlocks) {
        if (pos > this.getLength()) {
            throw new IllegalArgumentException("Attempt to insert past EOF. Length:" + this.getLength() + ", insert pos:" + pos);
        }
        boolean added = false;
        int startIndex = this.indexOfBlock(pos);
        long oldSrcPos = -1L;
        ListIterator<Block> iter = this.blocks.listIterator(startIndex);
        while (iter.hasNext()) {
            Block b = (Block)iter.next();
            if (oldSrcPos < 0L) {
                oldSrcPos = b.getSrcPos();
            } else {
                b.setSrcPos(oldSrcPos);
            }
            oldSrcPos += b.getLength();
            if (b.crosses(pos)) {
                iter.remove();
                Block before = b;
                Block after = b.copy();
                before.shrinkRight(pos);
                if (before.getLength() > 0L) {
                    iter.add(before);
                }
                for (Block newBlock : newBlocks) {
                    iter.add(newBlock.copy());
                }
                added = true;
                after.shrinkLeft(pos);
                assert (after.getLength() > 0L);
                after.shift(length);
                iter.add(after);
                continue;
            }
            if (!added) continue;
            assert (added);
            break;
        }
        if (!added) {
            for (Block newBlock : newBlocks) {
                this.blocks.add(newBlock.copy());
            }
        }
        this.size += (long)length;
        int stopIndex = Math.min(this.blocks.size(), startIndex + newBlocks.size() + 1);
        startIndex = Math.max(0, startIndex - 1);
        this.assertCoherency(startIndex, stopIndex, false);
        stopIndex += this.defragment(startIndex, stopIndex);
        this.assertCoherency(startIndex, stopIndex, true);
    }

    public synchronized void delete(long pos, int length, @Out List<Block> oldBlocks) {
        if (pos + (long)length > this.getLength()) {
            throw new IllegalArgumentException("Attempt to delete past EOF. Length:" + this.getLength() + ", delete pos:" + pos + ", delete length:" + length);
        }
        long lastPos = pos + (long)length - 1L;
        boolean found = false;
        int startIndex = this.indexOfBlock(pos);
        long oldSrcPos = -1L;
        ListIterator<Block> iter = this.blocks.listIterator(startIndex);
        while (iter.hasNext()) {
            Block deleted;
            Block b = (Block)iter.next();
            if (oldSrcPos < 0L) {
                oldSrcPos = b.getSrcPos();
            } else {
                b.setSrcPos(oldSrcPos);
            }
            oldSrcPos += b.getLength();
            if (b.contains(pos, length)) {
                iter.remove();
                Block before = b.copy();
                Block after = b.copy();
                before.shrinkRight(pos);
                if (before.getLength() > 0L) {
                    iter.add(before);
                }
                Block oldData = b;
                oldData.shrinkLeft(pos);
                oldData.shrinkRight(pos + (long)length);
                assert (oldData.getLength() > 0L);
                this.addOrMergeBlock(oldBlocks, oldData);
                found = true;
                after.shrinkLeft(pos + (long)length);
                after.shift(-length);
                if (after.getLength() <= 0L) continue;
                iter.add(after);
                continue;
            }
            if (b.crosses(pos)) {
                deleted = b.copy();
                deleted.shrinkLeft(pos);
                if (deleted.getLength() > 0L) {
                    this.addOrMergeBlock(oldBlocks, deleted);
                }
                b.shrinkRight(pos);
                iter.set(b);
                if (b.getLength() > 0L) continue;
                iter.remove();
                continue;
            }
            if (b.within(pos, length)) {
                if (b.getSrcPos() + b.getLength() == pos + (long)length) {
                    found = true;
                }
                iter.remove();
                this.addOrMergeBlock(oldBlocks, b);
                continue;
            }
            if (b.crosses(lastPos)) {
                deleted = b.copy();
                deleted.shrinkRight(pos + (long)length);
                if (deleted.getLength() > 0L) {
                    this.addOrMergeBlock(oldBlocks, deleted);
                }
                b.shrinkLeft(pos + (long)length);
                assert (b.getLength() > 0L);
                b.shift(-length);
                iter.set(b);
                found = true;
                continue;
            }
            if (found) break;
        }
        this.size -= (long)length;
        int stopIndex = Math.min(this.blocks.size(), startIndex + 1);
        startIndex = Math.max(0, startIndex - 1);
        this.assertCoherency(startIndex, stopIndex, false);
        stopIndex += this.defragment(startIndex, stopIndex);
        this.assertCoherency(startIndex, stopIndex, true);
    }

    void assertCoherency() {
        this.assertCoherency(0, this.blocks.size(), true);
    }

    private void assertCoherency(int startPos, int stopPos, boolean checkMaxBlockSize) {
        assert (this.isCoherent(startPos, stopPos, checkMaxBlockSize));
    }

    private boolean isCoherent(int startPos, int stopPos, boolean checkMaxBlockSize) {
        long srcPos = startPos == 0 ? 0 : -1;
        for (Block block : this.blocks.subList(startPos, stopPos)) {
            if (checkMaxBlockSize) assert (block.getLength() <= (long)this.maxBlockSize);
            if (srcPos < 0L) {
                srcPos = block.getSrcPos();
            } else assert (block.getSrcPos() == srcPos);
            assert (block.getLength() > 0L);
            srcPos += block.getLength();
        }
        if (startPos == 0 && stopPos == this.blocks.size()) {
            return srcPos == this.size;
        }
        return true;
    }

    public synchronized int assertStatistics(ISimpleFloatFile file) throws IOException {
        int result = 0;
        for (Block block : this.blocks) {
            if (!block.hasStatistics()) continue;
            AudioStatistics stats = block.getStatistics(file);
            AudioStatistics check = new AudioStatistics();
            check.compute(file, block);
            assert (this.roughlyEqual(stats, check));
            ++result;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public void assertAggregates(ISimpleFloatFile file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean roughlyEqual(AudioStatistics stat1, AudioStatistics stat2) {
        float epsilon = 1.0E-5f;
        return stat1.getMin() == stat2.getMin() && stat1.getMax() == stat2.getMax() && Math.abs(stat1.getAvg() - stat2.getAvg()) < 1.0E-5f && Math.abs(stat1.getSqAvg() - stat2.getSqAvg()) < 1.0E-5f;
    }

    private int defragment(int startIndex, int stopIndex) {
        int result = 0;
        Block previous = null;
        ListIterator<Block> iter = this.blocks.subList(startIndex, stopIndex).listIterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            assert (block.getLength() <= (long)this.maxBlockSize);
            if (previous != null && previous.getDstPos() + previous.getLength() == block.getDstPos() && previous.getLength() + block.getLength() <= (long)this.maxBlockSize) {
                iter.remove();
                Block prev = (Block)iter.previous();
                assert (prev.equals(previous));
                previous.append(block);
                iter.set(previous);
                iter.next();
                --result;
                block = previous;
            }
            previous = block;
        }
        return result;
    }

    public synchronized List<Block> splitAndPrepare(Block block, float[] data, int offset, int length) {
        block.computeCommonStatistics(data, offset);
        block = block.copy();
        ArrayList<Block> result = new ArrayList<Block>();
        while (block.getLength() > (long)this.maxBlockSize) {
            Block head = block;
            Block tail = block.clone();
            long splitPos = block.getSrcPos() + (long)this.maxBlockSize;
            head.shrinkRight(splitPos);
            tail.shrinkLeft(splitPos);
            head.computeCommonStatistics(data, offset);
            result.add(head);
            offset = (int)((long)offset + head.getLength());
            block = tail;
        }
        block.computeCommonStatistics(data, offset);
        result.add(block);
        return result;
    }

    public synchronized void undo(Operation operation) {
        assert (operation.isCoherent());
        if (operation.getType().equals((Object)OperationType.WRITE)) {
            ArrayList<Block> oldBlocks = new ArrayList<Block>();
            this.write(operation.getPos(), operation.getLength(), operation.getOldData(), oldBlocks);
        } else if (operation.getType().equals((Object)OperationType.INSERT)) {
            ArrayList<Block> oldBlocks = new ArrayList<Block>();
            this.delete(operation.getPos(), operation.getLength(), oldBlocks);
        } else if (operation.getType().equals((Object)OperationType.DELETE)) {
            this.insert(operation.getPos(), operation.getLength(), operation.getOldData());
        }
    }

    public synchronized void redo(Operation operation) {
        assert (operation.isCoherent());
        if (operation.getType().equals((Object)OperationType.WRITE)) {
            ArrayList<Block> oldBlocks = new ArrayList<Block>();
            this.write(operation.getPos(), operation.getLength(), operation.getNewData(), oldBlocks);
        } else if (operation.getType().equals((Object)OperationType.INSERT)) {
            this.insert(operation.getPos(), operation.getLength(), operation.getNewData());
        } else if (operation.getType().equals((Object)OperationType.DELETE)) {
            ArrayList<Block> oldBlocks = new ArrayList<Block>();
            this.delete(operation.getPos(), operation.getLength(), oldBlocks);
        }
    }

    public long getExtremumSample(long startPos, long stopPos, IUndoRedoFloatFile urFile, ISimpleFloatFile historyFile, IExtremum extremum) throws IOException {
        if (startPos < 0L || stopPos > this.getLength() || startPos >= stopPos) {
            throw new IllegalArgumentException();
        }
        long coverage = stopPos - startPos;
        ISkipNode<Block> extremumNode = this.blocks.positionToNode(startPos, coverage / 5L + 1L);
        while (true) {
            extremum.reset(historyFile);
            ISkipNode<Block> node = extremumNode;
            while (node.getSrcPos() < startPos && node.getSrcPos() + node.getCoverage() < stopPos && node.getNext() != null) {
                node = node.getNext();
            }
            do {
                this.blocks.ensureAggregate(node);
                boolean update = extremum.update(node.getItem());
                if (!update) continue;
                extremumNode = node;
            } while ((node = node.getNext()) != null && node.getSrcPos() + node.getCoverage() < stopPos);
            if (extremumNode.getLevel() < 0) break;
            startPos = Math.max(startPos, extremumNode.getSrcPos());
            stopPos = Math.min(stopPos, extremumNode.getSrcPos() + extremumNode.getCoverage());
            extremumNode = extremumNode.getDown();
        }
        Block block = extremumNode.getItem();
        float[] buffer = new float[(int)block.getLength()];
        urFile.read(block.getSrcPos(), buffer, 0, buffer.length);
        int startOffset = Math.max(0, (int)(startPos - block.getSrcPos()));
        int stopOffset = Math.min(buffer.length, (int)((long)buffer.length + stopPos - block.getSrcPos() - block.getLength()));
        int maxOffset = startOffset;
        extremum.reset(historyFile);
        int i = startOffset;
        while (i < stopOffset) {
            boolean update = extremum.update(buffer[i]);
            if (update) {
                maxOffset = i;
            }
            ++i;
        }
        return block.getSrcPos() + (long)maxOffset;
    }

    public synchronized AudioStatistics getStatistics(IUndoRedoFloatFile urFile, ISimpleFloatFile historyFile, long pos, long length) throws IOException {
        if (pos + length > this.size) {
            throw new IllegalArgumentException("Cannot get statistics past end of file");
        }
        if (length >= (long)this.minSizeForBlockStats) {
            return this.getStatisticsByBlock(historyFile, pos, length);
        }
        return this.getStatisticsBySamples(urFile, historyFile, pos, length);
    }

    private AudioStatistics getStatisticsBySamples(IUndoRedoFloatFile urFile, ISimpleFloatFile historyFile, long pos, long length) throws IOException {
        AudioStatistics result = new AudioStatistics();
        AudioStatistics rangeStats = new AudioStatistics();
        int blockIndex = pos == this.lastStatisticsPosition ? this.lastStatisticsBlockIndex : this.indexOfBlock(pos);
        long remaining = length;
        while (remaining > 0L) {
            if (blockIndex < 0 || blockIndex >= this.blocks.size()) break;
            Block block = this.blocks.get(blockIndex);
            int blockOffset = (int)(pos - block.getSrcPos());
            long blockAvail = block.getLength() - (long)blockOffset;
            int amount = (int)Math.min(remaining, blockAvail);
            if (blockOffset == 0 && (long)amount == block.getLength()) {
                AudioStatistics blockStats = block.getStatistics(historyFile);
                result.accumulate(blockStats, amount);
            } else {
                rangeStats.compute(urFile, block.getSrcPos() + (long)blockOffset, amount);
                result.accumulate(rangeStats, amount);
            }
            pos += (long)amount;
            remaining -= (long)amount;
            if ((long)amount < blockAvail) continue;
            ++blockIndex;
        }
        result.normalize(length);
        this.lastStatisticsPosition = pos;
        this.lastStatisticsBlockIndex = blockIndex;
        return result;
    }

    private AudioStatistics getStatisticsByBlock(ISimpleFloatFile historyFile, long pos, long length) throws IOException {
        Block block;
        AudioStatistics result = new AudioStatistics();
        ISkipNode<Block> node = pos == this.lastAggrPosition && (double)Math.abs(length - this.lastAggrsLength) / (double)length < 0.01 ? this.lastAggrNode : this.blocks.positionToNode(pos, length);
        ArrayList<Block> rangeBlocks = new ArrayList<Block>();
        ArrayList<Integer> amounts = new ArrayList<Integer>();
        BitSet fullBlockIndexes = new BitSet();
        long remaining = length;
        int index = 0;
        while (remaining > 0L && node != null) {
            this.blocks.ensureAggregate(node);
            block = node.getAggregate();
            int blockOffset = (int)(pos - block.getSrcPos());
            long blockAvail = block.getLength() - (long)blockOffset;
            int amount = (int)Math.min(remaining, blockAvail);
            if ((long)amount > block.getLength() / 2L) {
                fullBlockIndexes.set(index);
            }
            pos += (long)amount;
            remaining -= (long)amount;
            rangeBlocks.add(block);
            amounts.add(amount);
            ++index;
            if ((long)amount < blockAvail) continue;
            node = node.getNext();
        }
        assert (index == rangeBlocks.size());
        if (fullBlockIndexes.isEmpty()) {
            assert (rangeBlocks.size() <= 2);
            fullBlockIndexes.set(0, index);
        }
        remaining = length;
        index = 0;
        while (index < rangeBlocks.size()) {
            block = (Block)rangeBlocks.get(index);
            int amount = (Integer)amounts.get(index);
            if (fullBlockIndexes.get(index)) {
                result.accumulate(block.getStatistics(historyFile), amount);
            } else {
                result.accumulateAvg(block.getStatistics(historyFile), amount);
            }
            ++index;
        }
        result.normalize(length);
        assert (!result.isUndefined());
        this.lastAggrPosition = pos;
        this.lastAggrsLength = length;
        this.lastAggrNode = node;
        return result;
    }

    public synchronized void flush() {
        this.context.flush();
    }

    @Override
    public synchronized void dispose() {
        if (this.blocks instanceof IDisposable) {
            this.blocks.dispose();
        } else {
            this.blocks.clear();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("FileBlockList{size=");
        result.append(this.size);
        result.append(",blocks=");
        result.append(this.blocks.size());
        result.append(",minSkipListFactor=");
        result.append(this.minSkipListFactor);
        result.append(",maxBlockSize=");
        result.append(this.maxBlockSize);
        result.append("}");
        return result.toString();
    }
}

