/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import java.io.Serializable;

public class LongRange
implements Serializable {
    private long start = Long.MAX_VALUE;
    private long stop = Long.MIN_VALUE;

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getStop() {
        return this.stop;
    }

    public void setStop(long stop) {
        this.stop = stop;
    }

    public void extendStart(long newStart) {
        this.start = Math.min(this.start, newStart);
    }

    public void extendStop(long newStop) {
        this.stop = Math.max(this.stop, newStop);
    }

    public void extend(long newStart, long newStop) {
        this.extendStart(newStart);
        this.extendStop(newStop);
    }

    public boolean isEmpty() {
        return this.start >= this.stop;
    }

    public void merge(LongRange other) {
        this.extendStart(other.start);
        this.extendStop(other.stop);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.stop ^ this.stop >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongRange other = (LongRange)obj;
        if (this.start != other.start) {
            return false;
        }
        return this.stop == other.stop;
    }

    public String toString() {
        return "[" + this.start + "-" + this.stop + "]";
    }
}

