/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.sonics.data.memory.raw.ISharedContext;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.memory.undoredo.OperationType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
implements IBlockSerializable<Operation>,
ISharedContext<Operation> {
    private OperationType type;
    private long pos;
    private int length;
    private int oldDataIndex;
    private int oldDataCount;
    private int newDataIndex;
    private int newDataCount;
    private int undoRedoIndex;
    private List<Block> oldData;
    private List<Block> newData;
    private List<Block> blockPool;

    Operation() {
        this.type = OperationType.WRITE;
    }

    public Operation(OperationType type, long pos, int length, List<Block> oldData, List<Block> newData, int undoRedoIndex) {
        this.type = type;
        this.pos = pos;
        this.length = length;
        this.oldData = oldData;
        this.newData = newData;
        this.undoRedoIndex = undoRedoIndex;
        assert (this.isCoherent());
    }

    void beforeAdd(List<Block> blockPool) {
        if (this.oldData != null) {
            this.oldDataIndex = blockPool.size();
            blockPool.addAll(this.oldData);
            this.oldDataCount = this.oldData.size();
        }
        if (this.newData != null) {
            this.newDataIndex = blockPool.size();
            blockPool.addAll(this.newData);
            this.newDataCount = this.newData.size();
        }
        this.blockPool = blockPool;
        this.oldData = null;
        this.newData = null;
    }

    void afterRemove(List<Block> blockPool) {
        int i;
        if (this.newDataCount > 0) {
            i = this.newDataCount - 1;
            while (i >= 0) {
                blockPool.remove(this.newDataIndex + i);
                --i;
            }
        }
        if (this.oldDataCount > 0) {
            i = this.oldDataCount - 1;
            while (i >= 0) {
                blockPool.remove(this.oldDataIndex + i);
                --i;
            }
        }
        this.blockPool = null;
    }

    boolean isCoherent() {
        Block block;
        int i;
        long length = 0L;
        if (this.oldData != null && this.oldData.size() > 0) {
            i = 0;
            while (i < this.oldData.size()) {
                block = this.oldData.get(i);
                length += block.getLength();
                ++i;
            }
            if (length != (long)this.length) {
                return false;
            }
        }
        length = 0L;
        if (this.newData != null && this.newData.size() > 0) {
            i = 0;
            while (i < this.newData.size()) {
                block = this.newData.get(i);
                length += block.getLength();
                ++i;
            }
            if (length != (long)this.length) {
                return false;
            }
        }
        return true;
    }

    public OperationType getType() {
        return this.type;
    }

    public long getPos() {
        return this.pos;
    }

    public int getLength() {
        return this.length;
    }

    public List<Block> getOldData() {
        if (this.oldDataCount == 0) {
            return null;
        }
        return Collections.unmodifiableList(this.blockPool.subList(this.oldDataIndex, this.oldDataIndex + this.oldDataCount));
    }

    public List<Block> getNewData() {
        if (this.newDataCount == 0) {
            return null;
        }
        return Collections.unmodifiableList(this.blockPool.subList(this.newDataIndex, this.newDataIndex + this.newDataCount));
    }

    public int getUndoRedoIndex() {
        return this.undoRedoIndex;
    }

    @Override
    public void serialize(DataOutputStream target) throws IOException {
        target.writeInt(this.type.ordinal());
        target.writeLong(this.pos);
        target.writeInt(this.length);
        target.writeInt(this.oldDataIndex);
        target.writeInt(this.oldDataCount);
        target.writeInt(this.newDataIndex);
        target.writeInt(this.newDataCount);
        target.writeInt(this.undoRedoIndex);
    }

    @Override
    public Operation deserialize(DataInputStream source) throws IOException {
        Operation result = new Operation();
        result.type = OperationType.values()[source.readInt()];
        result.pos = source.readLong();
        result.length = source.readInt();
        result.oldDataIndex = source.readInt();
        result.oldDataCount = source.readInt();
        result.newDataIndex = source.readInt();
        result.newDataCount = source.readInt();
        result.undoRedoIndex = source.readInt();
        return result;
    }

    @Override
    public void setContext(Object context) {
        this.blockPool = (List)context;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.type);
        result.append("@");
        result.append(this.pos);
        result.append(":");
        result.append(this.length);
        return result.toString();
    }
}

