/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.BufferedByteFile;
import ch.tachyon.sonics.data.memory.ISimpleByteFile;
import ch.tachyon.sonics.data.memory.SimpleByteFile;
import ch.tachyon.sonics.data.memory.raw.DiskList;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.memory.undoredo.Operation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationStack
implements IDisposable {
    private List<Block> blocks;
    private List<Operation> operations;

    public OperationStack() {
        try {
            ISimpleByteFile blockFile = new SimpleByteFile("blocks");
            blockFile = new BufferedByteFile(blockFile);
            this.blocks = new DiskList<Block>(blockFile, new Block(0L, 0L, 0L));
            ISimpleByteFile operationFile = new SimpleByteFile("operations");
            operationFile = new BufferedByteFile(operationFile);
            this.operations = new DiskList<Operation>(operationFile, new Operation());
            ((DiskList)this.operations).setContext(this.blocks);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Operation get(int index) {
        return this.operations.get(index);
    }

    public void add(Operation operation) {
        operation.beforeAdd(this.blocks);
        this.operations.add(operation);
    }

    public Operation remove() {
        Operation operation = this.operations.remove(this.operations.size() - 1);
        operation.afterRemove(this.blocks);
        return operation;
    }

    public void clear() {
        this.operations.clear();
        this.blocks.clear();
    }

    public int size() {
        return this.operations.size();
    }

    public List<Block> getBlockList() {
        return Collections.unmodifiableList(this.blocks);
    }

    public void flush() {
        if (this.operations instanceof DiskList) {
            ((DiskList)this.operations).flush();
        }
        if (this.blocks instanceof DiskList) {
            ((DiskList)this.blocks).flush();
        }
    }

    @Override
    public void dispose() {
        if (this.operations instanceof IDisposable) {
            ((IDisposable)((Object)this.operations)).dispose();
        }
        if (this.blocks instanceof IDisposable) {
            ((IDisposable)((Object)this.blocks)).dispose();
        }
    }
}

