/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.memory.undoredo;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.memory.undoredo.FileBlockList;
import ch.tachyon.sonics.data.memory.undoredo.IUndoRedoFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.sonics.data.memory.undoredo.Operation;
import ch.tachyon.sonics.data.memory.undoredo.OperationStack;
import ch.tachyon.sonics.data.memory.undoredo.OperationType;
import ch.tachyon.sonics.data.stats.AudioStatistics;
import ch.tachyon.sonics.data.stats.IExtremum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.utils.IDisposable;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.Out;

public class UndoRedoFloatFile
implements IUndoRedoFloatFile {
    private final ISimpleFloatFile historyFile;
    private final FileBlockList blockList;
    private final OperationStack operations;
    private final List<Integer> transactions = new ArrayList<Integer>();
    private int operationIndex = 0;
    private int saveIndex = 0;
    private int undoRedoIndex = 0;
    private int baseUndoRedoIndex = 0;
    private int curNbOperations = 0;

    public UndoRedoFloatFile(ISimpleFloatFile historyFile) {
        this(historyFile, 8, 2048);
    }

    public UndoRedoFloatFile(ISimpleFloatFile historyFile, int minSkipListFactor, int maxBlockSize) {
        this.historyFile = historyFile;
        this.blockList = new FileBlockList(historyFile, minSkipListFactor, maxBlockSize);
        this.operations = new OperationStack();
    }

    FileBlockList getBlockList() {
        return this.blockList;
    }

    public synchronized int read(long pos, float[] target, int offset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        return this.blockList.read(this.historyFile, pos, target, offset, length);
    }

    private void saveOperation(Operation operation) {
        while (this.operationIndex < this.operations.size()) {
            this.operations.remove();
        }
        this.operations.add(operation);
        ++this.operationIndex;
        ++this.curNbOperations;
    }

    public synchronized void write(long pos, float[] data, int offset, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        long fileLength = this.getLength();
        if (pos + (long)length > fileLength) {
            int writeAmount = (int)(fileLength - pos);
            if (writeAmount > 0) {
                this.write(pos, data, offset, writeAmount);
            }
            assert (writeAmount < length);
            this.insert(fileLength, data, offset + writeAmount, length - writeAmount);
            return;
        }
        long historySize = this.historyFile.getLength();
        Block newBlock = new Block(pos, historySize, length);
        this.historyFile.write(historySize, data, offset, length);
        ArrayList<Block> oldBlocks = new ArrayList<Block>();
        List<Block> newBlocks = this.blockList.splitAndPrepare(newBlock, data, offset, length);
        this.blockList.write(pos, length, newBlocks, oldBlocks);
        Operation operation = new Operation(OperationType.WRITE, pos, length, oldBlocks, newBlocks, this.undoRedoIndex);
        this.saveOperation(operation);
    }

    public synchronized void insert(long pos, float[] data, int offset, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        long historySize = this.historyFile.getLength();
        Block newBlock = new Block(pos, historySize, length);
        this.historyFile.write(historySize, data, offset, length);
        List<Block> newBlocks = this.blockList.splitAndPrepare(newBlock, data, offset, length);
        this.blockList.insert(pos, length, newBlocks);
        Operation operation = new Operation(OperationType.INSERT, pos, length, null, newBlocks, this.undoRedoIndex);
        this.saveOperation(operation);
    }

    public synchronized int delete(long pos, int length) throws IOException {
        if ((length = Math.min(length, (int)(this.getLength() - pos))) <= 0) {
            return 0;
        }
        ArrayList<Block> oldBlocks = new ArrayList<Block>();
        this.blockList.delete(pos, length, oldBlocks);
        Operation operation = new Operation(OperationType.DELETE, pos, length, oldBlocks, null, this.undoRedoIndex);
        this.saveOperation(operation);
        return length;
    }

    public long getLength() {
        return this.blockList.getLength();
    }

    public synchronized void commit() {
        if (this.undoRedoIndex < this.transactions.size()) {
            this.transactions.set(this.undoRedoIndex, this.curNbOperations);
            while (this.transactions.size() > this.undoRedoIndex + 1) {
                this.transactions.remove(this.transactions.size() - 1);
            }
        } else {
            this.transactions.add(this.curNbOperations);
        }
        this.curNbOperations = 0;
        ++this.undoRedoIndex;
        assert (this.transactions.size() == this.undoRedoIndex);
        this.blockList.assertCoherency();
    }

    public synchronized boolean canUndo() {
        Operation prevOperation;
        boolean result;
        boolean bl = result = this.undoRedoIndex > this.baseUndoRedoIndex && this.operationIndex > 0;
        if (this.operationIndex > 0 && (prevOperation = this.operations.get(this.operationIndex - 1)).getUndoRedoIndex() == this.undoRedoIndex) {
            result = false;
        }
        return result;
    }

    public synchronized void undo(IProgressMonitor progress, @Out LongRange range) {
        if (!this.canUndo()) {
            throw new IllegalStateException();
        }
        Operation prevOperation = this.operations.get(this.operationIndex - 1);
        if (prevOperation.getUndoRedoIndex() == this.undoRedoIndex) {
            throw new IllegalStateException("Cannot undo in the middle of a transaction. Use rollback");
        }
        int nbSteps = this.transactions.get(this.undoRedoIndex - 1);
        int curStep = 0;
        --this.undoRedoIndex;
        while (prevOperation.getUndoRedoIndex() == this.undoRedoIndex) {
            this.updateRange(prevOperation, range, true);
            this.blockList.undo(prevOperation);
            --this.operationIndex;
            if (this.operationIndex <= 0) break;
            ++curStep;
            if (progress != null) {
                progress.setNoAbortProgress(curStep, nbSteps);
            }
            prevOperation = this.operations.get(this.operationIndex - 1);
        }
    }

    public synchronized void rollback(IProgressMonitor progress, @Out LongRange range) {
        if (progress != null) {
            progress.reset();
        }
        Operation prevOperation = this.operations.get(this.operationIndex - 1);
        int curStep = 0;
        while (prevOperation.getUndoRedoIndex() == this.undoRedoIndex) {
            this.updateRange(prevOperation, range, true);
            this.blockList.undo(prevOperation);
            --this.operationIndex;
            if (this.operationIndex <= 0) break;
            ++curStep;
            if (progress != null) {
                progress.setNoAbortProgress(curStep, this.curNbOperations);
            }
            prevOperation = this.operations.get(this.operationIndex - 1);
        }
        this.curNbOperations = 0;
    }

    public synchronized boolean canRedo() {
        Operation prevOperation;
        boolean result;
        boolean bl = result = this.undoRedoIndex < this.transactions.size();
        if (this.operationIndex > 0 && (prevOperation = this.operations.get(this.operationIndex - 1)).getUndoRedoIndex() == this.undoRedoIndex) {
            result = false;
        }
        return result;
    }

    public synchronized void redo(IProgressMonitor progress, @Out LongRange range) {
        if (!this.canRedo()) {
            throw new IllegalStateException();
        }
        int nbSteps = this.transactions.get(this.undoRedoIndex);
        Operation operation = this.operations.get(this.operationIndex);
        int curStep = 0;
        while (operation.getUndoRedoIndex() == this.undoRedoIndex) {
            this.updateRange(operation, range, false);
            this.blockList.redo(operation);
            ++this.operationIndex;
            if (this.operationIndex >= this.operations.size()) break;
            ++curStep;
            if (progress != null) {
                progress.setNoAbortProgress(curStep, nbSteps);
            }
            operation = this.operations.get(this.operationIndex);
        }
        ++this.undoRedoIndex;
    }

    private void updateRange(Operation operation, LongRange range, boolean reverse) {
        if (range == null) {
            return;
        }
        OperationType type = operation.getType();
        if (reverse) {
            if (type == OperationType.DELETE) {
                type = OperationType.INSERT;
            } else if (type == OperationType.INSERT) {
                type = OperationType.DELETE;
            }
        }
        if (type == OperationType.WRITE) {
            range.extend(operation.getPos(), operation.getPos() + (long)operation.getLength());
        } else if (type == OperationType.DELETE) {
            range.extend(operation.getPos(), this.getLength());
        } else if (type == OperationType.INSERT) {
            range.extend(operation.getPos(), this.getLength() + (long)operation.getLength());
        }
    }

    public synchronized void flush() throws IOException {
        this.historyFile.flush();
        this.blockList.flush();
        this.operations.flush();
    }

    public synchronized void dispose() {
        this.historyFile.dispose();
        this.blockList.dispose();
        if (this.operations instanceof IDisposable) {
            this.operations.dispose();
        }
        this.transactions.clear();
        if (this.transactions instanceof IDisposable) {
            ((IDisposable)((Object)this.transactions)).dispose();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("UndoRedoFloatFile (size:");
        result.append(this.getLength());
        result.append(", blocks:");
        result.append(this.blockList.getNbBlocks());
        result.append(", operations:");
        result.append(this.operations.size());
        result.append(")");
        return result.toString();
    }

    public synchronized void savePoint() {
        this.saveIndex = this.operationIndex;
    }

    public synchronized void baseUndoRedoPoint() {
        this.baseUndoRedoIndex = this.undoRedoIndex;
    }

    public synchronized boolean isModified() {
        return this.saveIndex != this.operationIndex;
    }

    public float assertStatistics() throws IOException {
        int amount = this.blockList.assertStatistics(this.historyFile);
        return (float)amount / (float)this.blockList.getNbBlocks();
    }

    public synchronized AudioStatistics getStatistics(IUndoRedoFloatFile urFile, long pos, long length) throws IOException {
        return this.blockList.getStatistics(urFile, this.historyFile, pos, length);
    }

    public synchronized long getExtremumSample(long startPos, long stopPos, IUndoRedoFloatFile urFile, IExtremum extremum) throws IOException {
        return this.blockList.getExtremumSample(startPos, stopPos, urFile, this.historyFile, extremum);
    }
}

