/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.selection;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.PlaybackListener;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionInfo {
    private final AudioFile audioFile;
    private long cursorPosition;
    private long playbackPosition = -1L;
    private boolean playbackPaused;
    private List<ISelection> selections = new ArrayList<ISelection>();
    private List<SelectionAdapter> adapters = new ArrayList<SelectionAdapter>();
    private List<PlaybackListener> playbackListeners = new ArrayList<PlaybackListener>();

    public SelectionInfo(AudioFile audioFile) {
        this.audioFile = audioFile;
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }

    public synchronized long getCursorPosition() {
        return this.cursorPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorPosition(long cursorPosition) {
        boolean changes = false;
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            if (cursorPosition < 0L) {
                cursorPosition = 0L;
            }
            if (cursorPosition > this.audioFile.getLength()) {
                cursorPosition = this.audioFile.getLength();
            }
            if (this.cursorPosition != cursorPosition) {
                this.cursorPosition = cursorPosition;
                changes = true;
            }
        }
        if (changes) {
            this.fireCursorPositionChanged();
        }
    }

    public synchronized long getPlaybackPosition() {
        return this.playbackPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackPosition(long playbackPosition) {
        boolean changes = false;
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            if (this.playbackPosition != playbackPosition) {
                this.playbackPosition = playbackPosition;
                changes = true;
            }
        }
        if (changes) {
            this.firePlaybackPositionChanged();
        }
    }

    public synchronized boolean isPlaybackPaused() {
        return this.playbackPaused;
    }

    public synchronized void setPlaybackPaused(boolean paused) {
        this.playbackPaused = paused;
    }

    public synchronized long getBoundingStartPosition() {
        if (this.isEmpty()) {
            return -1L;
        }
        long result = this.audioFile.getLength();
        for (ISelection selection : this.selections) {
            result = Math.min(result, selection.getBoundingStartPosition());
        }
        return result;
    }

    public synchronized long getBoundingStopPosition() {
        if (this.isEmpty()) {
            return -1L;
        }
        long result = 0L;
        for (ISelection selection : this.selections) {
            result = Math.max(result, selection.getBoundingStopPosition());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelection(ISelection selection) {
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            this.selections.add(selection);
        }
        if (!selection.isEmpty()) {
            this.fireSelectionChanged(null, selection, false);
        }
    }

    public synchronized void addSelections(Collection<ISelection> selections) {
        for (ISelection item : selections) {
            this.addSelection(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelection(ISelection selection) {
        boolean changes = false;
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            if (this.selections.contains(selection)) {
                this.selections.remove(selection);
                changes = true;
            }
        }
        if (changes) {
            this.fireSelectionChanged(selection, null, false);
        }
    }

    public synchronized List<ISelection> getSelections() {
        return Collections.unmodifiableList(new ArrayList<ISelection>(this.selections));
    }

    public synchronized List<ISelection> getSortedSelections() {
        ArrayList<ISelection> result = new ArrayList<ISelection>(this.selections);
        Collections.sort(result, new Comparator<ISelection>(){

            @Override
            public int compare(ISelection o1, ISelection o2) {
                return new Long(o1.getBoundingStartPosition()).compareTo(new Long(o2.getBoundingStartPosition()));
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        boolean changes = false;
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            if (!this.selections.isEmpty()) {
                this.selections = new ArrayList<ISelection>();
                changes = true;
            }
        }
        if (changes) {
            this.fireSelectionChanged(null, null, false);
        }
    }

    public synchronized boolean isEmpty() {
        for (ISelection selection : this.selections) {
            if (selection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public synchronized long getLength() {
        long result = 0L;
        for (ISelection item : this.selections) {
            result += item.getBoundingStopPosition() - item.getBoundingStartPosition();
        }
        return result * (long)this.audioFile.getNbChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        ArrayList<ISelection> toFire = new ArrayList<ISelection>();
        SelectionInfo selectionInfo = this;
        synchronized (selectionInfo) {
            long max = this.audioFile.getLength();
            Iterator<ISelection> iter = this.selections.iterator();
            while (iter.hasNext()) {
                ISelection item = iter.next();
                if (item.getBoundingStopPosition() <= max) continue;
                if (item instanceof TimeRangeSelection) {
                    TimeRangeSelection trSel = (TimeRangeSelection)item;
                    if (trSel.getStartPosition() >= max) {
                        iter.remove();
                        toFire.add(item);
                        continue;
                    }
                    trSel.setStopPosition(max);
                    continue;
                }
                iter.remove();
                toFire.add(item);
            }
            if (this.cursorPosition > max) {
                this.setCursorPosition(0L);
            }
        }
        for (ISelection item : toFire) {
            this.fireSelectionChanged(item, null, false);
        }
    }

    public synchronized void addSelectionListener(SelectionAdapter adapter) {
        this.adapters.add(adapter);
    }

    public synchronized void removeSelectionListener(SelectionAdapter adapter) {
        this.adapters.remove(adapter);
    }

    private synchronized List<SelectionAdapter> adapters() {
        return new ArrayList<SelectionAdapter>(this.adapters);
    }

    public synchronized void addPlaybackListener(PlaybackListener listener) {
        this.playbackListeners.add(listener);
    }

    public synchronized void removePlaybackListener(PlaybackListener listener) {
        this.playbackListeners.remove(listener);
    }

    private synchronized List<PlaybackListener> playbackListeners() {
        return new ArrayList<PlaybackListener>(this.playbackListeners);
    }

    public void fireSelectionChanged(ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
        for (SelectionAdapter adapter : this.adapters()) {
            adapter.selectionChanged(this, oldSelection, newSelection, isAdjusting);
        }
    }

    private void fireCursorPositionChanged() {
        for (SelectionAdapter adapter : this.adapters()) {
            adapter.cursorPositionChanged(this);
        }
    }

    private void firePlaybackPositionChanged() {
        for (PlaybackListener listener : this.playbackListeners()) {
            listener.playbackPositionChanged(this);
        }
    }

    public void clearListeners() {
        this.playbackListeners.clear();
        this.adapters.clear();
    }

    public String toString() {
        return "Cursor:" + this.cursorPosition + ",selection:" + this.selections.toString();
    }
}

