/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.selection;

import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import java.util.BitSet;

public class TimeRangeSelection
implements ISelection {
    private final SelectionInfo selectionInfo;
    private long startPosition;
    private long stopPosition;
    private BitSet channels;
    private boolean adjusting;

    public TimeRangeSelection(SelectionInfo selectionInfo, long start, long stop, BitSet channels) {
        this.selectionInfo = selectionInfo;
        this.startPosition = start;
        this.stopPosition = stop;
        this.channels = channels;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        if (startPosition != this.startPosition) {
            TimeRangeSelection previous = this.clone();
            this.startPosition = startPosition;
            this.selectionInfo.fireSelectionChanged(previous, this, false);
        }
    }

    public long getStopPosition() {
        return this.stopPosition;
    }

    public void setStopPosition(long stopPosition) {
        if (stopPosition != this.stopPosition) {
            TimeRangeSelection previous = this.clone();
            this.stopPosition = stopPosition;
            this.selectionInfo.fireSelectionChanged(previous, this, false);
        }
    }

    public void setRange(long startPosition, long stopPosition, boolean adjusting) {
        if (startPosition != this.startPosition || stopPosition != this.stopPosition || this.adjusting != adjusting) {
            TimeRangeSelection previous = this.clone();
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
            this.adjusting = adjusting;
            this.selectionInfo.fireSelectionChanged(previous, this, adjusting);
        }
    }

    public long getBoundingStartPosition() {
        return this.startPosition;
    }

    public long getBoundingStopPosition() {
        return this.stopPosition;
    }

    public BitSet getChannels() {
        return this.channels;
    }

    public boolean isEmpty() {
        return this.startPosition >= this.stopPosition;
    }

    public boolean intersects(TimeRangeSelection other) {
        return this.startPosition < other.stopPosition && this.stopPosition > other.startPosition;
    }

    public boolean merge(TimeRangeSelection other) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot merge on an empty selection");
        }
        if (other.isEmpty()) {
            return true;
        }
        TimeRangeSelection old = this.clone();
        if (this.startPosition <= other.stopPosition && this.stopPosition >= other.startPosition) {
            this.startPosition = Math.min(this.startPosition, other.startPosition);
            this.stopPosition = Math.max(this.stopPosition, other.stopPosition);
            this.selectionInfo.fireSelectionChanged(old, this, false);
            return true;
        }
        return false;
    }

    public TimeRangeSelection clone() {
        try {
            return (TimeRangeSelection)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "[" + this.startPosition + "-" + this.stopPosition + "]@" + this.channels;
    }
}

