/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.stats;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.raw.IBlockSerializable;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.corebounce.common.struct.PublicCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioStatistics
implements PublicCloneable<AudioStatistics>,
IBlockSerializable<AudioStatistics>,
Serializable {
    private float min = Float.POSITIVE_INFINITY;
    private float max = Float.NEGATIVE_INFINITY;
    private float avg = 0.0f;
    private float sqAvg = 0.0f;
    private long address;
    private static ThreadLocal<float[]> buffers = new ThreadLocal();

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getAvg() {
        return this.avg;
    }

    public void setAvg(float avg) {
        this.avg = avg;
    }

    public float getSqAvg() {
        return this.sqAvg;
    }

    public void setSqAvg(float loudness) {
        this.sqAvg = loudness;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public void compute(ISimpleFloatFile file, Block block) throws IOException {
        if (block.getDstPos() < 0L) {
            throw new IllegalArgumentException("Shouldn't compute stats on an aggregated block");
        }
        this.compute(file, block.getDstPos(), (int)block.getLength());
    }

    public void compute(ISimpleFloatFile file, long pos, int length) throws IOException {
        float[] buffer = buffers.get();
        if (buffer == null || buffer.length < length) {
            buffer = new float[length];
            buffers.set(buffer);
        }
        file.read(pos, buffer, 0, length);
        this.compute(buffer, 0, (long)length);
    }

    public void compute(float[] data, int offset, long length) {
        this.avg = data[offset];
        this.sqAvg = this.avg * this.avg;
        this.min = this.avg;
        this.max = this.avg;
        int i = 1;
        while ((long)i < length - 1L) {
            float value1 = data[i + offset];
            float value2 = data[i + offset + 1];
            if (value1 > value2) {
                if (value1 > this.max) {
                    this.max = value1;
                }
                if (value2 < this.min) {
                    this.min = value2;
                }
            } else {
                if (value2 > this.max) {
                    this.max = value2;
                }
                if (value1 < this.min) {
                    this.min = value1;
                }
            }
            this.avg += value1 + value2;
            this.sqAvg += value1 * value1 + value2 * value2;
            i += 2;
        }
        if ((long)i < length) {
            float value = data[i + offset];
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
            this.avg += value;
            this.sqAvg += value * value;
        }
        this.avg /= (float)length;
        this.sqAvg /= (float)length;
    }

    public void accumulate(AudioStatistics other, long amount) {
        if (other.min < this.min) {
            this.min = other.min;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
        this.accumulateAvg(other, amount);
    }

    public void accumulateAvg(AudioStatistics other, long amount) {
        this.avg += other.avg * (float)amount;
        this.sqAvg += other.sqAvg * (float)amount;
    }

    public void normalize(long totalWeight) {
        if (totalWeight > 0L) {
            this.avg /= (float)totalWeight;
            this.sqAvg /= (float)totalWeight;
        }
    }

    public void mergeWith(AudioStatistics other, long thisAmount, long otherAmount) {
        if (other.min < this.min) {
            this.min = other.min;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
        this.avg = (this.avg * (float)thisAmount + other.avg * (float)otherAmount) / (float)(thisAmount + otherAmount);
        this.sqAvg = (this.sqAvg * (float)thisAmount + other.sqAvg * (float)otherAmount) / (float)(thisAmount + otherAmount);
    }

    @Override
    public AudioStatistics clone() {
        try {
            return (AudioStatistics)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public void serialize(DataOutputStream target) throws IOException {
        target.writeFloat(this.min);
        target.writeFloat(this.max);
        target.writeFloat(this.avg);
        target.writeFloat(this.sqAvg);
    }

    @Override
    public AudioStatistics deserialize(DataInputStream source) throws IOException {
        AudioStatistics result = new AudioStatistics();
        result.selfDeserialize(source);
        return result;
    }

    public void selfDeserialize(DataInputStream source) throws IOException {
        this.min = source.readFloat();
        this.max = source.readFloat();
        this.avg = source.readFloat();
        this.sqAvg = source.readFloat();
    }

    public static void serializeNull(DataOutputStream target) throws IOException {
        target.writeFloat(Float.NaN);
        target.writeFloat(Float.NaN);
        target.writeFloat(Float.NaN);
        target.writeFloat(Float.NaN);
    }

    public boolean isUnknown() {
        return Float.isNaN(this.min) || Float.isNaN(this.max) || Float.isNaN(this.avg) || Float.isNaN(this.sqAvg);
    }

    public boolean isUndefined() {
        return Float.isInfinite(this.min) || Float.isInfinite(this.max);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.avg);
        result = 31 * result + Float.floatToIntBits(this.sqAvg);
        result = 31 * result + Float.floatToIntBits(this.max);
        result = 31 * result + Float.floatToIntBits(this.min);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AudioStatistics other = (AudioStatistics)obj;
        if (Float.floatToIntBits(this.avg) != Float.floatToIntBits(other.avg)) {
            return false;
        }
        if (Float.floatToIntBits(this.sqAvg) != Float.floatToIntBits(other.sqAvg)) {
            return false;
        }
        if (Float.floatToIntBits(this.max) != Float.floatToIntBits(other.max)) {
            return false;
        }
        return Float.floatToIntBits(this.min) == Float.floatToIntBits(other.min);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        result.append("min=");
        result.append(this.min);
        result.append(",max=");
        result.append(this.max);
        result.append(",avg=");
        result.append(this.avg);
        result.append(",loudness=");
        result.append(this.sqAvg);
        result.append("}");
        return result.toString();
    }
}

