/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.stats;

import ch.tachyon.sonics.data.memory.audio.ISimpleFloatFile;
import ch.tachyon.sonics.data.memory.undoredo.Block;
import ch.tachyon.sonics.data.stats.IExtremum;
import java.io.IOException;

public class LoudestExtremum
implements IExtremum {
    private ISimpleFloatFile historyFile;
    private float maxValue = -1.0f;

    public void reset(ISimpleFloatFile historyFile) {
        this.historyFile = historyFile;
        this.maxValue = -1.0f;
    }

    public boolean update(Block block) throws IOException {
        float newValue = block.getStatistics(this.historyFile).getSqAvg();
        if (newValue > this.maxValue) {
            this.maxValue = newValue;
            return true;
        }
        return false;
    }

    public boolean update(float sample) {
        float newValue = sample * sample;
        if (newValue > this.maxValue) {
            this.maxValue = newValue;
            return true;
        }
        return false;
    }

    public float getResult() {
        return this.maxValue;
    }
}

