/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.view;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import java.util.concurrent.locks.ReentrantLock;
import org.corebounce.common.utils.IDisposable;

public class AudioChannelDataView
implements IDisposable {
    private final AudioChannel channel;
    private IAudioChannelPanel panel;
    private long startPos;
    private long stopPos;
    private float floor = -1.0f;
    private float ceil = 1.0f;
    public static final ReentrantLock fileAccessLock = new ReentrantLock(true);

    public AudioChannelDataView(AudioChannel channel) {
        this.channel = channel;
        channel.getFile().addView(this);
    }

    public void setPanel(IAudioChannelPanel panel) {
        this.panel = panel;
        this.setAllVisible();
    }

    public IAudioChannelPanel getPanel() {
        return this.panel;
    }

    public AudioChannel getAudioChannel() {
        return this.channel;
    }

    public AudioFile getAudioFile() {
        return this.channel.getFile();
    }

    public synchronized long getLength() {
        return this.stopPos - this.startPos;
    }

    public synchronized long getStartPosition() {
        return this.startPos;
    }

    public synchronized long getStopPosition() {
        return this.stopPos;
    }

    public synchronized void setAllVisible() {
        this.startPos = 0L;
        this.stopPos = this.channel.getFile().getLength();
        this.floor = -1.0f;
        this.ceil = 1.0f;
        this.panel.markUnpainted(this);
        this.panel.markDirty(this);
    }

    public synchronized float getVerticalCeil() {
        return this.ceil;
    }

    public synchronized float getVerticalFloor() {
        return this.floor;
    }

    public synchronized void setVerticalRange(float verticalCeil, float verticalFloor) {
        if (verticalCeil != this.ceil || verticalFloor != this.floor) {
            this.ceil = verticalCeil;
            this.floor = verticalFloor;
            this.panel.markUnpainted(this);
        }
    }

    public synchronized void setVisibleRange(long startPosition, long stopPosition) {
        if (stopPosition == startPosition) {
            if (startPosition > 0L) {
                --startPosition;
            } else {
                ++stopPosition;
            }
        }
        if (startPosition != this.startPos || stopPosition != this.stopPos) {
            this.startPos = startPosition;
            this.stopPos = stopPosition;
            this.panel.markDirty(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(long fileOffset) {
        int pixelOffset;
        boolean isFastScrollable = true;
        AudioChannelDataView audioChannelDataView = this;
        synchronized (audioChannelDataView) {
            if (fileOffset < 0L && this.startPos + fileOffset < 0L) {
                fileOffset = -this.startPos;
            } else if (fileOffset > 0L && this.stopPos + fileOffset > this.channel.getFileLength()) {
                fileOffset = this.channel.getFileLength() - this.stopPos;
            }
            pixelOffset = this.panel.deltaToPixel(fileOffset);
            fileOffset = this.panel.deltaFromPixel(pixelOffset);
            if (fileOffset < 0L && this.startPos + fileOffset < 0L) {
                fileOffset = -this.startPos;
                isFastScrollable = false;
            } else if (fileOffset > 0L && this.stopPos + fileOffset > this.channel.getFileLength()) {
                fileOffset = this.channel.getFileLength() - this.stopPos;
                isFastScrollable = false;
            }
            if (fileOffset == 0L) {
                return;
            }
            this.startPos += fileOffset;
            this.stopPos += fileOffset;
        }
        if (isFastScrollable) {
            this.panel.scroll(this, fileOffset, pixelOffset);
        } else {
            this.panel.markDirty(this);
        }
    }

    public void dispose() {
        this.channel.getFile().removeView(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("start=");
        result.append(this.startPos);
        result.append(",stop=");
        result.append(this.stopPos);
        result.append(",floor=");
        result.append(this.floor);
        result.append(",ceil=");
        result.append(this.ceil);
        return result.toString();
    }
}

