/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.view;

import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioChannelDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import ch.tachyon.sonics.data.view.ChannelViewType;
import java.util.ArrayList;
import java.util.Collection;
import org.corebounce.common.audio.AudioMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioDataView {
    public static final float MIN_VERT_SPAN = (float)AudioMath.dbToLevel(-144.0);
    public static final float MIN_FLOOR = -2.0f;
    public static final float MAX_CEIL = 2.0f;
    private final AudioFile audioFile;
    private final Collection<AudioChannelDataView> channelViews;
    private final Collection<AudioFileViewListener> listeners = new ArrayList<AudioFileViewListener>();
    private ChannelViewType viewType = ChannelViewType.WAVEFORM;

    public AudioDataView(AudioFile audioFile, Collection<AudioChannelDataView> views) {
        this.audioFile = audioFile;
        this.channelViews = views;
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartPosition() {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            block5: {
                if (!this.channelViews.isEmpty()) break block5;
                return 0L;
            }
            long result = this.audioFile.getLength();
            for (AudioChannelDataView view : this.channelViews) {
                result = Math.min(result, view.getStartPosition());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStopPosition() {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            if (this.channelViews.isEmpty()) {
                return this.audioFile.getLength();
            }
            long result = 0L;
            for (AudioChannelDataView view : this.channelViews) {
                result = Math.max(result, view.getStopPosition());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleRange(long startPosition, long stopPosition) {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            if (stopPosition <= startPosition) {
                if (startPosition > 0L) {
                    --startPosition;
                } else {
                    ++stopPosition;
                }
            }
            for (AudioChannelDataView view : this.channelViews) {
                view.setVisibleRange(startPosition, stopPosition);
            }
        }
        this.fireViewChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(long offset) {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            if (offset == 0L) {
                return;
            }
            for (AudioChannelDataView view : this.channelViews) {
                view.scroll(offset);
            }
        }
        this.fireViewChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getVerticalCeil() {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            block5: {
                if (!this.channelViews.isEmpty()) break block5;
                return 1.0f;
            }
            float result = -1.0f;
            for (AudioChannelDataView view : this.channelViews) {
                result = Math.max(result, view.getVerticalCeil());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getVerticalFloor() {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            block5: {
                if (!this.channelViews.isEmpty()) break block5;
                return -1.0f;
            }
            float result = 1.0f;
            for (AudioChannelDataView view : this.channelViews) {
                result = Math.min(result, view.getVerticalFloor());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerticalRange(float verticalCeil, float verticalFloor) {
        if (verticalCeil < verticalFloor) {
            float temp = verticalCeil;
            verticalCeil = verticalFloor;
            verticalFloor = temp;
        }
        if (verticalCeil - verticalFloor < MIN_VERT_SPAN) {
            return;
        }
        if (verticalCeil > 2.0f) {
            verticalCeil = 2.0f;
        }
        if (verticalFloor < -2.0f) {
            verticalFloor = -2.0f;
        }
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            for (AudioChannelDataView view : this.channelViews) {
                view.setVerticalRange(verticalCeil, verticalFloor);
            }
        }
        this.fireViewChanged();
    }

    public void scrollVertical(float verticalOffset) {
        float floor = this.getVerticalFloor();
        float ceil = this.getVerticalCeil();
        if (floor + verticalOffset < -2.0f) {
            verticalOffset = -2.0f - floor;
        } else if (ceil + verticalOffset > 2.0f) {
            verticalOffset = 2.0f - ceil;
        }
        this.setVerticalRange(ceil + verticalOffset, floor + verticalOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllVisible() {
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            for (AudioChannelDataView view : this.channelViews) {
                view.setAllVisible();
            }
        }
        this.fireViewChanged();
    }

    public void ensureCoherent() {
        long fileLength = this.audioFile.getLength();
        long viewStart = this.getStartPosition();
        long viewStop = this.getStopPosition();
        if (viewStop > fileLength && viewStart > 0L) {
            long scrollAmount = Math.min(viewStart, viewStop - fileLength);
            this.setVisibleRange(viewStart - scrollAmount, viewStop - scrollAmount);
        } else if (viewStart < 0L) {
            this.setVisibleRange(0L, viewStop - viewStart);
        } else if (viewStop < viewStart + 8L) {
            viewStart = Math.max(0L, viewStop - 4L);
            viewStop = Math.min(this.audioFile.getLength(), viewStart + 8L);
            viewStart = Math.max(0L, viewStop - 8L);
            viewStop = Math.min(this.audioFile.getLength(), viewStart + 8L);
            this.setVisibleRange(viewStart, viewStop);
        }
        SelectionInfo sInfo = this.audioFile.getSelection();
        if (sInfo.getCursorPosition() > fileLength) {
            sInfo.setCursorPosition(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewType(ChannelViewType viewType) {
        this.viewType = viewType;
        Collection<AudioChannelDataView> collection = this.channelViews;
        synchronized (collection) {
            for (AudioChannelDataView view : this.channelViews) {
                view.getPanel().setViewType(viewType);
            }
        }
        this.fireViewChanged();
    }

    public ChannelViewType getViewType() {
        return this.viewType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewListener(AudioFileViewListener listener) {
        Collection<AudioFileViewListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewListener(AudioFileViewListener listener) {
        Collection<AudioFileViewListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AudioFileViewListener> listeners() {
        Collection<AudioFileViewListener> collection = this.listeners;
        synchronized (collection) {
            return new ArrayList<AudioFileViewListener>(this.listeners);
        }
    }

    public void fireViewChanged() {
        for (AudioFileViewListener listener : this.listeners()) {
            listener.viewChanged(this);
        }
    }

    public void fireChannelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        for (AudioFileViewListener listener : this.listeners()) {
            listener.channelSizeChanged(channel, oldSize, newSize);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("start=");
        result.append(this.getStartPosition());
        result.append(",stop=");
        result.append(this.getStopPosition());
        result.append(",floor=");
        result.append(this.getVerticalFloor());
        result.append(",ceil=");
        result.append(this.getVerticalCeil());
        return result.toString();
    }
}

