/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.data.view;

import ch.tachyon.sonics.data.view.AudioChannelDataView;
import ch.tachyon.sonics.data.view.ChannelViewType;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedAudioChannelPanel
implements IAudioChannelPanel {
    private List<IAudioChannelPanel> panels;

    private IAudioChannelPanel firstPanel() {
        return this.panels.get(0);
    }

    public MergedAudioChannelPanel(List<IAudioChannelPanel> panels) {
        this.panels = Collections.unmodifiableList(panels);
    }

    @Override
    public void markDirty(AudioChannelDataView view) {
        for (IAudioChannelPanel panel : this.panels) {
            panel.markDirty(view);
        }
    }

    @Override
    public void markUnpainted(AudioChannelDataView view) {
        for (IAudioChannelPanel panel : this.panels) {
            panel.markUnpainted(view);
        }
    }

    @Override
    public int deltaToPixel(long delta) {
        return this.firstPanel().deltaToPixel(delta);
    }

    @Override
    public long deltaFromPixel(int pixel) {
        return this.firstPanel().deltaFromPixel(pixel);
    }

    @Override
    public int toXCoord(long position, int roundPos) {
        return this.firstPanel().toXCoord(position, roundPos);
    }

    @Override
    public long fromXCoord(int xCoord, int roundPos) {
        return this.firstPanel().fromXCoord(xCoord, roundPos);
    }

    @Override
    public float toVertOffset(int pixelValue) {
        return this.firstPanel().toVertOffset(pixelValue);
    }

    @Override
    public void scroll(AudioChannelDataView view, long fileOffset, int pixelOffset) {
        for (IAudioChannelPanel panel : this.panels) {
            panel.scroll(view, fileOffset, pixelOffset);
        }
    }

    @Override
    public int getHeight() {
        return 0;
    }

    @Override
    public void setHeight(int height) {
    }

    @Override
    public void setViewType(ChannelViewType viewType) {
        for (IAudioChannelPanel panel : this.panels) {
            panel.setViewType(viewType);
        }
    }
}

