/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui;

import ch.tachyon.sonics.action.file.OpenAction;
import ch.tachyon.sonics.gui.progress.ProgressPanel;
import ch.tachyon.tunnel.utils.Monitor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.corebounce.common.gui.IconLoader;

public class SwingPreCompiler
implements Runnable {
    private static ImageIcon[] icons = new ImageIcon[4];
    private static final Object chooserLock = new Monitor("chooserLock");
    private static JFileChooser chooser = null;

    public void run() {
        try {
            String lafName = UIManager.getLookAndFeel().getName();
            if (lafName.contains("Substance")) {
                throw new IllegalStateException();
            }
            this.prepareFileChooser();
        }
        catch (Throwable ex) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingPreCompiler.this.prepareFileChooser();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFileChooser() {
        try {
            UIManager.getIcon("FileView.directoryIcon");
            UIManager.getIcon("FileView.fileIcon");
            UIManager.getIcon("FileView.computerIcon");
            UIManager.getIcon("FileView.hardDriveIcon");
            UIManager.getIcon("FileView.floppyDriveIcon");
            UIManager.getIcon("FileChooser.homeFolderIcon");
            UIManager.getIcon("FileChooser.newFolderIcon");
            UIManager.getIcon("FileChooser.upFolderIcon");
            UIManager.getIcon("FileChooser.detailsViewIcon");
            UIManager.getIcon("FileChooser.listViewIcon");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        JFileChooser chooser = new JFileChooser();
        chooser.validate();
        Preferences prefs = Preferences.userNodeForPackage(OpenAction.class);
        String currentDirectory = prefs.get("currentDirectory", null);
        if (currentDirectory != null) {
            File curDir = new File(currentDirectory);
            if (curDir.isDirectory()) {
                chooser.setCurrentDirectory(curDir);
            }
        } else {
            chooser.setCurrentDirectory(chooser.getFileSystemView().getDefaultDirectory());
        }
        SwingPreCompiler.chooser = chooser;
        Object object = chooserLock;
        synchronized (object) {
            chooserLock.notifyAll();
        }
        SwingPreCompiler.icons[0] = IconLoader.getImageIcon(ProgressPanel.class, "Stop.png", 16, 16);
        SwingPreCompiler.icons[1] = IconLoader.getImageIcon(ProgressPanel.class, "Cancel.png", 16, 16);
        SwingPreCompiler.icons[2] = IconLoader.getImageIcon(ProgressPanel.class, "Resume.png", 16, 16);
        SwingPreCompiler.icons[3] = IconLoader.getImageIcon(ProgressPanel.class, "Pause.png", 16, 16);
        BufferedImage image = new BufferedImage(16, 16, 2);
        Graphics2D g = image.createGraphics();
        ImageIcon[] imageIconArray = icons;
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            ImageIcon icon = imageIconArray[n2];
            g.drawImage(icon.getImage(), 0, 0, null);
            ++n2;
        }
        g.dispose();
    }

    public static void start() {
        Thread t = new Thread(new SwingPreCompiler());
        t.setName("Swing pre-compiler");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JFileChooser getFileChooser() {
        Object object = chooserLock;
        synchronized (object) {
            while (true) {
                if (chooser != null) {
                    return chooser;
                }
                try {
                    chooserLock.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileChooser(JFileChooser chooser) {
        Object object = chooserLock;
        synchronized (object) {
            SwingPreCompiler.chooser = chooser;
        }
        if (chooser == null) {
            SwingPreCompiler.start();
        }
    }
}

