/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui;

import ch.tachyon.sonics.Config;
import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.action.edit.PreferencesAction;
import ch.tachyon.sonics.action.file.OpenAction;
import ch.tachyon.sonics.action.file.QuitAction;
import ch.tachyon.sonics.action.help.AboutAction;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.TachyonSonicsApp;
import ch.tachyon.sonics.gui.TransportToolbarPanel;
import ch.tachyon.sonics.gui.file.FileListPanel;
import ch.tachyon.sonics.gui.icon.Icons;
import ch.tachyon.sonics.gui.message.MessagePanel;
import ch.tachyon.sonics.gui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.os.Integration;
import org.corebounce.common.os.Integrator;
import org.corebounce.common.utils.DeadlockDetector;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;

public class TachyonSonicsFrame
extends JFrame {
    private static final int SEPARATOR_WIDTH = 6;
    private JPanel splitPanel;
    private JComponent splitter;
    private FileListPanel flPanel;
    private ToolboxPanel tbPanel;
    private OpenAction openAction;
    private QuitAction quitAction;
    private PreferencesAction preferenceAction;
    private AboutAction aboutAction;
    private Integrator integrator;
    private boolean dragging = false;
    private int startDragX;
    private int startDragWidth;
    private int curDragWidth;

    public TachyonSonicsFrame() {
        super(Config.getFullAppName());
        super.setDefaultCloseOperation(0);
        int iconSize = -1;
        if (Platform.getPlatform().equals((Object)PlatformType.WINDOWS)) {
            iconSize = 32;
        }
        super.setIconImage(IconLoader.getImage(Icons.class, "AppIcon.png", iconSize));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DeadlockDetector.detectDeadlocksNow();
                QuitAction.quit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TachyonSonicsFrame.this.windowResized();
            }
        });
        this.setupDefaultDimension();
        this.setLayout(new BorderLayout());
    }

    private void setupDefaultDimension() {
        int width = 900;
        int height = 600;
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            int sWidth = screenSize.width - screenInsets.left - screenInsets.right;
            int sHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
            if (sWidth >= 600 && sWidth < width) {
                width = sWidth;
            }
            if (sHeight >= 400 && sHeight < height) {
                height = sHeight;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setPreferredSize(new Dimension(width, height));
    }

    public void init(Controller controller) {
        MenuBar menus = this.installMenuBar(controller);
        this.installTransportToolbar(controller);
        this.installPanels(controller, menus);
        this.integrateWithOs();
        super.pack();
        controller.getSession().addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                TachyonSonicsFrame.this.currentFileChanged(audioFile);
            }
        });
    }

    private void installTransportToolbar(Controller controller) {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        super.getContentPane().add((Component)leftPanel, "North");
        TransportToolbarPanel toolBars = new TransportToolbarPanel(controller);
        leftPanel.add((Component)toolBars, "West");
    }

    private MenuBar installMenuBar(Controller controller) {
        MenuBar menus = MenuBar.getInstance(controller);
        JMenuBar menuBar = new JMenuBar();
        this.installMenuGroup(menuBar, menus.getFileMenu());
        this.installMenuGroup(menuBar, menus.getEditMenu());
        this.installMenuGroup(menuBar, menus.getViewMenu());
        this.installMenuGroup(menuBar, menus.getTransportMenu());
        this.installMenuGroup(menuBar, menus.getHelpMenu());
        super.setJMenuBar(menuBar);
        return menus;
    }

    private void installMenuGroup(JComponent parent, MenuGroupBase group) {
        JMenu menu = new JMenu(group);
        parent.add(menu);
        ButtonGroup buttonGroup = null;
        if (group.isRadioButtonGroup()) {
            buttonGroup = new ButtonGroup();
        }
        for (ActionBase action : group.getItems()) {
            if (action instanceof MenuGroupBase) {
                MenuGroupBase mGroup = (MenuGroupBase)action;
                this.installMenuGroup(menu, mGroup);
                continue;
            }
            if (action == null) {
                menu.add(new JSeparator());
                continue;
            }
            JMenuItem menuItem = action.createMenuItem(group, buttonGroup);
            menu.add(menuItem);
            if (action instanceof QuitAction) {
                this.quitAction = (QuitAction)action;
                continue;
            }
            if (action instanceof OpenAction) {
                this.openAction = (OpenAction)action;
                continue;
            }
            if (action instanceof AboutAction) {
                this.aboutAction = (AboutAction)action;
                continue;
            }
            if (!(action instanceof PreferencesAction)) continue;
            this.preferenceAction = (PreferencesAction)action;
        }
    }

    private void installPanels(Controller controller, MenuBar menus) {
        this.splitPanel = new JPanel();
        this.splitPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitPanel, "Center");
        this.flPanel = new FileListPanel(controller.getSession());
        this.splitPanel.add((Component)this.flPanel, "Center");
        JPanel rPanel = new JPanel();
        rPanel.setLayout(new BorderLayout());
        this.splitPanel.add((Component)rPanel, "East");
        this.splitter = this.createSeparator();
        rPanel.add((Component)this.splitter, "West");
        JPanel rSplit = new JPanel();
        rSplit.setLayout(new BorderLayout());
        rPanel.add((Component)rSplit, "Center");
        MessagePanel mPanel = new MessagePanel();
        rSplit.add((Component)mPanel, "South");
        this.tbPanel = new ToolboxPanel(controller, menus);
        rSplit.add((Component)this.tbPanel, "Center");
    }

    private void integrateWithOs() {
        this.integrator = Integration.getIntegrator();
        if (this.integrator == null) {
            return;
        }
        TachyonSonicsApp app = new TachyonSonicsApp(this.aboutAction, this.preferenceAction, this.quitAction, this.openAction);
        this.integrator.integrate(app);
    }

    private JComponent createSeparator() {
        JSeparator separator = new JSeparator(1);
        separator.setPreferredSize(new Dimension(6, 6));
        separator.setMinimumSize(new Dimension(6, 6));
        separator.setCursor(Cursor.getPredefinedCursor(10));
        separator.setToolTipText("<html><body>Click and drag to resize.<br>Double-click to reset toolbox size</body></html>");
        separator.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TachyonSonicsFrame.this.separatorPressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                TachyonSonicsFrame.this.separatorDragged(e);
            }

            public void mouseClicked(MouseEvent e) {
                TachyonSonicsFrame.this.separatorClicked(e);
            }
        });
        separator.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                TachyonSonicsFrame.this.separatorDragged(e);
            }
        });
        return separator;
    }

    private void separatorPressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x1000) != 0 && this.dragging) {
            this.setRightWidth(this.startDragWidth);
            this.dragging = false;
        } else {
            this.startDragX = AwtTools.getScreenX(e);
            this.curDragWidth = this.startDragWidth = this.getRightWidth();
            this.dragging = true;
        }
    }

    private void separatorDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        int newX = AwtTools.getScreenX(e);
        int xDelta = newX - this.startDragX;
        int newWidth = this.startDragWidth - xDelta;
        int minWidth = this.getRightMinWidth();
        int maxWidth = this.getRightMaxWidth();
        if (newWidth < minWidth) {
            newWidth = minWidth;
        } else if (newWidth > maxWidth) {
            newWidth = maxWidth;
        }
        if (newWidth != this.curDragWidth) {
            this.setRightWidth(newWidth);
            this.curDragWidth = newWidth;
        }
    }

    private void separatorClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.tbPanel.resetWidth();
            this.flPanel.resetWidth();
        }
        this.dragging = false;
    }

    private void windowResized() {
        this.flPanel.resetWidth();
        this.tbPanel.resetWidth();
    }

    private int getRightWidth() {
        return this.tbPanel.getWidth();
    }

    private int getRightMinWidth() {
        return this.tbPanel.getMinimumSize().width;
    }

    private int getRightMaxWidth() {
        int result = this.splitPanel.getWidth();
        result -= this.flPanel.getMinimumSize().width;
        Insets flI = this.flPanel.getInsets();
        result -= flI.left + flI.right;
        return result -= this.splitter.getWidth();
    }

    private void setRightWidth(int rWidth) {
        this.tbPanel.setWidth(rWidth);
        int lWidth = this.splitPanel.getWidth();
        lWidth -= this.getInsetWidth(this.splitPanel);
        lWidth -= this.splitter.getWidth();
        this.flPanel.setWidth(lWidth -= rWidth);
    }

    private int getInsetWidth(JComponent cmp) {
        Insets insets = cmp.getInsets();
        return insets.left + insets.right;
    }

    private void currentFileChanged(AudioFile currentFile) {
        String title;
        if (currentFile == null) {
            title = Config.getFullAppName();
        } else {
            File file = currentFile.getFile();
            title = file == null ? "New Audio File" : file.getName();
            if (currentFile.isModified()) {
                title = String.valueOf(title) + "*";
            }
            title = String.valueOf(title) + " - Tachyon Sonics";
        }
        final String title0 = title;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TachyonSonicsFrame.this.setTitle(title0);
            }
        });
    }

    public void quit() {
        super.setVisible(false);
        super.dispose();
    }

    public void setModifiedStatus(AudioFile file, boolean modified) {
        if (this.integrator != null) {
            this.integrator.setModifiedStatus(this, modified);
        }
        this.currentFileChanged(file);
    }
}

