/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.IAudioChannelPanel;
import ch.tachyon.sonics.gui.file.FilePanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;

public class CornerScrollPanel
extends JPanel
implements ILafListener {
    private final FilePanel filePanel;
    private final AudioFile audioFile;
    private Color background;
    private boolean dragging = false;
    private int lastX;
    private int lastY;
    private long startStartPos;
    private long startStopPos;
    private float startFloor;
    private float startCeil;

    public CornerScrollPanel(AudioFile audioFile, FilePanel filePanel) {
        this.filePanel = filePanel;
        this.audioFile = audioFile;
        this.setOpaque(true);
        this.setBorder(new BevelBorder(0));
        this.setToolTipText("<html><body>Click and drag to move in any direction<p>Double-click to fit window height</body></html>");
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.updateLaf();
        AwtTools.addPostLafListener(this);
    }

    public void lookAndFeelChanged(String lafClassName) {
        if (!this.isShowing()) {
            return;
        }
        this.updateLaf();
        this.repaint();
    }

    private void updateLaf() {
        AwtTools.invokeAndWait(new Runnable(){

            public void run() {
                CornerScrollPanel.this.background = AwtTools.backgroundColor(CornerScrollPanel.this);
            }
        });
    }

    private void fitSize() {
        this.filePanel.distributeHeight();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CornerScrollPanel.this.filePanel.fitHeight();
            }
        });
    }

    private void fullFit() {
        this.audioFile.getView().setAllVisible();
    }

    private void scrollBy(int deltaX, int deltaY) {
        IAudioChannelPanel panel = this.audioFile.getMergedPanel();
        if (deltaX != 0) {
            long deltaPos = panel.deltaFromPixel(deltaX);
            this.audioFile.getView().scroll(deltaPos);
        }
        if (deltaY != 0) {
            float offset = panel.toVertOffset(deltaY);
            this.audioFile.getView().scrollVertical(offset);
        }
    }

    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.setColor(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.dispose();
    }

    class MyMouseAdapter
    implements MouseListener,
    MouseMotionListener {
        MyMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    CornerScrollPanel.this.fullFit();
                } else if (e.getClickCount() == 3) {
                    CornerScrollPanel.this.fitSize();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                if (CornerScrollPanel.this.dragging) {
                    CornerScrollPanel.this.audioFile.getView().setVisibleRange(CornerScrollPanel.this.startStartPos, CornerScrollPanel.this.startStopPos);
                    CornerScrollPanel.this.audioFile.getView().setVerticalRange(CornerScrollPanel.this.startCeil, CornerScrollPanel.this.startFloor);
                    CornerScrollPanel.this.dragging = false;
                    AwtTools.getWindow(CornerScrollPanel.this).setCursor(null);
                }
                return;
            }
            CornerScrollPanel.this.lastX = e.getX();
            CornerScrollPanel.this.lastY = e.getY();
            AudioDataView view = CornerScrollPanel.this.audioFile.getView();
            CornerScrollPanel.this.startStartPos = view.getStartPosition();
            CornerScrollPanel.this.startStopPos = view.getStopPosition();
            CornerScrollPanel.this.startFloor = view.getVerticalFloor();
            CornerScrollPanel.this.startCeil = view.getVerticalCeil();
            CornerScrollPanel.this.dragging = true;
        }

        public void mouseDragged(MouseEvent e) {
            if (!CornerScrollPanel.this.dragging) {
                return;
            }
            AwtTools.getWindow(CornerScrollPanel.this).setCursor(Cursor.getPredefinedCursor(13));
            int newX = e.getX();
            int newY = e.getY();
            int deltaX = newX - CornerScrollPanel.this.lastX;
            int deltaY = newY - CornerScrollPanel.this.lastY;
            CornerScrollPanel.this.scrollBy(-deltaX, deltaY);
            CornerScrollPanel.this.lastX = newX;
            CornerScrollPanel.this.lastY = newY;
        }

        public void mouseReleased(MouseEvent e) {
            CornerScrollPanel.this.dragging = false;
            AwtTools.getWindow(CornerScrollPanel.this).setCursor(null);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

