/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.gui.file;

import ch.tachyon.sonics.action.view.FitFileAction;
import ch.tachyon.sonics.action.view.FitHorzAction;
import ch.tachyon.sonics.action.view.FitSelectionAction;
import ch.tachyon.sonics.action.view.FitVertAction;
import ch.tachyon.sonics.action.view.SetViewTypeAction;
import ch.tachyon.sonics.action.view.ZoomInAction;
import ch.tachyon.sonics.action.view.ZoomInVertAction;
import ch.tachyon.sonics.action.view.ZoomOutAction;
import ch.tachyon.sonics.action.view.ZoomOutVertAction;
import ch.tachyon.sonics.action.view.ZoomSelectionStartAction;
import ch.tachyon.sonics.action.view.ZoomSelectionStopAction;
import ch.tachyon.sonics.data.ILockListener;
import ch.tachyon.sonics.data.ILockable;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.ChannelViewType;
import ch.tachyon.sonics.gui.file.FilePanel;
import ch.tachyon.sonics.gui.icon.Icons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.IDisposable;

public class FileControlPanel
extends JPanel
implements ILockListener,
IDisposable {
    private final AudioFile audioFile;
    private JComboBox cbViewType;
    private JButton btnViewConfig;
    private JToolBar tbHorzZoom;
    private JToolBar tbVertZoom;

    public FileControlPanel(final Session session, AudioFile audioFile, final FilePanel filePanel) {
        this.audioFile = audioFile;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        this.setLayout(new TableLayout(-1, gbc));
        this.setMinimumSize(new Dimension(16, 16));
        JPanel pnView = new JPanel();
        pnView.setLayout(new TableLayout(-1));
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(4, 4));
        pnView.add(spacer);
        this.cbViewType = new JComboBox();
        int i = 0;
        while (i < ChannelViewType.values().length) {
            SetViewTypeAction action = new SetViewTypeAction(session, ChannelViewType.values()[i], audioFile, this.cbViewType, (char)(i + 49), ChannelViewType.values()[i].name().toLowerCase().charAt(0));
            this.cbViewType.addItem(action);
            ++i;
        }
        this.cbViewType.setActionCommand("comboBoxChanged");
        this.cbViewType.setToolTipText("Choose how the audio is displayed");
        pnView.add(this.cbViewType);
        JToolBar tbConfig = new JToolBar();
        tbConfig.setFloatable(false);
        tbConfig.setBorderPainted(false);
        tbConfig.setOpaque(false);
        this.btnViewConfig = new JButton();
        this.btnViewConfig.setIcon(IconLoader.getImageIcon(Icons.class, "Settings.png", 16, 16));
        this.btnViewConfig.setToolTipText("Configure the current view type...");
        this.btnViewConfig.putClientProperty("JButton.buttonType", "toolbar");
        tbConfig.add(this.btnViewConfig);
        pnView.add(tbConfig);
        this.add((Component)pnView, gbc);
        this.cbViewType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!FileControlPanel.this.cbViewType.isEnabled()) {
                    return;
                }
                SetViewTypeAction action = (SetViewTypeAction)FileControlPanel.this.cbViewType.getSelectedItem();
                if (action != null) {
                    action.actionPerformed(e);
                }
            }
        });
        this.tbHorzZoom = new JToolBar();
        this.tbHorzZoom.setFloatable(false);
        this.tbHorzZoom.setOpaque(false);
        this.tbHorzZoom.add(new FitFileAction(session, audioFile).createButton(true));
        this.tbHorzZoom.add(new FitSelectionAction(session, audioFile).createButton(true));
        this.tbHorzZoom.addSeparator();
        this.tbHorzZoom.add(new ZoomSelectionStartAction(session, audioFile).createButton(true));
        this.tbHorzZoom.add(new ZoomSelectionStopAction(session, audioFile).createButton(true));
        this.tbHorzZoom.addSeparator();
        this.tbHorzZoom.add(new ZoomInAction(session, audioFile).createButton(true));
        this.tbHorzZoom.add(new ZoomOutAction(session, audioFile).createButton(true));
        this.tbHorzZoom.add(new FitHorzAction(session, audioFile).createButton(true));
        gbc.anchor = 10;
        this.add((Component)this.tbHorzZoom, gbc);
        this.tbVertZoom = new JToolBar();
        this.tbVertZoom.setFloatable(false);
        this.tbVertZoom.setOpaque(false);
        this.tbVertZoom.add(new ZoomInVertAction(session, audioFile).createButton(true));
        this.tbVertZoom.add(new ZoomOutVertAction(session, audioFile).createButton(true));
        this.tbVertZoom.add(new FitVertAction(session, audioFile).createButton(true));
        gbc.anchor = 22;
        this.add((Component)this.tbVertZoom, gbc);
        audioFile.addLockListener(this);
        AwtTools.addKeyboardShortcut(this.btnViewConfig, KeyStroke.getKeyStroke('*'), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AudioFile file = session.getCurrentFile();
                FilePanel p = filePanel.getPanelFor(file);
                if (p != null) {
                    p.fitHeight();
                }
            }
        });
        AwtTools.addKeyboardShortcut(this.btnViewConfig, KeyStroke.getKeyStroke('/'), new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AudioFile file = session.getCurrentFile();
                FilePanel p = filePanel.getPanelFor(file);
                if (p != null) {
                    p.distributeHeight();
                }
            }
        });
    }

    public void lockStatusChanged(ILockable lockable, boolean readLocked, final boolean writeLocked) {
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                if (FileControlPanel.this.cbViewType != null) {
                    FileControlPanel.this.cbViewType.setEnabled(!writeLocked);
                }
            }
        });
    }

    public void dispose() {
        this.audioFile.removeLockListener(this);
        this.cbViewType = null;
        this.btnViewConfig = null;
        AwtTools.cleanupComponents(this.tbHorzZoom);
        AwtTools.cleanupComponents(this.tbVertZoom);
        this.tbHorzZoom = null;
        this.tbVertZoom = null;
    }
}

